/**
 * ---------------------------------------------------------------------
 * $Id: SimuladorPila.java,v 1.0 2013/08/23 
 * Universidad Francisco de Paula Santander 
 * Programa Ingenieria de Sistemas
 *
 * Proyecto: SEED_UFPS
 * ----------------------------------------------------------------------
 */

package Mundo_Pila;

import Colecciones_SEED.Pila;

/**
 * Clase que conecta la capa de presentación del Simulador con las Estructuras de Datos.
 * @author Uriel Garcia - Yulieth Pabon
 * @version 1.0
 */

public class SimuladorPila {
    
    private Pila<Integer> miPila;
    
    
    public SimuladorPila(){
        this.miPila = new Pila();
    }

    public int conocerTamanio() {
        return (this.miPila.getTamanio());
    }

    public void apilarDato(int dato) {
        this.miPila.apilar(dato);
    }

    public boolean estaVaciaPila() {
        return (this.miPila.esVacia());
    }

    public int desapilarDato() {
        return (this.miPila.desapilar());
    }

    public void vaciarPila() {
        this.miPila.vaciar();
    }
    
    public int[] impPila(){
        Pila<Integer> aux = new Pila<Integer>();
        int v[] = new int[this.miPila.getTamanio()];
        int i=0;
        while(!this.miPila.esVacia()){
            int d = this.miPila.desapilar();
            aux.apilar(d);
            v[i++] = d;
        }
        while(!aux.esVacia())
            this.miPila.apilar(aux.desapilar());
        return (v);
    }
    
}
