/**
 * ---------------------------------------------------------------------
 * $Id: Simulador.java,v 1.0 2013/08/23 
 * Universidad Francisco de Paula Santander 
 * Programa Ingenieria de Sistemas
 *
 * Proyecto: SEED_UFPS
 * ----------------------------------------------------------------------
 */


package simpila;



import Mundo_Pila.SimuladorPila;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.image.ImageView;
import javafx.scene.paint.Color;
import javafx.scene.shape.Rectangle;
import javafx.util.Duration;

/**
 * Clase controlador del Vista.FXML donde se crean y manipulan los componente javafx de la Aplicacion.
 * @author Uriel Garcia - Yulieth Pabon
 * @version 1.0
 */

public class Simulador implements Initializable {
    
    @FXML   private     ImageView       borde, borde2, borde3;
    @FXML   private     Rectangle       nodo0, nodo1, nodo2, nodo3, nodo4, nodo5, nodo6, nodo7, nodo8, nodo9, nodo10, piv, nodoNull;
    @FXML   private     TextField       txtIns;    
    @FXML   private     Label           label0, label1, label2, label3, label4, label5, label6, label7, label8, label9, label10, nota, labelPiv, msg, labelNull;       
    @FXML   private     Timeline        lineaTiempo;    
    @FXML   private     SimuladorPila   simulador;
    @FXML   private     ImageView       tope;
    @FXML   private     Rectangle   imgs[];
    @FXML   private     Label       labels[];
    

    
    @FXML
    private void btApilar(ActionEvent event){        
        try{
            String val = txtIns.getText();
            txtIns.setText("");
            if(val.isEmpty()){
                impNota("Debe ingresar el valor que desea Apilar!",1);
                return;
            }        
            if(!esNumero(val)){
                impNota("Debe ingresar un valor numerico!",1);
                return;
            } 
            if(this.simulador==null){
                impNota("No se puede Apilar el Elemento!",1);
                return;
            }
            if(this.simulador.conocerTamanio()>=11){
                impNota("La Pila no puede crear mas Elementos!",1);
                return;
            }
            int dato = Integer.parseInt(val);
            if(dato>=1000 || dato<=(-100)){
                impNota("El valor ingresado supera el rango permitido: -99 a 999!",1);
                return;
            } 
            
            //Realizacion de la insercion
            this.simulador.apilarDato(dato);
            this.pintarTDA(); 
            this.animacion(0,dato);
            impNota("Se Inserto el elemento '"+dato+"' en el Tope de la Pila!",0);   
        }catch(Exception e){
            impNota("No se puede Apilar el Elemento!",1);
        }
    }
    
    @FXML
    private void btDesapilar(ActionEvent event){
        try{
            if(this.simulador==null){
                impNota("No se puede desapilar el Elemento!",1);
                return;
            }
            if(this.simulador.estaVaciaPila()){
                impNota("La Pila no posee elementos!",1);
                return;
            }
            
            //Desapilar
            int dato = this.simulador.desapilarDato();
            this.pintarTDA();
            this.animacion(1,dato);
            impNota("Se ha Desapilado el elemento '"+dato+"' del tope de la Pila!",0);            

        }catch(Exception e){
            impNota("No se puede desapilar el Elemento!",1);
        }
    }
    
    @FXML
    private void btTam(ActionEvent event){
        try{
            if(this.simulador==null){
                impNota("Debe crear primero una Pila!",1);
                return;
            } 
            msg.setText("Tamaño de la Pila: "+this.simulador.conocerTamanio()+" Elementos!");
            msg.setVisible(true);                        
            this.impNota("Se ha determinado el Tamaño de la Pila", 0);
        }catch(Exception e){
            impNota("No se puede determinar el Tamaño!",1);
            msg.setVisible(false);
        }
    }
    
    @FXML
    private void salir(ActionEvent event){
        System.exit(0);
    }
    
    @FXML
    private void btReset(ActionEvent event){
        //Validacion de la entrada        
        try{
            this.simulador.vaciarPila();
            this.pintarTDA();
            impNota("Se ha reiniciado la Pila!",0);
        }catch(Exception e){
            impNota("No se puede reiniciar la Pila!",1);
        }
        
    }    
    
    @FXML
    private void inicializar(){         
        //cargar el vector de labels
        this.label0.setVisible(false);this.label1.setVisible(false);this.label2.setVisible(false);
        this.label3.setVisible(false);this.label4.setVisible(false);this.label5.setVisible(false);
        this.label6.setVisible(false);this.label7.setVisible(false);this.label8.setVisible(false);
        this.label9.setVisible(false);this.label10.setVisible(false);
        this.labels[0]=label0;this.labels[1]=label1;this.labels[2]=label2;
        this.labels[3]=label3;this.labels[4]=label4;this.labels[5]=label5;
        this.labels[6]=label6;this.labels[7]=label7;this.labels[8]=label8;
        this.labels[9]=label9;this.labels[10]=label10;
        //cargar los Nodos rectangulos
        this.nodo0.setVisible(false);this.nodo1.setVisible(false);this.nodo2.setVisible(false);
        this.nodo3.setVisible(false);this.nodo4.setVisible(false);this.nodo5.setVisible(false);
        this.nodo6.setVisible(false);this.nodo7.setVisible(false);this.nodo8.setVisible(false);
        this.nodo9.setVisible(false);this.nodo10.setVisible(false);
        this.imgs[0]=nodo0;this.imgs[1]=nodo1;this.imgs[2]=nodo2;
        this.imgs[3]=nodo3;this.imgs[4]=nodo4;this.imgs[5]=nodo5;
        this.imgs[6]=nodo6;this.imgs[7]=nodo7;this.imgs[8]=nodo8;
        this.imgs[9]=nodo9;this.imgs[10]=nodo10;
        //hacer invisible el mensaje
        msg.setVisible(false); this.tope.setVisible(false); this.nodoNull.setVisible(false); this.labelNull.setVisible(false);
        this.piv.setVisible(false); this.labelPiv.setVisible(false);
    }
    
    @FXML
    private void impNota(String nota, int tipo){
         String cab = "";
        if(tipo==0){
            cab="Exito, ";
            this.nota.setTextFill(Color.BLACK);
            this.borde.setImage(borde2.getImage());
        }            
        if(tipo==1){
            cab="Error, ";
            this.nota.setTextFill(Color.BLACK);
            this.borde.setImage(borde3.getImage());
        }
        this.nota.setVisible(true);
        this.nota.setText(cab+nota);
    }
    
    @FXML
    private boolean esNumero(String val){
        try{
            Integer.parseInt(val);
        }catch(Exception e){
            return (false);
        }
        return (true);
    }

    @FXML
    @Override
    public void initialize(URL url, ResourceBundle rb) {
        try{
            impNota("El Simulador para Pila<T> ha iniciado!",0);
            this.simulador = new SimuladorPila();
            this.imgs = new Rectangle[12];
            this.labels = new Label[12];
            inicializar();
            this.pintarTDA();
        }catch(Exception e){
            impNota("El Simulador para Pila<T> no puede iniciar!",1);
        }
        
    }
    
     private void pintarTDA(){
        this.inicializar();
        if(this.simulador.estaVaciaPila()){
            nodoNull.setFill(Color.GRAY);
            labelNull.setText("<NULL>");
            nodoNull.setVisible(true);
            labelNull.setVisible(true);
            this.tope.setLayoutY(420);
            this.tope.setVisible(true);
            return;   
        }
        double ly = 420.0;
        int pila[] = this.simulador.impPila();
        for(int i=pila.length-1; i>=0 && i<11 ; i--){
            int val = pila[i];
            this.imgs[i].setLayoutY(ly);
            this.imgs[i].setVisible(true);
            this.labels[i].setLayoutY(ly+5);
            this.labels[i].setText(val+"");
            this.labels[i].setVisible(true);
            ly = ly - 25.0;
        }
        this.tope.setLayoutY(ly+25);
        this.tope.setVisible(true);
     }

    private void animacion(int tipo, int dato) {
        msg.setVisible(false);
        lineaTiempo = new Timeline();
        lineaTiempo.setCycleCount(1); 
        KeyFrame f1=null,f11=null,f2=null,f22=null,f3=null,f33=null,f4=null,f44=null, 
                f5=null, f55=null, f6=null, f66=null, f7=null, f77=null;
        double durac = 2000;      
        switch(tipo){
            //Apilar
            case 0 : 
                piv.setLayoutX(138.0);
                piv.setLayoutY(290.0);
                labelPiv.setLayoutX(138.0);
                labelPiv.setLayoutY(295.0);
                labelPiv.setText(dato+"");
                f1 = new KeyFrame(Duration.ZERO, new KeyValue(piv.translateXProperty(),0));
                f11 = new KeyFrame(Duration.ZERO, new KeyValue(labelPiv.translateXProperty(),0));
                f2 = new KeyFrame(new Duration(durac), new KeyValue(piv.translateXProperty(),(this.imgs[0].getLayoutX()-138)));
                f22 = new KeyFrame(new Duration(durac), new KeyValue(labelPiv.translateXProperty(),(this.imgs[0].getLayoutX()-138)));
                f3 = new KeyFrame(Duration.ZERO, new KeyValue(piv.translateYProperty(),0));
                f33 = new KeyFrame(new Duration(durac), new KeyValue(piv.translateYProperty(),(this.labels[0].getLayoutY()-295)));
                f4 = new KeyFrame(Duration.ZERO, new KeyValue(labelPiv.translateYProperty(),0));
                f44 = new KeyFrame(new Duration(durac), new KeyValue(labelPiv.translateYProperty(),(this.labels[0].getLayoutY()-295)));
                f5 = new KeyFrame(Duration.ZERO, new KeyValue(piv.fillProperty(), Color.GREEN));
                f55 = new KeyFrame(new Duration(durac), new KeyValue(piv.fillProperty(),Color.web("#a199ff")));
                f6 = new KeyFrame(new Duration(durac), new KeyValue(piv.visibleProperty(),true));
                f66 = new KeyFrame(new Duration(durac+500), new KeyValue(piv.visibleProperty(),false));
                f7 = new KeyFrame(new Duration(durac), new KeyValue(labelPiv.visibleProperty(),true));
                f77 = new KeyFrame(new Duration(durac+500), new KeyValue(labelPiv.visibleProperty(),false));
                break;
                //Desapilar
             case 1 :
                piv.setLayoutX(this.imgs[0].getLayoutX());
                piv.setLayoutY(this.imgs[0].getLayoutY()-25.0);
                labelPiv.setLayoutX(labels[0].getLayoutX());
                labelPiv.setLayoutY(labels[0].getLayoutY()-25);
                labelPiv.setText(dato+"");                
                f1 = new KeyFrame(Duration.ZERO, new KeyValue(piv.translateXProperty(),0));
                f11 = new KeyFrame(Duration.ZERO, new KeyValue(labelPiv.translateXProperty(),0));
                f2 = new KeyFrame(new Duration(durac), new KeyValue(piv.translateXProperty(),-(this.imgs[0].getLayoutX()-138)));
                f22 = new KeyFrame(new Duration(durac), new KeyValue(labelPiv.translateXProperty(),-(this.imgs[0].getLayoutX()-138)));
                f3 = new KeyFrame(Duration.ZERO, new KeyValue(piv.translateYProperty(),0));
                f33 = new KeyFrame(new Duration(durac), new KeyValue(piv.translateYProperty(),-((this.imgs[0].getLayoutY()-25.0)-295)));
                f4 = new KeyFrame(Duration.ZERO, new KeyValue(labelPiv.translateYProperty(),0));
                f44 = new KeyFrame(new Duration(durac), new KeyValue(labelPiv.translateYProperty(),-((this.imgs[0].getLayoutY()-25.0)-295)));
                f5 = new KeyFrame(Duration.ZERO, new KeyValue(piv.fillProperty(), Color.web("#a199ff")));
                f55 = new KeyFrame(new Duration(durac), new KeyValue(piv.fillProperty(),Color.RED));
                f6 = new KeyFrame(new Duration(durac), new KeyValue(piv.visibleProperty(),true));
                f66 = new KeyFrame(new Duration(durac+500), new KeyValue(piv.visibleProperty(),false));
                f7 = new KeyFrame(new Duration(durac), new KeyValue(labelPiv.visibleProperty(),true));
                f77 = new KeyFrame(new Duration(durac+500), new KeyValue(labelPiv.visibleProperty(),false));
                break;
        }
        piv.setVisible(true);
        labelPiv.setVisible(true);
        lineaTiempo.getKeyFrames().addAll(f1,f11,f2,f22,f3,f33,f4,f44,f5,f55,f6,f66,f7,f77);
        lineaTiempo.play();
    }
    
}
