/*
 * Decompiled with CFR 0.152.
 */
package Colecciones_SEED;

import Colecciones_SEED.ArbolBinarioBusqueda;
import Colecciones_SEED.NodoAVL;
import Colecciones_SEED.NodoBin;
import java.util.Iterator;

public class ArbolAVL<T>
extends ArbolBinarioBusqueda<T> {
    public ArbolAVL() {
    }

    public ArbolAVL(T r) {
        super.setRaiz(new NodoAVL<T>(r));
    }

    @Override
    public T getObjRaiz() {
        return super.getObjRaiz();
    }

    @Override
    public boolean insertar(T nuevo) {
        NodoAVL<T> n = new NodoAVL<T>(nuevo);
        return this.insertaAVL((NodoAVL)super.getRaiz(), n);
    }

    private boolean insertaAVL(NodoAVL<T> p, NodoAVL<T> q) {
        if (this.esVacio()) {
            this.setRaiz(q);
            return true;
        }
        int comp = ((Comparable)q.getInfo()).compareTo(p.getInfo());
        if (comp == 0) {
            return false;
        }
        if (comp < 0) {
            if (p.getIzq() == null) {
                p.setIzq(q);
                q.setPadre(p);
                this.balancear(p);
                return true;
            }
            return this.insertaAVL((NodoAVL<T>)p.getIzq(), q);
        }
        if (comp > 0) {
            if (p.getDer() == null) {
                p.setDer(q);
                q.setPadre(p);
                this.balancear(p);
                return true;
            }
            return this.insertaAVL((NodoAVL<T>)p.getDer(), q);
        }
        return false;
    }

    private void balancear(NodoAVL<T> r) {
        this.setBalance(r);
        int balance = r.getBal();
        if (balance == -2) {
            r = this.getAlturaNodo((NodoAVL<T>)((NodoAVL)r.getIzq()).getIzq()) >= this.getAlturaNodo((NodoAVL<T>)((NodoAVL)r.getIzq()).getDer()) ? this.rDerecha(r) : this.drIzqDer(r);
        } else if (balance == 2) {
            r = this.getAlturaNodo((NodoAVL<T>)((NodoAVL)r.getDer()).getDer()) >= this.getAlturaNodo((NodoAVL<T>)((NodoAVL)r.getDer()).getIzq()) ? this.rIzquierda(r) : this.drDerIzq(r);
        }
        if (r.getPadre() != null) {
            this.balancear(r.getPadre());
        } else {
            this.setRaiz(r);
        }
    }

    public void balancearAltura() {
        this.balancearAltura((NodoAVL)super.getRaiz());
    }

    private void balancearAltura(NodoAVL<T> r) {
        if (r == null) {
            return;
        }
        this.setBalance(r);
        this.balancearAltura((NodoAVL<T>)r.getIzq());
        this.balancearAltura((NodoAVL<T>)r.getDer());
    }

    private void setBalance(NodoAVL<T> r) {
        r.setBal(this.getAlturaNodo((NodoAVL<T>)r.getDer()) - this.getAlturaNodo((NodoAVL<T>)r.getIzq()));
    }

    private int getAlturaNodo(NodoAVL<T> r) {
        if (r == null) {
            return -1;
        }
        if (r.getIzq() == null && r.getDer() == null) {
            return 0;
        }
        if (r.getIzq() == null) {
            return 1 + this.getAlturaNodo((NodoAVL<T>)r.getDer());
        }
        if (r.getDer() == null) {
            return 1 + this.getAlturaNodo((NodoAVL<T>)r.getIzq());
        }
        return 1 + this.getMax(this.getAlturaNodo((NodoAVL<T>)r.getIzq()), this.getAlturaNodo((NodoAVL<T>)r.getDer()));
    }

    private int getMax(int a, int b) {
        if (a >= b) {
            return a;
        }
        return b;
    }

    private NodoAVL<T> drIzqDer(NodoAVL<T> r) {
        r.setIzq(this.rIzquierda((NodoAVL<T>)r.getIzq()));
        return this.rDerecha(r);
    }

    private NodoAVL<T> drDerIzq(NodoAVL<T> r) {
        r.setDer(this.rDerecha((NodoAVL<T>)r.getDer()));
        return this.rIzquierda(r);
    }

    private NodoAVL<T> rIzquierda(NodoAVL<T> r) {
        NodoBin v = r.getDer();
        ((NodoAVL)v).setPadre(r.getPadre());
        r.setDer((NodoAVL<T>)((NodoAVL)v).getIzq());
        if (r.getDer() != null) {
            ((NodoAVL)r.getDer()).setPadre(r);
        }
        ((NodoAVL)v).setIzq(r);
        r.setPadre((NodoAVL<T>)v);
        if (((NodoAVL)v).getPadre() != null) {
            if (((NodoAVL)v).getPadre().getDer() == r) {
                ((NodoAVL)v).getPadre().setDer(v);
            } else if (((NodoAVL)v).getPadre().getIzq() == r) {
                ((NodoAVL)v).getPadre().setIzq(v);
            }
        }
        this.setBalance(r);
        this.setBalance((NodoAVL<T>)v);
        return v;
    }

    private NodoAVL<T> rDerecha(NodoAVL<T> r) {
        NodoBin v = r.getIzq();
        ((NodoAVL)v).setPadre(r.getPadre());
        r.setIzq((NodoAVL<T>)((NodoAVL)v).getDer());
        if (r.getIzq() != null) {
            ((NodoAVL)r.getIzq()).setPadre(r);
        }
        ((NodoAVL)v).setDer(r);
        r.setPadre((NodoAVL<T>)v);
        if (((NodoAVL)v).getPadre() != null) {
            if (((NodoAVL)v).getPadre().getDer() == r) {
                ((NodoAVL)v).getPadre().setDer(v);
            } else if (((NodoAVL)v).getPadre().getIzq() == r) {
                ((NodoAVL)v).getPadre().setIzq(v);
            }
        }
        this.setBalance(r);
        this.setBalance((NodoAVL<T>)v);
        return v;
    }

    @Override
    public boolean eliminar(T dato) {
        if (this.esVacio() || !this.esta(dato)) {
            return false;
        }
        return this.eliminarAVL((NodoAVL)super.getRaiz(), dato);
    }

    private boolean eliminarAVL(NodoAVL<T> p, T q) {
        int comp = ((Comparable)p.getInfo()).compareTo(q);
        if (comp == 0) {
            return this.eliminaAVL(p);
        }
        if (comp > 0) {
            return this.eliminarAVL((NodoAVL<T>)p.getIzq(), q);
        }
        return this.eliminarAVL((NodoAVL<T>)p.getDer(), q);
    }

    private boolean eliminaAVL(NodoAVL<T> q) {
        NodoAVL<T> s;
        if (q.getIzq() == null || q.getDer() == null) {
            if (q.getPadre() == null) {
                if (q.getIzq() != null) {
                    ((NodoAVL)q.getIzq()).setPadre(null);
                    this.setRaiz(q.getIzq());
                } else if (q.getDer() != null) {
                    ((NodoAVL)q.getDer()).setPadre(null);
                    this.setRaiz(q.getDer());
                } else {
                    this.setRaiz(null);
                }
                return true;
            }
            s = q;
        } else {
            s = this.getSucesor(q);
            q.setInfo(s.getInfo());
        }
        NodoBin p = s.getIzq() != null ? s.getIzq() : s.getDer();
        if (p != null) {
            ((NodoAVL)p).setPadre(s.getPadre());
        }
        if (s.getPadre() == null) {
            this.setRaiz(p);
        } else {
            if (s == s.getPadre().getIzq()) {
                s.getPadre().setIzq((NodoAVL<T>)p);
            } else {
                s.getPadre().setDer((NodoAVL<T>)p);
            }
            this.balancear(s.getPadre());
        }
        s = null;
        return true;
    }

    private NodoAVL<T> getSucesor(NodoAVL<T> q) {
        if (q.getDer() != null) {
            NodoBin r = q.getDer();
            while (((NodoAVL)r).getIzq() != null) {
                r = ((NodoAVL)r).getIzq();
            }
            return r;
        }
        NodoAVL<T> p = q.getPadre();
        while (p != null && q == p.getDer()) {
            q = p;
            p = q.getPadre();
        }
        return p;
    }

    @Override
    public boolean esta(T x) {
        return super.estaABB(x);
    }

    @Override
    public Iterator<T> getHojas() {
        return super.getHojas();
    }

    @Override
    public int contarHojas() {
        return super.contarHojas();
    }

    @Override
    public Iterator<T> preOrden() {
        return super.preOrden();
    }

    @Override
    public Iterator<T> inOrden() {
        return super.inOrden();
    }

    @Override
    public Iterator<T> postOrden() {
        return super.postOrden();
    }

    @Override
    public Iterator<T> impNiveles() {
        return super.impNiveles();
    }

    @Override
    public int getPeso() {
        return super.getPeso();
    }

    @Override
    public boolean esVacio() {
        return super.esVacio();
    }

    @Override
    public int getAltura() {
        return super.getAltura();
    }

    @Override
    public void imprime() {
        System.out.println(" ----- Arbol AVL ----- ");
        this.imprimeAVL((NodoAVL)super.getRaiz());
    }

    public void imprimeAVL(NodoAVL<T> n) {
        int l = 0;
        int r = 0;
        int p = 0;
        if (n == null) {
            return;
        }
        if (n.getIzq() != null) {
            l = Integer.parseInt(((NodoAVL)n.getIzq()).getInfo().toString());
        }
        if (n.getDer() != null) {
            r = Integer.parseInt(((NodoAVL)n.getDer()).getInfo().toString());
        }
        if (n.getPadre() != null) {
            p = Integer.parseInt(n.getPadre().getInfo().toString());
        }
        System.out.println("NodoIzq: " + l + "\t Info: " + n.getInfo() + "\t NodoDer: " + r + "\t Padre: " + p + "\t Balance: " + n.getBal());
        if (n.getIzq() != null) {
            this.imprimeAVL((NodoAVL<T>)n.getIzq());
        }
        if (n.getDer() != null) {
            this.imprimeAVL((NodoAVL<T>)n.getDer());
        }
    }
}

