/*
 * Decompiled with CFR 0.152.
 */
package Colecciones_SEED;

import Colecciones_SEED.ListaCD;

public class Vertice<T> {
    private T info;
    private ListaCD<Vertice> vecinos;
    private Vertice predecesor;
    private boolean esVisit;

    public Vertice(T info) {
        this.info = info;
        this.vecinos = new ListaCD();
        this.esVisit = false;
        this.predecesor = null;
    }

    public T getInfo() {
        return this.info;
    }

    public ListaCD<Vertice> getVecinos() {
        return this.vecinos;
    }

    public Vertice getPredecesor() {
        return this.predecesor;
    }

    public boolean getVisit() {
        return this.esVisit;
    }

    public void setInfo(T info) {
        this.info = info;
    }

    public void setVecinos(ListaCD<Vertice> vec) {
        this.vecinos = vec;
    }

    public void setPredecesor(Vertice predecesor) {
        this.predecesor = predecesor;
    }

    public void setVisit(boolean esVisit) {
        this.esVisit = esVisit;
    }

    public boolean equals(Vertice v) {
        return this.info.equals(v.getInfo());
    }

    public void insertarVecino(Vertice v) {
        this.vecinos.insertarAlFinal(v);
    }

    public void eliminarVecino(Vertice v) {
        ListaCD<Vertice> l = new ListaCD<Vertice>();
        for (Vertice vert : this.vecinos) {
            if (vert.equals(v)) continue;
            l.insertarAlFinal(vert);
        }
        this.vecinos = l;
    }

    public boolean esAdyacente(Vertice v) {
        for (Vertice vert : this.vecinos) {
            if (!vert.getInfo().equals(v.getInfo())) continue;
            return true;
        }
        return false;
    }

    public boolean esAisladoND() {
        for (Vertice v : this.vecinos) {
            if (v.equals(this)) continue;
            return false;
        }
        return true;
    }

    public boolean esHojaND() {
        int i = 0;
        for (Vertice v : this.vecinos) {
            if (v.equals(this) || ++i <= 1) continue;
            return false;
        }
        return i == 1;
    }

    public int getGradoND() {
        return this.vecinos.getTamanio();
    }

    public String toString() {
        return this.info.toString();
    }
}

