/*
 * Decompiled with CFR 0.152.
 */
package Graficos;

import Colecciones_SEED.Cola;
import Colecciones_SEED.ListaCD;
import Colecciones_SEED.Pagina;
import Colecciones_SEED.Pila;
import Graficos.PaginaG;
import java.util.Iterator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.value.WritableValue;
import javafx.scene.control.Label;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Line;
import javafx.scene.shape.Rectangle;
import javafx.util.Duration;

public class ArbolBG {
    private PaginaG raiz = null;
    private int n;
    private int m;
    private int m1;
    private Pila<Rectangle> pila;
    private Pila<Label> lab;
    private Pila<Line> lin;

    public ArbolBG(int n) {
        this.n = n;
        this.m = n * 2;
        this.m1 = this.m + 1;
        this.pila = new Pila();
        this.lab = new Pila();
        this.lin = new Pila();
    }

    public PaginaG getRaiz() {
        return this.raiz;
    }

    public Pila<Rectangle> getPila() {
        return this.pila;
    }

    public void setPila(Pila<Rectangle> pila) {
        this.pila = pila;
    }

    public Pila<Label> getLab() {
        return this.lab;
    }

    public void setLab(Pila<Label> lab) {
        this.lab = lab;
    }

    public Pila<Line> getLin() {
        return this.lin;
    }

    public void setLin(Pila<Line> lin) {
        this.lin = lin;
    }

    public void setRaiz(PaginaG raiz) {
        this.raiz = raiz;
    }

    public void crearArbol(Pagina raiz) {
        this.setRaiz(this.crear(raiz));
    }

    private PaginaG crear(Pagina r) {
        if (r == null) {
            return null;
        }
        int[] info = new int[r.getM()];
        for (int i = 0; i < r.getCont(); ++i) {
            info[i] = (Integer)r.getInfo()[i];
        }
        Label[] l = new Label[r.getM()];
        for (int i = 0; i < r.getCont(); ++i) {
            l[i] = this.lab.desapilar();
        }
        PaginaG aux = new PaginaG(r.getN(), info, this.pila.desapilar(), l, r.getCont());
        for (int i = 0; i < aux.getCont() + 1; ++i) {
            aux.getApuntadores()[i] = this.crear(r.getApuntadores()[i]);
        }
        return aux;
    }

    public void cargarNodos(Rectangle[] nodos) {
        for (int i = 0; i < nodos.length; ++i) {
            this.pila.apilar(nodos[i]);
        }
    }

    public void cargarLabels(Label[] labels) {
        for (int i = 0; i < labels.length; ++i) {
            this.lab.apilar(labels[i]);
        }
    }

    public void cargarLineas(Line[] lineas) {
        for (int i = 0; i < lineas.length; ++i) {
            this.lin.apilar(lineas[i]);
        }
    }

    public void pintarArbol(int alt) {
        if (this.raiz == null) {
            Rectangle c = this.pila.desapilar();
            Label l1 = this.lab.desapilar();
            c.setWidth(37.5);
            l1.setPrefWidth(37.5);
            c.setLayoutX(1837.5);
            c.setLayoutY(60.0);
            l1.setLayoutX(1837.5);
            l1.setLayoutY(60.0);
            c.setFill((Paint)Color.GRAY);
            c.setStroke((Paint)Color.BLACK);
            l1.setTextFill((Paint)Color.WHITE);
            l1.setText("Null");
            c.setVisible(true);
            l1.setVisible(true);
            return;
        }
        this.pinta(this.raiz, null, alt);
    }

    private void cargarInfos(PaginaG r) {
        double lx = r.getR().getLayoutX();
        for (int i = 0; i < r.getCont(); ++i) {
            Label l = r.getLabels()[i];
            l.setLayoutX(lx);
            l.setLayoutY(r.getR().getLayoutY());
            l.setText(r.getInfo()[i] + "");
            l.setTextFill((Paint)this.getColor()[i]);
            l.setVisible(true);
            lx += 12.5;
        }
    }

    private Color[] getColor() {
        Color[] c = new Color[]{Color.BLUE, Color.RED, Color.BLACK, Color.GREEN, Color.MAROON, Color.ORANGE};
        return c;
    }

    private void pinta(PaginaG r, PaginaG padre, int alt) {
        switch (r.getN()) {
            case 1: {
                this.pinta1(r, padre, alt);
                break;
            }
            case 2: {
                this.pinta2(r, padre, alt);
                break;
            }
            case 3: {
                this.pinta3(r, padre, alt);
            }
        }
    }

    private void pinta1(PaginaG r, PaginaG padre, int alt) {
        Line l;
        double lx = 0.0;
        if (r == null) {
            return;
        }
        int ajuste = this.calculaAjuste(alt, r.getN());
        if (padre == null) {
            lx = 1837.5;
            r.getR().setWidth(25.0);
            r.getR().setVisible(true);
            r.getR().setLayoutX(lx);
            r.getR().setLayoutY(60.0);
            this.cargarInfos(r);
        }
        if (r.getApuntadores()[0] != null) {
            r.getApuntadores()[0].getR().setWidth(25.0);
            r.getApuntadores()[0].getR().setLayoutX(r.getR().getLayoutX() - 12.5 * (double)ajuste);
            r.getApuntadores()[0].getR().setLayoutY(r.getR().getLayoutY() + 70.0);
            r.getApuntadores()[0].getR().setVisible(true);
            this.cargarInfos(r.getApuntadores()[0]);
            l = this.lin.desapilar();
            l.setLayoutX(r.getR().getLayoutX());
            l.setLayoutY(r.getR().getLayoutY());
            l.setStartX(0.0);
            l.setEndX(-(12.5 * (double)ajuste) + 12.5);
            l.setStartY(20.0);
            l.setEndY(70.0);
            l.setVisible(true);
        }
        if (r.getApuntadores()[1] != null) {
            r.getApuntadores()[1].getR().setWidth(25.0);
            r.getApuntadores()[1].getR().setLayoutX(r.getR().getLayoutX());
            r.getApuntadores()[1].getR().setLayoutY(r.getR().getLayoutY() + 70.0);
            r.getApuntadores()[1].getR().setVisible(true);
            this.cargarInfos(r.getApuntadores()[1]);
            l = this.lin.desapilar();
            l.setLayoutX(r.getR().getLayoutX());
            l.setLayoutY(r.getR().getLayoutY());
            l.setStartX(12.5);
            l.setEndX(12.5);
            l.setStartY(20.0);
            l.setEndY(70.0);
            l.setVisible(true);
        }
        if (r.getApuntadores()[2] != null) {
            r.getApuntadores()[2].getR().setWidth(25.0);
            r.getApuntadores()[2].getR().setLayoutX(r.getR().getLayoutX() + 12.5 * (double)ajuste);
            r.getApuntadores()[2].getR().setLayoutY(r.getR().getLayoutY() + 70.0);
            r.getApuntadores()[2].getR().setVisible(true);
            this.cargarInfos(r.getApuntadores()[2]);
            l = this.lin.desapilar();
            l.setLayoutX(r.getR().getLayoutX());
            l.setLayoutY(r.getR().getLayoutY());
            l.setStartX(25.0);
            l.setEndX(12.5 * (double)ajuste + 12.5);
            l.setStartY(20.0);
            l.setEndY(70.0);
            l.setVisible(true);
        }
        this.pinta1(r.getApuntadores()[0], r, alt - 1);
        this.pinta1(r.getApuntadores()[1], r, alt - 1);
        this.pinta1(r.getApuntadores()[2], r, alt - 1);
    }

    private void pinta2(PaginaG r, PaginaG padre, int alt) {
        Line l;
        double lx = 0.0;
        if (r == null) {
            return;
        }
        int ajuste = this.calculaAjuste(alt, r.getN());
        if (padre == null) {
            lx = 1825.0;
            r.getR().setWidth(50.0);
            r.getR().setVisible(true);
            r.getR().setLayoutX(lx);
            r.getR().setLayoutY(60.0);
            this.cargarInfos(r);
        }
        if (r.getApuntadores()[0] != null) {
            r.getApuntadores()[0].getR().setWidth(50.0);
            r.getApuntadores()[0].getR().setLayoutX(r.getR().getLayoutX() - 12.5 * (double)ajuste);
            r.getApuntadores()[0].getR().setLayoutY(r.getR().getLayoutY() + 90.0);
            r.getApuntadores()[0].getR().setVisible(true);
            this.cargarInfos(r.getApuntadores()[0]);
            l = this.lin.desapilar();
            l.setLayoutX(r.getR().getLayoutX());
            l.setLayoutY(r.getR().getLayoutY());
            l.setStartX(0.0);
            l.setEndX(-(12.5 * (double)ajuste) + 25.0);
            l.setStartY(20.0);
            l.setEndY(90.0);
            l.setVisible(true);
        }
        if (r.getApuntadores()[1] != null) {
            r.getApuntadores()[1].getR().setWidth(50.0);
            r.getApuntadores()[1].getR().setLayoutX(r.getR().getLayoutX() - 12.5 * (double)(ajuste / 2));
            r.getApuntadores()[1].getR().setLayoutY(r.getR().getLayoutY() + 90.0);
            r.getApuntadores()[1].getR().setVisible(true);
            this.cargarInfos(r.getApuntadores()[1]);
            l = this.lin.desapilar();
            l.setLayoutX(r.getR().getLayoutX());
            l.setLayoutY(r.getR().getLayoutY());
            l.setStartX(12.5);
            l.setEndX(-(12.5 * (double)(ajuste / 2)) + 25.0);
            l.setStartY(20.0);
            l.setEndY(90.0);
            l.setVisible(true);
        }
        if (r.getApuntadores()[2] != null) {
            r.getApuntadores()[2].getR().setWidth(50.0);
            r.getApuntadores()[2].getR().setLayoutX(r.getR().getLayoutX());
            r.getApuntadores()[2].getR().setLayoutY(r.getR().getLayoutY() + 90.0);
            r.getApuntadores()[2].getR().setVisible(true);
            this.cargarInfos(r.getApuntadores()[2]);
            l = this.lin.desapilar();
            l.setLayoutX(r.getR().getLayoutX());
            l.setLayoutY(r.getR().getLayoutY());
            l.setStartX(25.0);
            l.setEndX(25.0);
            l.setStartY(20.0);
            l.setEndY(90.0);
            l.setVisible(true);
        }
        if (r.getApuntadores()[3] != null) {
            r.getApuntadores()[3].getR().setWidth(50.0);
            r.getApuntadores()[3].getR().setLayoutX(r.getR().getLayoutX() + 12.5 * (double)(ajuste / 2));
            r.getApuntadores()[3].getR().setLayoutY(r.getR().getLayoutY() + 90.0);
            r.getApuntadores()[3].getR().setVisible(true);
            this.cargarInfos(r.getApuntadores()[3]);
            l = this.lin.desapilar();
            l.setLayoutX(r.getR().getLayoutX());
            l.setLayoutY(r.getR().getLayoutY());
            l.setStartX(37.5);
            l.setEndX(12.5 * (double)(ajuste / 2) + 25.0);
            l.setStartY(20.0);
            l.setEndY(90.0);
            l.setVisible(true);
        }
        if (r.getApuntadores()[4] != null) {
            r.getApuntadores()[4].getR().setWidth(50.0);
            r.getApuntadores()[4].getR().setLayoutX(r.getR().getLayoutX() + 12.5 * (double)ajuste);
            r.getApuntadores()[4].getR().setLayoutY(r.getR().getLayoutY() + 90.0);
            r.getApuntadores()[4].getR().setVisible(true);
            this.cargarInfos(r.getApuntadores()[4]);
            l = this.lin.desapilar();
            l.setLayoutX(r.getR().getLayoutX());
            l.setLayoutY(r.getR().getLayoutY());
            l.setStartX(50.0);
            l.setEndX(12.5 * (double)ajuste + 25.0);
            l.setStartY(20.0);
            l.setEndY(90.0);
            l.setVisible(true);
        }
        this.pinta2(r.getApuntadores()[0], r, alt - 1);
        this.pinta2(r.getApuntadores()[1], r, alt - 1);
        this.pinta2(r.getApuntadores()[2], r, alt - 1);
        this.pinta2(r.getApuntadores()[3], r, alt - 1);
        this.pinta2(r.getApuntadores()[4], r, alt - 1);
    }

    private void pinta3(PaginaG r, PaginaG padre, int alt) {
        Line l;
        double lx = 0.0;
        if (r == null) {
            return;
        }
        int ajuste = this.calculaAjuste(alt, r.getN());
        if (padre == null) {
            lx = 1822.5;
            r.getR().setWidth(75.0);
            r.getR().setVisible(true);
            r.getR().setLayoutX(lx);
            r.getR().setLayoutY(60.0);
            this.cargarInfos(r);
        }
        if (r.getApuntadores()[0] != null) {
            r.getApuntadores()[0].getR().setWidth(75.0);
            r.getApuntadores()[0].getR().setLayoutX(r.getR().getLayoutX() - 12.5 * (double)ajuste);
            r.getApuntadores()[0].getR().setLayoutY(r.getR().getLayoutY() + 100.0);
            r.getApuntadores()[0].getR().setVisible(true);
            this.cargarInfos(r.getApuntadores()[0]);
            l = this.lin.desapilar();
            l.setLayoutX(r.getR().getLayoutX());
            l.setLayoutY(r.getR().getLayoutY());
            l.setStartX(0.0);
            l.setEndX(-(12.5 * (double)ajuste) + 37.5);
            l.setStartY(20.0);
            l.setEndY(100.0);
            l.setVisible(true);
        }
        if (r.getApuntadores()[1] != null) {
            r.getApuntadores()[1].getR().setWidth(75.0);
            if (alt == 3) {
                ajuste -= 42;
            }
            if (alt == 2) {
                ajuste -= 6;
            }
            r.getApuntadores()[1].getR().setLayoutX(r.getR().getLayoutX() - 12.5 * (double)ajuste);
            r.getApuntadores()[1].getR().setLayoutY(r.getR().getLayoutY() + 100.0);
            r.getApuntadores()[1].getR().setVisible(true);
            this.cargarInfos(r.getApuntadores()[1]);
            l = this.lin.desapilar();
            l.setLayoutX(r.getR().getLayoutX());
            l.setLayoutY(r.getR().getLayoutY());
            l.setStartX(12.5);
            l.setEndX(-(12.5 * (double)ajuste) + 37.5);
            l.setStartY(20.0);
            l.setEndY(100.0);
            l.setVisible(true);
        }
        if (r.getApuntadores()[2] != null) {
            r.getApuntadores()[2].getR().setWidth(75.0);
            if (alt == 3) {
                ajuste -= 42;
            }
            if (alt == 2) {
                ajuste -= 6;
            }
            r.getApuntadores()[2].getR().setLayoutX(r.getR().getLayoutX() - 12.5 * (double)ajuste);
            r.getApuntadores()[2].getR().setLayoutY(r.getR().getLayoutY() + 100.0);
            r.getApuntadores()[2].getR().setVisible(true);
            this.cargarInfos(r.getApuntadores()[2]);
            l = this.lin.desapilar();
            l.setLayoutX(r.getR().getLayoutX());
            l.setLayoutY(r.getR().getLayoutY());
            l.setStartX(25.0);
            l.setEndX(-(12.5 * (double)ajuste) + 37.5);
            l.setStartY(20.0);
            l.setEndY(100.0);
            l.setVisible(true);
        }
        if (r.getApuntadores()[3] != null) {
            r.getApuntadores()[3].getR().setWidth(75.0);
            if (alt == 3) {
                ajuste = 42;
            }
            if (alt == 2) {
                ajuste = 6;
            }
            r.getApuntadores()[3].getR().setLayoutX(r.getR().getLayoutX());
            r.getApuntadores()[3].getR().setLayoutY(r.getR().getLayoutY() + 100.0);
            r.getApuntadores()[3].getR().setVisible(true);
            this.cargarInfos(r.getApuntadores()[3]);
            l = this.lin.desapilar();
            l.setLayoutX(r.getR().getLayoutX());
            l.setLayoutY(r.getR().getLayoutY());
            l.setStartX(37.5);
            l.setEndX(37.5);
            l.setStartY(20.0);
            l.setEndY(100.0);
            l.setVisible(true);
        }
        if (r.getApuntadores()[4] != null) {
            r.getApuntadores()[4].getR().setWidth(75.0);
            r.getApuntadores()[4].getR().setLayoutX(r.getR().getLayoutX() + 12.5 * (double)ajuste);
            r.getApuntadores()[4].getR().setLayoutY(r.getR().getLayoutY() + 100.0);
            r.getApuntadores()[4].getR().setVisible(true);
            this.cargarInfos(r.getApuntadores()[4]);
            l = this.lin.desapilar();
            l.setLayoutX(r.getR().getLayoutX());
            l.setLayoutY(r.getR().getLayoutY());
            l.setStartX(50.0);
            l.setEndX(12.5 * (double)ajuste + 37.5);
            l.setStartY(20.0);
            l.setEndY(100.0);
            l.setVisible(true);
        }
        if (r.getApuntadores()[5] != null) {
            r.getApuntadores()[5].getR().setWidth(75.0);
            if (alt == 3) {
                ajuste += 42;
            }
            if (alt == 2) {
                ajuste += 6;
            }
            r.getApuntadores()[5].getR().setLayoutX(r.getR().getLayoutX() + 12.5 * (double)ajuste);
            r.getApuntadores()[5].getR().setLayoutY(r.getR().getLayoutY() + 100.0);
            r.getApuntadores()[5].getR().setVisible(true);
            this.cargarInfos(r.getApuntadores()[5]);
            l = this.lin.desapilar();
            l.setLayoutX(r.getR().getLayoutX());
            l.setLayoutY(r.getR().getLayoutY());
            l.setStartX(62.5);
            l.setEndX(12.5 * (double)ajuste + 37.5);
            l.setStartY(20.0);
            l.setEndY(100.0);
            l.setVisible(true);
        }
        if (r.getApuntadores()[6] != null) {
            r.getApuntadores()[6].getR().setWidth(75.0);
            if (alt == 3) {
                ajuste += 42;
            }
            if (alt == 2) {
                ajuste += 6;
            }
            r.getApuntadores()[6].getR().setLayoutX(r.getR().getLayoutX() + 12.5 * (double)ajuste);
            r.getApuntadores()[6].getR().setLayoutY(r.getR().getLayoutY() + 100.0);
            r.getApuntadores()[6].getR().setVisible(true);
            this.cargarInfos(r.getApuntadores()[6]);
            l = this.lin.desapilar();
            l.setLayoutX(r.getR().getLayoutX());
            l.setLayoutY(r.getR().getLayoutY());
            l.setStartX(75.0);
            l.setEndX(12.5 * (double)ajuste + 37.5);
            l.setStartY(20.0);
            l.setEndY(100.0);
            l.setVisible(true);
        }
        this.pinta3(r.getApuntadores()[0], r, alt - 1);
        this.pinta3(r.getApuntadores()[1], r, alt - 1);
        this.pinta3(r.getApuntadores()[2], r, alt - 1);
        this.pinta3(r.getApuntadores()[3], r, alt - 1);
        this.pinta3(r.getApuntadores()[4], r, alt - 1);
        this.pinta3(r.getApuntadores()[5], r, alt - 1);
        this.pinta3(r.getApuntadores()[6], r, alt - 1);
    }

    private int calculaAjuste(int ajuste, int n) {
        switch (n) {
            case 1: {
                switch (ajuste) {
                    case 1: {
                        return 1;
                    }
                    case 2: {
                        return 2;
                    }
                    case 3: {
                        return 6;
                    }
                    case 4: {
                        return 18;
                    }
                }
                break;
            }
            case 2: {
                switch (ajuste) {
                    case 1: {
                        return 1;
                    }
                    case 2: {
                        return 8;
                    }
                    case 3: {
                        return 40;
                    }
                }
                break;
            }
            case 3: {
                switch (ajuste) {
                    case 1: {
                        return 1;
                    }
                    case 2: {
                        return 18;
                    }
                    case 3: {
                        return 126;
                    }
                }
            }
        }
        return -1;
    }

    public void animacion(int i, int dato, Timeline tl) {
        this.reajustarColores();
        tl = new Timeline();
        tl.setCycleCount(1);
        tl.getKeyFrames().removeAll((Object[])new KeyFrame[0]);
        switch (i) {
            case 0: {
                this.pintarInsertado(dato, tl);
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                this.buscarG(dato, tl);
                break;
            }
            case 3: {
                this.getHojas();
                break;
            }
            case 4: {
                this.getHojas();
                break;
            }
            case 5: {
                this.preOrden(tl);
                break;
            }
            case 6: {
                this.inOrden(tl);
                break;
            }
            case 7: {
                this.postOrden(tl);
                break;
            }
            case 8: {
                this.impNiveles(tl);
            }
        }
    }

    public void pintarInsertado(int dato, Timeline tl) {
        double durac = 0.0;
        PaginaG pag = this.buscar(this.getRaiz(), dato, new Pila<PaginaG>());
        if (pag != null) {
            tl.getKeyFrames().setAll((Object[])new KeyFrame[]{new KeyFrame(new Duration(durac), new KeyValue[]{new KeyValue((WritableValue)pag.getR().strokeProperty(), (Object)Color.BLACK)}), new KeyFrame(new Duration(durac + 1000.0), new KeyValue[]{new KeyValue((WritableValue)pag.getR().strokeProperty(), (Object)Color.RED)}), new KeyFrame(new Duration(durac), new KeyValue[]{new KeyValue((WritableValue)pag.getR().fillProperty(), (Object)Color.WHITE)}), new KeyFrame(new Duration(durac + 1000.0), new KeyValue[]{new KeyValue((WritableValue)pag.getR().fillProperty(), (Object)Color.BEIGE)})});
            tl.play();
        }
    }

    private PaginaG buscar(PaginaG p, int x, Pila<PaginaG> pila) {
        int i = -1;
        boolean encontro = false;
        while (p != null && !encontro) {
            pila.apilar(p);
            i = 0;
            int compara = Integer.valueOf(p.getInfo()[i]).compareTo(x);
            while (compara < 0 && i < p.getCont() - 1) {
                compara = Integer.valueOf(p.getInfo()[++i]).compareTo(x);
            }
            if (compara > 0) {
                p = p.getApuntadores()[i];
                continue;
            }
            if (compara < 0) {
                p = p.getApuntadores()[i + 1];
                continue;
            }
            encontro = true;
        }
        if (encontro) {
            return p;
        }
        return null;
    }

    public boolean buscarG(int x, Timeline tl) {
        ListaCD<PaginaG> l = new ListaCD<PaginaG>();
        if (this.getRaiz() == null) {
            return false;
        }
        boolean rta = this.buscarG(this.getRaiz(), x, new Pila(), l);
        int durac = 0;
        for (int i = 0; i < l.getTamanio(); ++i) {
            PaginaG n = l.get(i);
            tl.getKeyFrames().addAll((Object[])new KeyFrame[]{new KeyFrame(new Duration((double)durac), new KeyValue[]{new KeyValue((WritableValue)n.getR().strokeProperty(), (Object)Color.BLACK)}), new KeyFrame(new Duration((double)(durac + 1000)), new KeyValue[]{new KeyValue((WritableValue)n.getR().strokeProperty(), (Object)Color.RED)})});
            tl.getKeyFrames().addAll((Object[])new KeyFrame[]{new KeyFrame(new Duration((double)durac), new KeyValue[]{new KeyValue((WritableValue)n.getR().fillProperty(), (Object)Color.WHITE)}), new KeyFrame(new Duration((double)(durac + 1000)), new KeyValue[]{new KeyValue((WritableValue)n.getR().fillProperty(), (Object)Color.BEIGE)})});
            durac += 1000;
        }
        tl.play();
        return rta;
    }

    private boolean buscarG(PaginaG p, int x, Pila pila, ListaCD<PaginaG> l) {
        int i = -1;
        boolean encontro = false;
        while (p != null && !encontro) {
            l.insertarAlFinal(p);
            pila.apilar(p);
            i = 0;
            int compara = Integer.valueOf(p.getInfo()[i]).compareTo(x);
            while (compara < 0 && i < p.getCont() - 1) {
                compara = Integer.valueOf(p.getInfo()[++i]).compareTo(x);
            }
            if (compara > 0) {
                p = p.getApuntadores()[i];
                continue;
            }
            if (compara < 0) {
                p = p.getApuntadores()[i + 1];
                continue;
            }
            encontro = true;
        }
        return encontro;
    }

    public void reajustarColores() {
        this.reajustarColores(this.raiz);
    }

    private void reajustarColores(PaginaG r) {
        if (r == null) {
            return;
        }
        r.getR().setFill((Paint)Color.WHITE);
        r.getR().setStroke((Paint)Color.BLACK);
        for (int i = 0; i < r.getCont(); ++i) {
            if (r.getApuntadores()[i] == null) continue;
            this.reajustarColores(r.getApuntadores()[i]);
        }
    }

    public String getLayoutsEliminar(int dato) {
        PaginaG pag = this.buscar(this.raiz, dato, new Pila<PaginaG>());
        double lx1 = 0.0;
        double lx2 = 0.0;
        double lx3 = 0.0;
        double lx4 = 0.0;
        if (pag != null) {
            lx1 = pag.getR().getLayoutX();
            lx2 = pag.getR().getLayoutY();
            Label l = null;
            for (int i = 0; i < pag.getCont(); ++i) {
                if (pag.getInfo()[i] != dato) continue;
                l = pag.getLabels()[i];
            }
            lx1 = lx3 = l.getLayoutX();
            lx2 = lx4 = l.getLayoutY();
        }
        return lx1 + "_" + lx2 + "_" + lx3 + "_" + lx4;
    }

    public void animacionEliminar(String layouts, int dato, Timeline tl, Rectangle r, Label l) {
        tl = new Timeline();
        tl.setCycleCount(1);
        tl.getKeyFrames().removeAll((Object[])new KeyFrame[0]);
        String[] v = layouts.split("_");
        r.setWidth(12.5);
        r.setLayoutX(Double.parseDouble(v[0]));
        r.setLayoutY(Double.parseDouble(v[1]));
        l.setLayoutX(Double.parseDouble(v[2]));
        l.setLayoutY(Double.parseDouble(v[3]));
        l.setText(dato + "");
        r.setVisible(true);
        l.setVisible(true);
        tl.getKeyFrames().addAll((Object[])new KeyFrame[]{new KeyFrame(new Duration(0.0), new KeyValue[]{new KeyValue((WritableValue)r.strokeProperty(), (Object)Color.BLACK)}), new KeyFrame(new Duration(2000.0), new KeyValue[]{new KeyValue((WritableValue)r.strokeProperty(), (Object)Color.RED)})});
        tl.getKeyFrames().addAll((Object[])new KeyFrame[]{new KeyFrame(new Duration(0.0), new KeyValue[]{new KeyValue((WritableValue)r.fillProperty(), (Object)Color.WHITE)}), new KeyFrame(new Duration(2000.0), new KeyValue[]{new KeyValue((WritableValue)r.fillProperty(), (Object)Color.BEIGE)})});
        tl.getKeyFrames().addAll((Object[])new KeyFrame[]{new KeyFrame(new Duration(0.0), new KeyValue[]{new KeyValue((WritableValue)r.translateYProperty(), (Object)0)}), new KeyFrame(new Duration(3000.0), new KeyValue[]{new KeyValue((WritableValue)r.translateYProperty(), (Object)(300.0 - r.getLayoutY()))})});
        tl.getKeyFrames().addAll((Object[])new KeyFrame[]{new KeyFrame(new Duration(0.0), new KeyValue[]{new KeyValue((WritableValue)l.translateYProperty(), (Object)0)}), new KeyFrame(new Duration(3000.0), new KeyValue[]{new KeyValue((WritableValue)l.translateYProperty(), (Object)(300.0 - l.getLayoutY()))})});
        tl.getKeyFrames().addAll((Object[])new KeyFrame[]{new KeyFrame(new Duration(2000.0), new KeyValue[]{new KeyValue((WritableValue)r.visibleProperty(), (Object)true)}), new KeyFrame(new Duration(3000.0), new KeyValue[]{new KeyValue((WritableValue)r.visibleProperty(), (Object)false)})});
        tl.getKeyFrames().addAll((Object[])new KeyFrame[]{new KeyFrame(new Duration(2000.0), new KeyValue[]{new KeyValue((WritableValue)l.visibleProperty(), (Object)true)}), new KeyFrame(new Duration(3000.0), new KeyValue[]{new KeyValue((WritableValue)l.visibleProperty(), (Object)false)})});
        tl.play();
    }

    public void getHojas() {
        this.getHojas(this.raiz);
    }

    private void getHojas(PaginaG r) {
        if (r == null) {
            return;
        }
        if (this.esHoja(r)) {
            r.getR().setFill((Paint)Color.BEIGE);
            r.getR().setStroke((Paint)Color.RED);
        }
        for (int i = 0; i < r.getCont() + 1; ++i) {
            this.getHojas(r.getApuntadores()[i]);
        }
    }

    private boolean esHoja(PaginaG p) {
        int j;
        for (j = 0; p.getApuntadores()[j] == null && j < p.getCont() - 1; ++j) {
        }
        return p.getApuntadores()[j] == null;
    }

    public void preOrden(Timeline tl) {
        int durac = 0;
        ListaCD<PaginaG> l = new ListaCD<PaginaG>();
        this.preOrden(this.getRaiz(), l);
        for (int i = 0; i < l.getTamanio(); ++i) {
            PaginaG n = l.get(i);
            tl.getKeyFrames().addAll((Object[])new KeyFrame[]{new KeyFrame(new Duration((double)durac), new KeyValue[]{new KeyValue((WritableValue)n.getR().strokeProperty(), (Object)Color.BLACK)}), new KeyFrame(new Duration((double)(durac + 1000)), new KeyValue[]{new KeyValue((WritableValue)n.getR().strokeProperty(), (Object)Color.RED)})});
            tl.getKeyFrames().addAll((Object[])new KeyFrame[]{new KeyFrame(new Duration((double)durac), new KeyValue[]{new KeyValue((WritableValue)n.getR().fillProperty(), (Object)Color.WHITE)}), new KeyFrame(new Duration((double)(durac + 1000)), new KeyValue[]{new KeyValue((WritableValue)n.getR().fillProperty(), (Object)Color.BEIGE)})});
            durac += 1000;
        }
        tl.play();
    }

    private void preOrden(PaginaG r, ListaCD<PaginaG> l) {
        if (r == null) {
            return;
        }
        l.insertarAlFinal(r);
        for (int i = 0; i < r.getCont() + 1; ++i) {
            this.preOrden(r.getApuntadores()[i], l);
        }
    }

    public void inOrden(Timeline tl) {
        int durac = 0;
        ListaCD<PaginaG> l = new ListaCD<PaginaG>();
        this.inOrden(this.getRaiz(), l);
        for (int i = 0; i < l.getTamanio(); ++i) {
            PaginaG n = l.get(i);
            tl.getKeyFrames().addAll((Object[])new KeyFrame[]{new KeyFrame(new Duration((double)durac), new KeyValue[]{new KeyValue((WritableValue)n.getR().strokeProperty(), (Object)Color.BLACK)}), new KeyFrame(new Duration((double)(durac + 1000)), new KeyValue[]{new KeyValue((WritableValue)n.getR().strokeProperty(), (Object)Color.RED)})});
            tl.getKeyFrames().addAll((Object[])new KeyFrame[]{new KeyFrame(new Duration((double)durac), new KeyValue[]{new KeyValue((WritableValue)n.getR().fillProperty(), (Object)Color.WHITE)}), new KeyFrame(new Duration((double)(durac + 1000)), new KeyValue[]{new KeyValue((WritableValue)n.getR().fillProperty(), (Object)Color.BEIGE)})});
            durac += 1000;
        }
        tl.play();
    }

    private void inOrden(PaginaG r, ListaCD<PaginaG> l) {
        if (r == null) {
            return;
        }
        this.inOrden(r.getApuntadores()[0], l);
        l.insertarAlFinal(r);
        for (int i = 1; i < r.getCont() + 1; ++i) {
            this.inOrden(r.getApuntadores()[i], l);
        }
    }

    public void postOrden(Timeline tl) {
        int durac = 0;
        ListaCD<PaginaG> l = new ListaCD<PaginaG>();
        this.postOrden(this.getRaiz(), l);
        for (int i = 0; i < l.getTamanio(); ++i) {
            PaginaG n = l.get(i);
            tl.getKeyFrames().addAll((Object[])new KeyFrame[]{new KeyFrame(new Duration((double)durac), new KeyValue[]{new KeyValue((WritableValue)n.getR().strokeProperty(), (Object)Color.BLACK)}), new KeyFrame(new Duration((double)(durac + 1000)), new KeyValue[]{new KeyValue((WritableValue)n.getR().strokeProperty(), (Object)Color.RED)})});
            tl.getKeyFrames().addAll((Object[])new KeyFrame[]{new KeyFrame(new Duration((double)durac), new KeyValue[]{new KeyValue((WritableValue)n.getR().fillProperty(), (Object)Color.WHITE)}), new KeyFrame(new Duration((double)(durac + 1000)), new KeyValue[]{new KeyValue((WritableValue)n.getR().fillProperty(), (Object)Color.BEIGE)})});
            durac += 1000;
        }
        tl.play();
    }

    private void postOrden(PaginaG r, ListaCD<PaginaG> l) {
        if (r == null) {
            return;
        }
        for (int i = 0; i < r.getCont() + 1; ++i) {
            this.postOrden(r.getApuntadores()[i], l);
        }
        l.insertarAlFinal(r);
    }

    public void impNiveles(Timeline tl) {
        int durac = 0;
        ListaCD<PaginaG> l = new ListaCD<PaginaG>();
        this.impNiveles(l);
        for (int i = 0; i < l.getTamanio(); ++i) {
            PaginaG n = l.get(i);
            tl.getKeyFrames().addAll((Object[])new KeyFrame[]{new KeyFrame(new Duration((double)durac), new KeyValue[]{new KeyValue((WritableValue)n.getR().strokeProperty(), (Object)Color.BLACK)}), new KeyFrame(new Duration((double)(durac + 1000)), new KeyValue[]{new KeyValue((WritableValue)n.getR().strokeProperty(), (Object)Color.RED)})});
            tl.getKeyFrames().addAll((Object[])new KeyFrame[]{new KeyFrame(new Duration((double)durac), new KeyValue[]{new KeyValue((WritableValue)n.getR().fillProperty(), (Object)Color.WHITE)}), new KeyFrame(new Duration((double)(durac + 1000)), new KeyValue[]{new KeyValue((WritableValue)n.getR().fillProperty(), (Object)Color.BEIGE)})});
            durac += 1000;
        }
        tl.play();
    }

    public Iterator impNiveles(ListaCD<PaginaG> l) {
        if (!this.esVacio()) {
            Cola<PaginaG> c = new Cola<PaginaG>();
            c.enColar(this.getRaiz());
            while (!c.esVacia()) {
                PaginaG x = (PaginaG)c.deColar();
                if (x == null) continue;
                l.insertarAlFinal(x);
                for (int j = 0; j < x.getCont() + 1; ++j) {
                    c.enColar(x.getApuntadores()[j]);
                }
            }
        }
        return l.iterator();
    }

    public boolean esVacio() {
        return this.raiz == null;
    }
}

