/*
 * Decompiled with CFR 0.152.
 */
package Mundo_ArbolB;

import Colecciones_SEED.ArbolB;
import Graficos.ArbolBG;
import java.util.Iterator;

public class SimuladorArbolB {
    private ArbolB<Integer> miArbolB;

    public boolean crearArbol(int n) {
        if (n <= 0 || n > 3) {
            return false;
        }
        this.miArbolB = new ArbolB(n);
        return true;
    }

    public boolean existeArbol() {
        return this.miArbolB != null;
    }

    public ArbolBG crearArbolBGrafico(ArbolBG n) {
        n.crearArbol(this.miArbolB.getRaiz());
        return n;
    }

    public int conocerAltura() {
        return this.miArbolB.getAltura();
    }

    public int insertarDato(int dato) {
        if (this.miArbolB.esta(dato)) {
            return -1;
        }
        ArbolB<Integer> clon = this.miArbolB.clonar();
        if (clon.insertar(dato)) {
            if (clon.getAltura() > 4 && clon.getN() == 1 || clon.getAltura() > 3 && clon.getN() > 1) {
                return -2;
            }
            this.miArbolB.insertar(dato);
            return 0;
        }
        return -3;
    }

    public boolean estaVacioArbol() {
        return this.miArbolB.esVacio();
    }

    public boolean eliminarDato(int dato) {
        if (!this.miArbolB.esta(dato)) {
            return false;
        }
        return this.miArbolB.eliminar(dato);
    }

    public boolean estaDatoenArbol(int dato) {
        return this.miArbolB.esta(dato);
    }

    public int contarHojas() {
        return this.miArbolB.contarHojas();
    }

    public String obtenerHojas() {
        Iterator<Integer> it = this.miArbolB.getHojas();
        String cad = "";
        while (it.hasNext()) {
            cad = cad + it.next();
            if (it.hasNext()) {
                cad = cad + ", ";
                continue;
            }
            cad = cad + ".";
        }
        return cad;
    }

    public void podarHojas() {
        this.miArbolB.podar();
    }

    public String recorridoPreorden() {
        Iterator<Integer> it = this.miArbolB.preOrden();
        String cad = "";
        int i = 0;
        while (it.hasNext()) {
            cad = cad + it.next().toString();
            cad = it.hasNext() ? cad + ", " : cad + ".";
            if (i == 15) {
                cad = cad + "\n";
            }
            ++i;
        }
        return cad;
    }

    public String recorridoInorden() {
        Iterator<Integer> it = this.miArbolB.inOrden();
        String cad = "";
        int i = 0;
        while (it.hasNext()) {
            cad = cad + it.next().toString();
            cad = it.hasNext() ? cad + ", " : cad + ".";
            if (i == 15) {
                cad = cad + "\n";
            }
            ++i;
        }
        return cad;
    }

    public String recorridoPostorden() {
        Iterator<Integer> it = this.miArbolB.postOrden();
        String cad = "";
        int i = 0;
        while (it.hasNext()) {
            cad = cad + it.next().toString();
            cad = it.hasNext() ? cad + ", " : cad + ".";
            if (i == 15) {
                cad = cad + "\n";
            }
            ++i;
        }
        return cad;
    }

    public String recorridoPorNiveles() {
        Iterator<Integer> it = this.miArbolB.impNiveles();
        String cad = "";
        int i = 0;
        while (it.hasNext()) {
            cad = cad + it.next().toString();
            cad = it.hasNext() ? cad + ", " : cad + ".";
            if (i == 15) {
                cad = cad + "\n";
            }
            ++i;
        }
        return cad;
    }

    public int conocerPeso() {
        return this.miArbolB.getPeso();
    }

    public ArbolB getMiArbolB() {
        return this.miArbolB;
    }

    public void setMiArbolB(ArbolB miArbolB) {
        this.miArbolB = miArbolB;
    }
}

