/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package Graficos;


import Colecciones_SEED.Cola;
import Colecciones_SEED.ListaCD;
import Colecciones_SEED.Pagina;
import Colecciones_SEED.Pila;
import java.util.Iterator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.scene.control.Label;
import javafx.scene.paint.Color;
import javafx.scene.shape.Line;
import javafx.scene.shape.Rectangle;
import javafx.util.Duration;

/**
 *
 * @author usuario
 */
public class ArbolBG {
    
    private PaginaG raiz;
    private int n;
    private int m;
    private int m1;
    private Pila<Rectangle> pila;
    private Pila<Label> lab;
    private Pila<Line> lin;

    public ArbolBG(int n) {
        this.raiz = null;
        this.n=n;
        this.m=n*2;
        this.m1= (this.m)+1;
        pila = new Pila();
        lab = new Pila();
        lin = new Pila();
    }

    public PaginaG getRaiz() {
        return raiz;
    }

    public Pila<Rectangle> getPila() {
        return pila;
    }

    public void setPila(Pila<Rectangle> pila) {
        this.pila = pila;
    }
    
    

    public Pila<Label> getLab() {
        return lab;
    }

    public void setLab(Pila<Label> lab) {
        this.lab = lab;
    }

    public Pila<Line> getLin() {
        return lin;
    }

    public void setLin(Pila<Line> lin) {
        this.lin = lin;
    }

    public void setRaiz(PaginaG raiz){
        this.raiz = raiz;
    }

    
    public void crearArbol(Pagina raiz) {
        this.setRaiz(crear(raiz));
        
    }
    
    private PaginaG crear(Pagina r) {
        if(r==null)
            return (null);
        else
        {   
            int info[] = new int[r.getM()];
            for(int i=0; i<r.getCont();i++){
                info[i] = (int) r.getInfo()[i];
            }
            Label l[] = new Label[r.getM()];
            for(int i=0; i<r.getCont();i++){
                l[i] = this.lab.desapilar();
            }
            PaginaG aux = new PaginaG(r.getN(),info,this.pila.desapilar(),l, r.getCont());
            for(int i=0; i<aux.getCont()+1;i++){
                aux.getApuntadores()[i] = crear(r.getApuntadores()[i]);
            }
            return (aux);
        }
    }

    public void cargarNodos(Rectangle[] nodos) {
        for(int i=0; i<nodos.length; i++)
            this.pila.apilar(nodos[i]);
    }

    public void cargarLabels(Label[] labels) {
        for(int i=0; i<labels.length; i++)
            this.lab.apilar(labels[i]);
    }

    public void cargarLineas(Line[] lineas) {
        for(int i=0; i<lineas.length; i++)
            this.lin.apilar(lineas[i]);
    }
  

    public void pintarArbol(int alt){
        if(this.raiz==null){
            Rectangle c = this.pila.desapilar();
            Label l1 = this.lab.desapilar();   
            c.setWidth(12.5*3);
            l1.setPrefWidth(12.5*3);
            c.setLayoutX(1850.0-12.5);
            c.setLayoutY(60.0);
            l1.setLayoutX(1850.0-12.5);
            l1.setLayoutY(60.0);
            c.setFill(Color.GRAY);
            c.setStroke(Color.BLACK);
            l1.setTextFill(Color.WHITE);
            l1.setText("Null");
            c.setVisible(true);
            l1.setVisible(true);
            return;
        }
        this.pinta(raiz,null,alt);
    }
    
    private void cargarInfos(PaginaG r){
        double lx = r.getR().getLayoutX();
        for (int i=0; i<r.getCont(); i++){
            Label l = r.getLabels()[i];
            l.setLayoutX(lx);
            l.setLayoutY(r.getR().getLayoutY());
            l.setText(r.getInfo()[i]+"");
            l.setTextFill(this.getColor()[i]);
            l.setVisible(true);
            lx+= 12.5;
        }      
    }
    
    private Color[] getColor(){
        Color c[] = new Color[6];
        c[0] = Color.BLUE;
        c[1] = Color.RED;
        c[2] = Color.BLACK;
        c[3] = Color.GREEN;
        c[4] = Color.MAROON;
        c[5] = Color.ORANGE;
        return (c);
    }
    
    private void pinta(PaginaG r, PaginaG padre, int alt){
        switch(r.getN()){
            case 1:
                pinta1(r,padre,alt);
                break;
            case 2:
                pinta2(r,padre,alt);
                break;
            case 3:
                pinta3(r,padre,alt);
                break;
        }
    }

    private void pinta1(PaginaG r, PaginaG padre, int alt) {        
        Line l;
        double lx = 0.0;
        
        if(r==null){
            return;
        }     
        int ajuste = calculaAjuste(alt,r.getN());
        //Si es la raiz
        if(padre==null){
            lx = 1837.5;
            r.getR().setWidth(25.0);
            r.getR().setVisible(true);
            r.getR().setLayoutX(lx);
            r.getR().setLayoutY(60.0);    
            this.cargarInfos(r);                        
        }
    
        //Primer Apuntador.
        if(r.getApuntadores()[0]!=null){            
            r.getApuntadores()[0].getR().setWidth(25.0);
            r.getApuntadores()[0].getR().setLayoutX(r.getR().getLayoutX()-(12.5*ajuste));
            r.getApuntadores()[0].getR().setLayoutY(r.getR().getLayoutY()+70.0);
            r.getApuntadores()[0].getR().setVisible(true);
            this.cargarInfos(r.getApuntadores()[0]);
            l = lin.desapilar();            
            l.setLayoutX(r.getR().getLayoutX());
            l.setLayoutY(r.getR().getLayoutY());
            l.setStartX(0);
            l.setEndX(-(12.5*ajuste)+12.5);
            l.setStartY(20.0);
            l.setEndY(70.0);
            l.setVisible(true);            
        }
        //Segundo Apuntador
        if(r.getApuntadores()[1]!=null){     
            r.getApuntadores()[1].getR().setWidth(25.0);
            r.getApuntadores()[1].getR().setLayoutX(r.getR().getLayoutX());
            r.getApuntadores()[1].getR().setLayoutY(r.getR().getLayoutY()+70.0);
            r.getApuntadores()[1].getR().setVisible(true);
            this.cargarInfos(r.getApuntadores()[1]);
            l = lin.desapilar();            
            l.setLayoutX(r.getR().getLayoutX());
            l.setLayoutY(r.getR().getLayoutY());
            l.setStartX(12.5);
            l.setEndX(12.5);
            l.setStartY(20.0);
            l.setEndY(70.0);
            l.setVisible(true);            
        }
        //Tercer Apuntador
        if(r.getApuntadores()[2]!=null){   
            r.getApuntadores()[2].getR().setWidth(25.0);
            r.getApuntadores()[2].getR().setLayoutX(r.getR().getLayoutX()+(12.5*ajuste));
            r.getApuntadores()[2].getR().setLayoutY(r.getR().getLayoutY()+70.0);
            r.getApuntadores()[2].getR().setVisible(true);
            this.cargarInfos(r.getApuntadores()[2]);
            l = lin.desapilar();            
            l.setLayoutX(r.getR().getLayoutX());
            l.setLayoutY(r.getR().getLayoutY());
            l.setStartX(25.0);
            l.setEndX((12.5*ajuste)+12.5);
            l.setStartY(20.0);
            l.setEndY(70.0);
            l.setVisible(true);            
        }
        this.pinta1(r.getApuntadores()[0], r, alt-1);
        this.pinta1(r.getApuntadores()[1], r, alt-1);
        this.pinta1(r.getApuntadores()[2], r, alt-1);
    }
    
    private void pinta2(PaginaG r, PaginaG padre, int alt) {        
        Line l;
        double lx = 0.0;
        
        if(r==null){
            return;
        }   
        int ajuste = calculaAjuste(alt,r.getN());
        //Si es la raiz
        if(padre==null){
            lx = 1825.0;
            r.getR().setWidth(50.0);
            r.getR().setVisible(true);
            r.getR().setLayoutX(lx);
            r.getR().setLayoutY(60.0);    
            this.cargarInfos(r);                        
        }
    
        //Primer Apuntador.
        if(r.getApuntadores()[0]!=null){            
            r.getApuntadores()[0].getR().setWidth(50.0);
            r.getApuntadores()[0].getR().setLayoutX(r.getR().getLayoutX()-(12.5*ajuste));
            r.getApuntadores()[0].getR().setLayoutY(r.getR().getLayoutY()+90.0);
            r.getApuntadores()[0].getR().setVisible(true);
            this.cargarInfos(r.getApuntadores()[0]);
            l = lin.desapilar();            
            l.setLayoutX(r.getR().getLayoutX());
            l.setLayoutY(r.getR().getLayoutY());
            l.setStartX(0);
            l.setEndX(-(12.5*ajuste)+25.0);
            l.setStartY(20.0);
            l.setEndY(90.0);
            l.setVisible(true);            
        }
        //Segundo Apuntador.
        if(r.getApuntadores()[1]!=null){            
            r.getApuntadores()[1].getR().setWidth(50.0);
            r.getApuntadores()[1].getR().setLayoutX(r.getR().getLayoutX()-(12.5*(ajuste/2)));
            r.getApuntadores()[1].getR().setLayoutY(r.getR().getLayoutY()+90.0);
            r.getApuntadores()[1].getR().setVisible(true);
            this.cargarInfos(r.getApuntadores()[1]);
            l = lin.desapilar();            
            l.setLayoutX(r.getR().getLayoutX());
            l.setLayoutY(r.getR().getLayoutY());
            l.setStartX(12.5);
            l.setEndX(-(12.5*(ajuste/2))+25.0);
            l.setStartY(20.0);
            l.setEndY(90.0);
            l.setVisible(true);            
        }
        //Tercer Apuntador (medio)
        if(r.getApuntadores()[2]!=null){     
            r.getApuntadores()[2].getR().setWidth(50.0);
            r.getApuntadores()[2].getR().setLayoutX(r.getR().getLayoutX());
            r.getApuntadores()[2].getR().setLayoutY(r.getR().getLayoutY()+90.0);
            r.getApuntadores()[2].getR().setVisible(true);
            this.cargarInfos(r.getApuntadores()[2]);
            l = lin.desapilar();            
            l.setLayoutX(r.getR().getLayoutX());
            l.setLayoutY(r.getR().getLayoutY());
            l.setStartX(25.0);
            l.setEndX(25.0);
            l.setStartY(20.0);
            l.setEndY(90.0);
            l.setVisible(true);            
        }
        //Cuarto Apuntador.
        if(r.getApuntadores()[3]!=null){            
            r.getApuntadores()[3].getR().setWidth(50.0);
            r.getApuntadores()[3].getR().setLayoutX(r.getR().getLayoutX()+(12.5*(ajuste/2)));
            r.getApuntadores()[3].getR().setLayoutY(r.getR().getLayoutY()+90.0);
            r.getApuntadores()[3].getR().setVisible(true);
            this.cargarInfos(r.getApuntadores()[3]);
            l = lin.desapilar();            
            l.setLayoutX(r.getR().getLayoutX());
            l.setLayoutY(r.getR().getLayoutY());
            l.setStartX(37.5);
            l.setEndX((12.5*(ajuste/2))+25.0);
            l.setStartY(20.0);
            l.setEndY(90.0);
            l.setVisible(true);            
        }
        //Quinto Apuntador.
        if(r.getApuntadores()[4]!=null){            
            r.getApuntadores()[4].getR().setWidth(50.0);
            r.getApuntadores()[4].getR().setLayoutX(r.getR().getLayoutX()+(12.5*ajuste));
            r.getApuntadores()[4].getR().setLayoutY(r.getR().getLayoutY()+90.0);
            r.getApuntadores()[4].getR().setVisible(true);
            this.cargarInfos(r.getApuntadores()[4]);
            l = lin.desapilar();            
            l.setLayoutX(r.getR().getLayoutX());
            l.setLayoutY(r.getR().getLayoutY());
            l.setStartX(50.0);
            l.setEndX((12.5*ajuste)+25.0);
            l.setStartY(20.0);
            l.setEndY(90.0);
            l.setVisible(true);            
        }
        this.pinta2(r.getApuntadores()[0], r, alt-1);
        this.pinta2(r.getApuntadores()[1], r, alt-1);
        this.pinta2(r.getApuntadores()[2], r, alt-1);
        this.pinta2(r.getApuntadores()[3], r, alt-1);
        this.pinta2(r.getApuntadores()[4], r, alt-1);
    }
    
    private void pinta3(PaginaG r, PaginaG padre, int alt) {        
        Line l;
        double lx = 0.0;
        if(r==null){
            return;
        }   
        int ajuste = calculaAjuste(alt,r.getN());
        //Si es la raiz
        if(padre==null){
            lx = 1822.5;
            r.getR().setWidth(75.0);
            r.getR().setVisible(true);
            r.getR().setLayoutX(lx);
            r.getR().setLayoutY(60.0);    
            this.cargarInfos(r);                        
        }
    
        //Primer Apuntador.
        if(r.getApuntadores()[0]!=null){            
            r.getApuntadores()[0].getR().setWidth(75.0);
            r.getApuntadores()[0].getR().setLayoutX(r.getR().getLayoutX()-(12.5*ajuste));
            r.getApuntadores()[0].getR().setLayoutY(r.getR().getLayoutY()+100.0);
            r.getApuntadores()[0].getR().setVisible(true);
            this.cargarInfos(r.getApuntadores()[0]);
            l = lin.desapilar();            
            l.setLayoutX(r.getR().getLayoutX());
            l.setLayoutY(r.getR().getLayoutY());
            l.setStartX(0);
            l.setEndX(-(12.5*ajuste)+37.5);
            l.setStartY(20.0);
            l.setEndY(100.0);
            l.setVisible(true);            
        }
        
        //Segundo Apuntador.
        if(r.getApuntadores()[1]!=null){            
            r.getApuntadores()[1].getR().setWidth(75.0);
            if(alt==3)
                ajuste = ajuste-42;
            if(alt==2)
                ajuste = ajuste-6;
            r.getApuntadores()[1].getR().setLayoutX(r.getR().getLayoutX()-(12.5*ajuste));
            r.getApuntadores()[1].getR().setLayoutY(r.getR().getLayoutY()+100.0);
            r.getApuntadores()[1].getR().setVisible(true);
            this.cargarInfos(r.getApuntadores()[1]);
            l = lin.desapilar();            
            l.setLayoutX(r.getR().getLayoutX());
            l.setLayoutY(r.getR().getLayoutY());
            l.setStartX(12.5);
            l.setEndX(-(12.5*ajuste)+37.5);
            l.setStartY(20.0);
            l.setEndY(100.0);
            l.setVisible(true);            
        }
        
        //Tercer Apuntador
        if(r.getApuntadores()[2]!=null){            
            r.getApuntadores()[2].getR().setWidth(75.0);
            if(alt==3)
                ajuste = ajuste-42;
            if(alt==2)
                ajuste = ajuste-6;
            r.getApuntadores()[2].getR().setLayoutX(r.getR().getLayoutX()-(12.5*(ajuste)));
            r.getApuntadores()[2].getR().setLayoutY(r.getR().getLayoutY()+100.0);
            r.getApuntadores()[2].getR().setVisible(true);
            this.cargarInfos(r.getApuntadores()[2]);
            l = lin.desapilar();            
            l.setLayoutX(r.getR().getLayoutX());
            l.setLayoutY(r.getR().getLayoutY());
            l.setStartX(25.0);
            l.setEndX(-(12.5*(ajuste))+37.5);
            l.setStartY(20.0);
            l.setEndY(100.0);
            l.setVisible(true);            
        }
        
        
        //Cuarto Apuntador (medio)
        if(r.getApuntadores()[3]!=null){     
            r.getApuntadores()[3].getR().setWidth(75.0);
            if(alt==3)
                ajuste = 42;
            if(alt==2)
                ajuste = 6;
            r.getApuntadores()[3].getR().setLayoutX(r.getR().getLayoutX());
            r.getApuntadores()[3].getR().setLayoutY(r.getR().getLayoutY()+100.0);
            r.getApuntadores()[3].getR().setVisible(true);
            this.cargarInfos(r.getApuntadores()[3]);
            l = lin.desapilar();            
            l.setLayoutX(r.getR().getLayoutX());
            l.setLayoutY(r.getR().getLayoutY());
            l.setStartX(37.5);
            l.setEndX(37.5);
            l.setStartY(20.0);
            l.setEndY(100.0);
            l.setVisible(true);            
        }
        
        //Quinto Apuntador.
        if(r.getApuntadores()[4]!=null){            
            r.getApuntadores()[4].getR().setWidth(75.0);
            r.getApuntadores()[4].getR().setLayoutX(r.getR().getLayoutX()+(12.5*(ajuste)));
            r.getApuntadores()[4].getR().setLayoutY(r.getR().getLayoutY()+100.0);
            r.getApuntadores()[4].getR().setVisible(true);
            this.cargarInfos(r.getApuntadores()[4]);
            l = lin.desapilar();            
            l.setLayoutX(r.getR().getLayoutX());
            l.setLayoutY(r.getR().getLayoutY());
            l.setStartX(50.0);
            l.setEndX((12.5*(ajuste))+37.5);
            l.setStartY(20.0);
            l.setEndY(100.0);
            l.setVisible(true);            
        }
        
        //Sexto Apuntdor
        if(r.getApuntadores()[5]!=null){            
            r.getApuntadores()[5].getR().setWidth(75.0);
            if(alt==3)
                ajuste = ajuste+42;
            if(alt==2)
                ajuste = ajuste+6;
            r.getApuntadores()[5].getR().setLayoutX(r.getR().getLayoutX()+(12.5*(ajuste)));
            r.getApuntadores()[5].getR().setLayoutY(r.getR().getLayoutY()+100.0);
            r.getApuntadores()[5].getR().setVisible(true);
            this.cargarInfos(r.getApuntadores()[5]);
            l = lin.desapilar();            
            l.setLayoutX(r.getR().getLayoutX());
            l.setLayoutY(r.getR().getLayoutY());
            l.setStartX(62.5);
            l.setEndX((12.5*(ajuste))+37.5);
            l.setStartY(20.0);
            l.setEndY(100.0);
            l.setVisible(true);            
        }
        
        //Septimo Apuntdor
        if(r.getApuntadores()[6]!=null){            
            r.getApuntadores()[6].getR().setWidth(75.0);
            if(alt==3)
                ajuste = ajuste+42;
            if(alt==2)
                ajuste = ajuste+6;
            r.getApuntadores()[6].getR().setLayoutX(r.getR().getLayoutX()+(12.5*(ajuste)));
            r.getApuntadores()[6].getR().setLayoutY(r.getR().getLayoutY()+100.0);
            r.getApuntadores()[6].getR().setVisible(true);
            this.cargarInfos(r.getApuntadores()[6]);
            l = lin.desapilar();            
            l.setLayoutX(r.getR().getLayoutX());
            l.setLayoutY(r.getR().getLayoutY());
            l.setStartX(75.0);
            l.setEndX((12.5*(ajuste))+37.5);
            l.setStartY(20.0);
            l.setEndY(100.0);
            l.setVisible(true);            
        }
        
        this.pinta3(r.getApuntadores()[0], r, alt-1);
        this.pinta3(r.getApuntadores()[1], r, alt-1);
        this.pinta3(r.getApuntadores()[2], r, alt-1);
        this.pinta3(r.getApuntadores()[3], r, alt-1);
        this.pinta3(r.getApuntadores()[4], r, alt-1);
        this.pinta3(r.getApuntadores()[5], r, alt-1);
        this.pinta3(r.getApuntadores()[6], r, alt-1);
    }

    private int calculaAjuste(int ajuste, int n) {
        switch(n){
            case 1:
                switch(ajuste){
                    case 1: return (1);
                    case 2: return (2);
                    case 3: return (6);
                    case 4: return (18); 
                }
            break;
           
            case 2:
                switch(ajuste){
                    case 1: return (1);
                    case 2: return (8);
                    case 3: return (40); 
                }
            break;
                
            case 3:
                switch(ajuste){
                    case 1: return (1);
                    case 2: return (18);
                    case 3: return (126); 
                }
            break;
                
        }
        
        
        return (-1);
    }

   public void animacion(int i, int dato, Timeline tl) {
        this.reajustarColores();
        tl = new Timeline();
        tl.setCycleCount(1);
        tl.getKeyFrames().removeAll();
        switch(i){
            //Insertar 0
            case 0:
                this.pintarInsertado(dato, tl);
                break;
            //Eliminar 1
            case 1:                
                break;
            //Buscar 2
            case 2:
                this.buscarG(dato, tl);
                break;
            //Hojas 3
            case 3:
                this.getHojas();
                break;
            //Podar 4
            case 4:
                this.getHojas();
                break;
            // preorden 5
            case 5:
                this.preOrden(tl);
                break;
            // inorden 6
            case 6:
                this.inOrden(tl);
                break;
            //postorden 7
            case 7:
                this.postOrden(tl);
                break;
            //niveles 8
            case 8:
                this.impNiveles(tl);
                break;
        }
    }
    
    /**
     *
     * @param dato
     * @param tl
     */
    public void pintarInsertado(int dato, Timeline tl){
        double durac = 0;
        PaginaG pag = this.buscar(getRaiz(), dato, new Pila<PaginaG>());
        if(pag!=null){
            tl.getKeyFrames().setAll(
            new KeyFrame(new Duration(durac), new KeyValue(pag.getR().strokeProperty(),Color.BLACK)),
            new KeyFrame(new Duration((durac+1000)), new KeyValue(pag.getR().strokeProperty(),Color.RED)),
            new KeyFrame(new Duration(durac), new KeyValue(pag.getR().fillProperty(),Color.WHITE)),
            new KeyFrame(new Duration((durac+1000)), new KeyValue(pag.getR().fillProperty(),Color.BEIGE)));
            tl.play();
        }
    }
    
    private PaginaG buscar(PaginaG p, int x, Pila<PaginaG> pila) {
        int i=-1;
            boolean encontro= false;
            while((p!=null)&&!(encontro)){
                pila.apilar(p);
                i=0;
                int compara=((Comparable)p.getInfo()[i]).compareTo(x);
                while((compara<0)&&(i<(p.getCont()-1))){
                    i++;
                    compara=((Comparable)p.getInfo()[i]).compareTo(x);
                }
                if((compara>0))
                    p=p.getApuntadores()[i];
                else{
                    if(compara<0)
                        p=p.getApuntadores()[i+1];
                    else
                        encontro=true;
                }
            }
            if(encontro)
                return (p);
            return (null);
    }

    
    /**
     *
     * @param x
     * @param tl
     * @return
     */
    public boolean buscarG(int x, Timeline tl){
        ListaCD<PaginaG> l=new ListaCD<PaginaG>();
        if(this.getRaiz()==null)
            return (false);
        boolean rta = this.buscarG(getRaiz(), x, new Pila<PaginaG>(), l);
        int durac = 0;
        for(int i=0; i<l.getTamanio(); i++){
            PaginaG n = l.get(i);
            tl.getKeyFrames().addAll(new KeyFrame(new Duration(durac), new KeyValue(n.getR().strokeProperty(),Color.BLACK)),
            new KeyFrame(new Duration((durac+1000)), new KeyValue(n.getR().strokeProperty(),Color.RED)));
            tl.getKeyFrames().addAll(new KeyFrame(new Duration(durac), new KeyValue(n.getR().fillProperty(),Color.WHITE)),
            new KeyFrame(new Duration((durac+1000)), new KeyValue(n.getR().fillProperty(),Color.BEIGE)));
            durac+=1000;
        }
        tl.play();
        return (rta);
    }
    
    private boolean buscarG(PaginaG p,int x, Pila pila, ListaCD<PaginaG> l){
            int i=-1;
            boolean encontro= false;
            while((p!=null)&&!(encontro)){
                l.insertarAlFinal(p);
                pila.apilar(p);
                i=0;
                int compara=((Comparable)p.getInfo()[i]).compareTo(x);
                while((compara<0)&&(i<(p.getCont()-1))){
                    i++;
                    compara=((Comparable)p.getInfo()[i]).compareTo(x);
                }
                if((compara>0))
                    p=p.getApuntadores()[i];
                else{
                    if(compara<0)
                        p=p.getApuntadores()[i+1];
                    else
                        encontro=true;
                }
            }
            return (encontro);
        }
    
    /**
     *
     */
    public void reajustarColores(){
        this.reajustarColores(raiz);
    }
    
    private void reajustarColores(PaginaG r){
        if(r==null){
            return;
        }
        r.getR().setFill(Color.WHITE);
        r.getR().setStroke(Color.BLACK);
        for(int i=0; i<r.getCont(); i++){
            if(r.getApuntadores()[i]!=null)
                reajustarColores(r.getApuntadores()[i]);
        }
    }

//    private String mostrarInfo(int info) {
//        if(info==(-100))
//            return "-";
//        return (info+"");
//    }
    
    public String getLayoutsEliminar(int dato) {
        PaginaG pag = this.buscar(raiz, dato, new Pila<PaginaG>());
        double lx1=0, lx2=0, lx3=0, lx4=0;
        if(pag!=null){            
            lx1 = pag.getR().getLayoutX();
            lx2 = pag.getR().getLayoutY();
            Label l=null;
            for(int i=0; i<pag.getCont();i++){
                if(pag.getInfo()[i]==dato){
                    l = pag.getLabels()[i];
                }
            }            
            lx1 = lx3 = l.getLayoutX();
            lx2 = lx4 = l.getLayoutY();
        }  
        return (lx1+"_"+lx2+"_"+lx3+"_"+lx4);
    }   

    public void animacionEliminar(String layouts, int dato, Timeline tl, Rectangle r, Label l) {
        tl = new Timeline();
        tl.setCycleCount(1);
        tl.getKeyFrames().removeAll();
        String v[] = layouts.split("_");
        r.setWidth(12.5);
        r.setLayoutX(Double.parseDouble(v[0]));
        r.setLayoutY(Double.parseDouble(v[1]));
        //pasa saber cual dato fue eliminado.
        l.setLayoutX(Double.parseDouble(v[2]));
        l.setLayoutY(Double.parseDouble(v[3]));
       
        l.setText(dato+"");
        r.setVisible(true);
        l.setVisible(true);
        
        tl.getKeyFrames().addAll(new KeyFrame(new Duration(0), new KeyValue(r.strokeProperty(),Color.BLACK)),
        new KeyFrame(new Duration(2000), new KeyValue(r.strokeProperty(),Color.RED)));
        tl.getKeyFrames().addAll(new KeyFrame(new Duration(0), new KeyValue(r.fillProperty(),Color.WHITE)),
        new KeyFrame(new Duration(2000), new KeyValue(r.fillProperty(),Color.BEIGE)));            
        tl.getKeyFrames().addAll(new KeyFrame(new Duration(0), new KeyValue(r.translateYProperty(),0)),
        new KeyFrame(new Duration(3000), new KeyValue(r.translateYProperty(),300-r.getLayoutY())));            
        tl.getKeyFrames().addAll(new KeyFrame(new Duration(0), new KeyValue(l.translateYProperty(),0)),
        new KeyFrame(new Duration(3000), new KeyValue(l.translateYProperty(),300-l.getLayoutY())));            
        tl.getKeyFrames().addAll(new KeyFrame(new Duration(2000), new KeyValue(r.visibleProperty(),true)),
        new KeyFrame(new Duration(3000), new KeyValue(r.visibleProperty(),false)));            
        tl.getKeyFrames().addAll(new KeyFrame(new Duration(2000), new KeyValue(l.visibleProperty(),true)),
        new KeyFrame(new Duration(3000), new KeyValue(l.visibleProperty(),false)));                  
        
        tl.play();
    }

    public void getHojas(){
        getHojas(raiz);
    }
    
    private void getHojas(PaginaG r){
        if(r==null)
            return;
        if(this.esHoja(r)){
            r.getR().setFill(Color.BEIGE);
            r.getR().setStroke(Color.RED);
        } 
        for(int i=0; i<r.getCont()+1;i++){
             getHojas(r.getApuntadores()[i]);
        }  
    }
    
    private boolean esHoja(PaginaG p){
        int j=0;
        while ((p.getApuntadores()[j]==null) && (j < (p.getCont()-1)))
            j++;
        return(p.getApuntadores()[j]==null);
    }

    /**
     *
     * @param tl
     */
    public void preOrden(Timeline tl){
        int durac =0;
        ListaCD<PaginaG> l=new ListaCD<PaginaG>();
         preOrden(this.getRaiz(),l);
        for(int i=0; i<l.getTamanio(); i++){
            PaginaG n = l.get(i);
            tl.getKeyFrames().addAll(new KeyFrame(new Duration(durac), new KeyValue(n.getR().strokeProperty(),Color.BLACK)),
            new KeyFrame(new Duration((durac+1000)), new KeyValue(n.getR().strokeProperty(),Color.RED)));
            tl.getKeyFrames().addAll(new KeyFrame(new Duration(durac), new KeyValue(n.getR().fillProperty(),Color.WHITE)),
            new KeyFrame(new Duration((durac+1000)), new KeyValue(n.getR().fillProperty(),Color.BEIGE)));
            durac+=1000;
        }
        tl.play();
    }

    private void  preOrden(PaginaG r, ListaCD<PaginaG> l){
        if(r==null)
            return;
        l.insertarAlFinal(r);
        for(int i=0; i<r.getCont()+1;i++){
             preOrden(r.getApuntadores()[i],l);
        }  
    }
    
    /**
     *
     * @param tl
     */
    public void inOrden(Timeline tl){
        int durac =0;
        ListaCD<PaginaG> l=new ListaCD<PaginaG>();
         inOrden(this.getRaiz(),l);
        for(int i=0; i<l.getTamanio(); i++){
            PaginaG n = l.get(i);
            tl.getKeyFrames().addAll(new KeyFrame(new Duration(durac), new KeyValue(n.getR().strokeProperty(),Color.BLACK)),
            new KeyFrame(new Duration((durac+1000)), new KeyValue(n.getR().strokeProperty(),Color.RED)));
            tl.getKeyFrames().addAll(new KeyFrame(new Duration(durac), new KeyValue(n.getR().fillProperty(),Color.WHITE)),
            new KeyFrame(new Duration((durac+1000)), new KeyValue(n.getR().fillProperty(),Color.BEIGE)));
            durac+=1000;
        }
        tl.play();
    }

    private void  inOrden(PaginaG r, ListaCD<PaginaG> l){
        if(r==null)
            return;
        inOrden(r.getApuntadores()[0],l);
        l.insertarAlFinal(r);
        for(int i=1; i<r.getCont()+1;i++){
             inOrden(r.getApuntadores()[i],l);
        }   
    }

   
    /**
     *
     * @param tl
     */
    public void postOrden(Timeline tl){
        int durac =0;
        ListaCD<PaginaG> l=new ListaCD<PaginaG>();
         postOrden(this.getRaiz(),l);
        for(int i=0; i<l.getTamanio(); i++){
            PaginaG n = l.get(i);
            tl.getKeyFrames().addAll(new KeyFrame(new Duration(durac), new KeyValue(n.getR().strokeProperty(),Color.BLACK)),
            new KeyFrame(new Duration((durac+1000)), new KeyValue(n.getR().strokeProperty(),Color.RED)));
            tl.getKeyFrames().addAll(new KeyFrame(new Duration(durac), new KeyValue(n.getR().fillProperty(),Color.WHITE)),
            new KeyFrame(new Duration((durac+1000)), new KeyValue(n.getR().fillProperty(),Color.BEIGE)));
            durac+=1000;
        }
        tl.play();
    }
    
    private void postOrden(PaginaG r, ListaCD<PaginaG> l){
        if(r==null)
            return;
        for(int i=0; i<r.getCont()+1;i++){
             postOrden(r.getApuntadores()[i],l);
        }
        l.insertarAlFinal(r);
    }
    
    /**
     *
     * @param tl
     */
    public void impNiveles(Timeline tl){
        int durac =0;
        ListaCD<PaginaG> l=new ListaCD<PaginaG>();
        this.impNiveles(l);
        for(int i=0; i<l.getTamanio(); i++){
            PaginaG n = l.get(i);
            tl.getKeyFrames().addAll(new KeyFrame(new Duration(durac), new KeyValue(n.getR().strokeProperty(),Color.BLACK)),
            new KeyFrame(new Duration((durac+1000)), new KeyValue(n.getR().strokeProperty(),Color.RED)));
            tl.getKeyFrames().addAll(new KeyFrame(new Duration(durac), new KeyValue(n.getR().fillProperty(),Color.WHITE)),
            new KeyFrame(new Duration((durac+1000)), new KeyValue(n.getR().fillProperty(),Color.BEIGE)));
            durac+=1000;
        }
        tl.play();
    }
    
    
    public Iterator impNiveles(ListaCD<PaginaG> l){
        if(!this.esVacio()){
            Cola<PaginaG> c=new Cola<PaginaG>();
            c.enColar(this.getRaiz());
            PaginaG x;
                while(!c.esVacia()){
                    x=c.deColar();
                    if(x!=null){
                        l.insertarAlFinal(x);
                        for(int j=0;j<x.getCont()+1;j++)
                            c.enColar(x.getApuntadores()[j]);  
                    }                 
                }
        }
        return (l.iterator());
    }
    
    /**
     *
     * @return
     */
    public boolean esVacio(){
          return(this.raiz==null);
    }

    

    
}
