/*
 * Decompiled with CFR 0.152.
 */
package Colecciones_SEED;

import Colecciones_SEED.Cola;
import Colecciones_SEED.ListaCD;
import Colecciones_SEED.Nodo123;
import java.util.Iterator;

public class Arbol123<T> {
    private Nodo123<T> raiz = null;

    public Nodo123<T> getRaiz() {
        return this.raiz;
    }

    public T getInfoMenRaiz() {
        return this.raiz.getInfoMen();
    }

    public T getInfoMayRaiz() {
        return this.raiz.getInfoMay();
    }

    private void setRaiz(Nodo123<T> raiz) {
        this.raiz = raiz;
    }

    public boolean insertar(T nuevo) {
        if (this.esta(nuevo)) {
            return false;
        }
        if (this.esVacio()) {
            this.setRaiz(new Nodo123<Object>(nuevo, null));
            return true;
        }
        return this.insertar(this.raiz, nuevo);
    }

    private boolean insertar(Nodo123<T> r, T dato) {
        int comp1 = 0;
        int comp2 = 0;
        boolean hayInfoI = false;
        boolean hayInfoF = false;
        if (r.getInfoMen() != null) {
            hayInfoI = true;
            comp1 = ((Comparable)dato).compareTo(r.getInfoMen());
        }
        if (r.getInfoMay() != null) {
            hayInfoF = true;
            comp2 = ((Comparable)dato).compareTo(r.getInfoMay());
        }
        if (r.getInfoMen() == null && r.getInfoMay() == null) {
            r.setInfoMen(dato);
            return true;
        }
        if (r.getInfoMay() == null) {
            if (hayInfoI && comp1 > 0) {
                r.setInfoMay(dato);
                return true;
            }
            if (hayInfoI && comp1 < 0) {
                if (r.getIzq() == null) {
                    r.setInfoMay(r.getInfoMen());
                    r.setInfoMen(dato);
                    return true;
                }
                return this.insertar(r.getIzq(), dato);
            }
        }
        if (hayInfoI && comp1 < 0) {
            if (r.getIzq() == null) {
                r.setIzq(new Nodo123());
            }
            return this.insertar(r.getIzq(), dato);
        }
        if (hayInfoI && comp1 > 0 && hayInfoF && comp2 < 0) {
            if (r.getMed() == null) {
                r.setMed(new Nodo123());
            }
            return this.insertar(r.getMed(), dato);
        }
        if (hayInfoI && comp1 > 0 && hayInfoF && comp2 > 0) {
            if (r.getDer() == null) {
                r.setDer(new Nodo123());
            }
            return this.insertar(r.getDer(), dato);
        }
        return false;
    }

    public boolean eliminar(T dato) {
        if (this.esVacio() || !this.esta(dato)) {
            return false;
        }
        this.setRaiz(this.eliminar(this.raiz, dato));
        return true;
    }

    private Nodo123<T> eliminar(Nodo123<T> r, T dato) {
        int comp1 = 0;
        int comp2 = 0;
        boolean hayInfoI = false;
        boolean hayInfoF = false;
        if (r.getInfoMen() != null) {
            hayInfoI = true;
            comp1 = ((Comparable)dato).compareTo(r.getInfoMen());
        }
        if (r.getInfoMay() != null) {
            hayInfoF = true;
            comp2 = ((Comparable)dato).compareTo(r.getInfoMay());
        }
        if (hayInfoI && comp1 == 0) {
            if (r.getIzq() != null) {
                r.setInfoMen(this.getMayor(r.getIzq()));
                r.setIzq(this.eliminar(r.getIzq(), r.getInfoMen()));
                return r;
            }
            if (r.getInfoMay() != null) {
                r.setInfoMen(r.getInfoMay());
                r.setInfoMay(r.getDer() != null ? (Object)this.getMayor(r.getDer()) : null);
                if (r.getInfoMay() != null) {
                    r.setDer(this.eliminar(r.getDer(), r.getInfoMay()));
                }
                r.setIzq(r.getMed());
                r.setMed(r.getDer());
                r.setDer(null);
                return r;
            }
            if (r.getMed() != null) {
                return r.getMed();
            }
            return null;
        }
        if (hayInfoF && comp2 == 0 && r.getInfoMay() != null) {
            if (r.getDer() != null) {
                r.setInfoMay(this.getMenor(r.getDer()));
                r.setDer(this.eliminar(r.getDer(), r.getInfoMay()));
                return r;
            }
            if (r.getMed() != null) {
                r.setInfoMay(this.getMayor(r.getMed()));
                r.setMed(this.eliminar(r.getMed(), r.getInfoMay()));
            } else {
                r.setInfoMay(null);
            }
            return r;
        }
        if (hayInfoI && comp1 < 0 && r.getIzq() != null) {
            r.setIzq(this.eliminar(r.getIzq(), dato));
            return r;
        }
        if ((r.getInfoMay() == null || hayInfoF && comp2 < 0) && r.getMed() != null) {
            r.setMed(this.eliminar(r.getMed(), dato));
            return r;
        }
        if (r.getDer() != null) {
            r.setDer(this.eliminar(r.getDer(), dato));
            return r;
        }
        return r;
    }

    private T getMayor(Nodo123<T> r) {
        if (r.getDer() != null) {
            return this.getMayor(r.getDer());
        }
        if (r.getInfoMay() != null) {
            return r.getInfoMay();
        }
        if (r.getMed() != null) {
            return this.getMayor(r.getMed());
        }
        return r.getInfoMen();
    }

    private T getMenor(Nodo123<T> r) {
        Nodo123<T> aux = r;
        while (aux.getIzq() != null) {
            aux = aux.getIzq();
        }
        return aux.getInfoMen();
    }

    public boolean esta(T dato) {
        if (this.esVacio()) {
            return false;
        }
        return this.esta(this.raiz, dato);
    }

    private boolean esta(Nodo123<T> r, T dato) {
        int comp1 = 0;
        int comp2 = 0;
        boolean hayInfoI = false;
        boolean hayInfoF = false;
        if (r.getInfoMen() != null) {
            hayInfoI = true;
            comp1 = ((Comparable)dato).compareTo(r.getInfoMen());
        }
        if (r.getInfoMay() != null) {
            hayInfoF = true;
            comp2 = ((Comparable)dato).compareTo(r.getInfoMay());
        }
        if (hayInfoI && comp1 == 0 || hayInfoF && comp2 == 0) {
            return true;
        }
        if (hayInfoI && comp1 < 0) {
            if (r.getIzq() == null) {
                return false;
            }
            return this.esta(r.getIzq(), dato);
        }
        if (hayInfoF && comp2 < 0) {
            if (r.getMed() == null) {
                return false;
            }
            return this.esta(r.getMed(), dato);
        }
        if (r.getDer() != null) {
            return this.esta(r.getDer(), dato);
        }
        return false;
    }

    public Nodo123<T> buscar(T dato) {
        if (this.esVacio()) {
            return null;
        }
        return this.buscar(this.raiz, dato);
    }

    private Nodo123<T> buscar(Nodo123<T> r, T dato) {
        int comp1 = 0;
        int comp2 = 0;
        boolean hayInfoI = false;
        boolean hayInfoF = false;
        if (r.getInfoMen() != null) {
            hayInfoI = true;
            comp1 = ((Comparable)dato).compareTo(r.getInfoMen());
        }
        if (r.getInfoMay() != null) {
            hayInfoF = true;
            comp2 = ((Comparable)dato).compareTo(r.getInfoMay());
        }
        if (hayInfoI && comp1 == 0 || hayInfoF && comp2 == 0) {
            return r;
        }
        if (hayInfoI && comp1 < 0) {
            if (r.getIzq() == null) {
                return null;
            }
            return this.buscar(r.getIzq(), dato);
        }
        if (hayInfoF && comp2 < 0) {
            if (r.getMed() == null) {
                return null;
            }
            return this.buscar(r.getMed(), dato);
        }
        if (r.getDer() != null) {
            return this.buscar(r.getDer(), dato);
        }
        return null;
    }

    public Iterator<T> getHojas() {
        ListaCD l = new ListaCD();
        this.getHojas(this.raiz, l);
        return l.iterator();
    }

    private void getHojas(Nodo123<T> r, ListaCD<T> l) {
        if (r != null) {
            if (this.esHoja(r)) {
                if (r.getInfoMen() != null) {
                    l.insertarAlFinal(r.getInfoMen());
                }
                if (r.getInfoMay() != null) {
                    l.insertarAlFinal(r.getInfoMay());
                }
            }
            this.getHojas(r.getIzq(), l);
            this.getHojas(r.getMed(), l);
            this.getHojas(r.getDer(), l);
        }
    }

    private boolean esHoja(Nodo123<T> r) {
        return r != null && r.getIzq() == null && r.getMed() == null && r.getDer() == null;
    }

    public int contarHojas() {
        return this.contarHojas(this.raiz);
    }

    private int contarHojas(Nodo123<T> r) {
        if (r == null) {
            return 0;
        }
        if (this.esHoja(r)) {
            return 1;
        }
        int chi = this.contarHojas(r.getIzq());
        int chm = this.contarHojas(r.getMed());
        int chd = this.contarHojas(r.getDer());
        return chi + chm + chd;
    }

    public Iterator<T> preOrden() {
        ListaCD l = new ListaCD();
        this.preOrden(this.getRaiz(), l);
        return l.iterator();
    }

    private void preOrden(Nodo123<T> r, ListaCD<T> l) {
        if (r != null) {
            if (r.getInfoMen() != null) {
                l.insertarAlFinal(r.getInfoMen());
            }
            if (r.getInfoMay() != null) {
                l.insertarAlFinal(r.getInfoMay());
            }
            this.preOrden(r.getIzq(), l);
            this.preOrden(r.getMed(), l);
            this.preOrden(r.getDer(), l);
        }
    }

    public Iterator<T> inOrden() {
        ListaCD l = new ListaCD();
        this.inOrden(this.getRaiz(), l);
        return l.iterator();
    }

    private void inOrden(Nodo123<T> r, ListaCD<T> l) {
        if (r != null) {
            this.inOrden(r.getIzq(), l);
            if (r.getInfoMen() != null) {
                l.insertarAlFinal(r.getInfoMen());
            }
            if (r.getInfoMay() != null) {
                l.insertarAlFinal(r.getInfoMay());
            }
            this.inOrden(r.getMed(), l);
            this.inOrden(r.getDer(), l);
        }
    }

    public Iterator<T> postOrden() {
        ListaCD l = new ListaCD();
        this.postOrden(this.getRaiz(), l);
        return l.iterator();
    }

    private void postOrden(Nodo123<T> r, ListaCD<T> l) {
        if (r != null) {
            this.postOrden(r.getIzq(), l);
            this.postOrden(r.getMed(), l);
            this.postOrden(r.getDer(), l);
            if (r.getInfoMen() != null) {
                l.insertarAlFinal(r.getInfoMen());
            }
            if (r.getInfoMay() != null) {
                l.insertarAlFinal(r.getInfoMay());
            }
        }
    }

    public Iterator<T> impNiveles() {
        ListaCD l = new ListaCD();
        if (!this.esVacio()) {
            Cola c = new Cola();
            c.enColar(this.getRaiz());
            while (!c.esVacia()) {
                Nodo123 x = (Nodo123)c.deColar();
                l.insertarAlFinal(x.getInfoMen());
                l.insertarAlFinal(x.getInfoMay());
                if (x.getIzq() != null) {
                    c.enColar(x.getIzq());
                }
                if (x.getMed() != null) {
                    c.enColar(x.getMed());
                }
                if (x.getDer() == null) continue;
                c.enColar(x.getDer());
            }
        }
        return l.iterator();
    }

    public int getPeso() {
        return this.getPeso(this.getRaiz());
    }

    private int getPeso(Nodo123<T> r) {
        if (r == null) {
            return 0;
        }
        int n = 1;
        if (r.getInfoMay() != null) {
            n = 2;
        }
        return this.getPeso(r.getIzq()) + n + this.getPeso(r.getMed()) + this.getPeso(r.getDer());
    }

    public boolean esVacio() {
        return this.raiz == null;
    }

    public int getAltura() {
        if (this.raiz == null) {
            return 0;
        }
        return this.getAltura(this.getRaiz());
    }

    public int getAltura(Nodo123<T> r) {
        int ai = 0;
        int am = 0;
        int ad = 0;
        if (r.getIzq() != null) {
            ai = this.getAltura(r.getIzq());
        }
        if (r.getMed() != null) {
            am = this.getAltura(r.getMed());
        }
        if (r.getDer() != null) {
            ad = this.getAltura(r.getDer());
        }
        int alt = ai;
        if (am >= ai) {
            alt = am;
        }
        if (ad >= alt) {
            alt = ad;
        }
        return alt + 1;
    }

    public void podar() {
        if (this.esHoja(this.raiz)) {
            this.setRaiz(null);
        }
        this.podar(this.raiz);
    }

    private void podar(Nodo123<T> r) {
        if (r == null) {
            return;
        }
        if (this.esHoja(r.getIzq())) {
            r.setIzq(null);
        }
        if (this.esHoja(r.getMed())) {
            r.setMed(null);
        }
        if (this.esHoja(r.getDer())) {
            r.setDer(null);
        }
        this.podar(r.getIzq());
        this.podar(r.getMed());
        this.podar(r.getDer());
    }

    public void imprime() {
        this.imprime(this.raiz);
    }

    public void imprime(Nodo123<T> r) {
        if (this.esVacio()) {
            return;
        }
        String cad = "";
        cad = cad + "Info:" + r.getInfoMen() + "." + r.getInfoMay() + "";
        if (r.getIzq() != null) {
            cad = cad + "\t Izq" + r.getIzq().getInfoMen() + "." + r.getIzq().getInfoMay() + "";
        }
        if (r.getMed() != null) {
            cad = cad + "\t Med" + r.getMed().getInfoMen() + "." + r.getMed().getInfoMay() + "";
        }
        if (r.getDer() != null) {
            cad = cad + "\t Der" + r.getDer().getInfoMen() + "." + r.getDer().getInfoMay() + "";
        }
        System.out.println(cad);
        if (r.getIzq() != null) {
            this.imprime(r.getIzq());
        }
        if (r.getMed() != null) {
            this.imprime(r.getMed());
        }
        if (r.getDer() != null) {
            this.imprime(r.getDer());
        }
    }
}

