/*
 * Decompiled with CFR 0.152.
 */
package Colecciones_SEED;

import Colecciones_SEED.ArbolBinarioBusqueda;
import Colecciones_SEED.Cola;
import Colecciones_SEED.ListaCD;
import Colecciones_SEED.NodoBin;
import Colecciones_SEED.Pila;
import java.util.Iterator;

public class ArbolBinario<T> {
    private NodoBin<T> raiz;

    public ArbolBinario() {
        this.raiz = null;
    }

    public ArbolBinario(T raiz) {
        this.raiz = new NodoBin<T>(raiz);
    }

    public T getObjRaiz() {
        return this.raiz.getInfo();
    }

    public NodoBin<T> getRaiz() {
        return this.raiz;
    }

    public void setRaiz(NodoBin<T> raiz) {
        this.raiz = raiz;
    }

    public boolean insertarHijoIzq(T padre, T hijo) {
        if (this.esVacio()) {
            this.setRaiz(new NodoBin<T>(hijo));
            return true;
        }
        NodoBin<T> p = this.buscar(padre);
        if (p != null) {
            if (p.getIzq() == null) {
                p.setIzq(new NodoBin<T>(hijo));
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean insertarHijoDer(T padre, T hijo) {
        if (this.esVacio()) {
            this.setRaiz(new NodoBin<T>(hijo));
            return true;
        }
        NodoBin<T> p = this.buscar(padre);
        if (p != null) {
            if (p.getDer() == null) {
                p.setDer(new NodoBin<T>(hijo));
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean eliminar(T info) {
        boolean tni;
        NodoBin<T> r = this.buscar(info);
        if (r == null) {
            return false;
        }
        boolean tnd = r.getDer() != null;
        boolean bl = tni = r.getIzq() != null;
        if (!tnd && !tni) {
            return this.eliminarC1(r);
        }
        if (tnd && !tni) {
            return this.eliminarC2(r);
        }
        if (!tnd && tni) {
            return this.eliminarC2(r);
        }
        if (tnd && tni) {
            return this.eliminarC3(r);
        }
        return false;
    }

    private boolean eliminarC1(NodoBin<T> r) {
        NodoBin<T> p = this.getPadre(r);
        if (p == null) {
            if (this.getRaiz() != r) {
                return false;
            }
            this.setRaiz(null);
            return true;
        }
        NodoBin<T> hi = p.getIzq();
        NodoBin<T> hd = p.getDer();
        if (hi == r) {
            this.getPadre(r).setIzq(null);
            return true;
        }
        if (hd == r) {
            this.getPadre(r).setDer(null);
            return true;
        }
        return false;
    }

    private boolean eliminarC2(NodoBin<T> r) {
        NodoBin<T> ha;
        NodoBin<T> p = this.getPadre(r);
        NodoBin<T> nodoBin = ha = r.getIzq() != null ? r.getIzq() : r.getDer();
        if (p == null) {
            this.setRaiz(ha);
            return true;
        }
        NodoBin<T> hi = p.getIzq();
        NodoBin<T> hd = p.getDer();
        if (hi == r) {
            this.getPadre(r).setIzq(ha);
            r.setDer(null);
            r.setIzq(null);
            return true;
        }
        if (hd == r) {
            this.getPadre(r).setDer(ha);
            r.setDer(null);
            r.setIzq(null);
            return true;
        }
        return false;
    }

    private boolean eliminarC3(NodoBin<T> r) {
        NodoBin<T> masIzq = this.masIzquierda(r.getDer());
        if (masIzq != null) {
            this.eliminar(masIzq.getInfo());
            r.setInfo(masIzq.getInfo());
            return true;
        }
        return false;
    }

    private NodoBin<T> masIzquierda(NodoBin<T> r) {
        if (r.getIzq() != null) {
            return this.masIzquierda(r.getIzq());
        }
        return r;
    }

    public boolean esta(T info) {
        return this.esta(this.raiz, info);
    }

    private boolean esta(NodoBin<T> r, T info) {
        if (r == null) {
            return false;
        }
        if (r.getInfo().equals(info)) {
            return true;
        }
        return this.esta(r.getIzq(), info) || this.esta(r.getDer(), info);
    }

    private NodoBin<T> buscar(T info) {
        return this.buscar(this.raiz, info);
    }

    private NodoBin<T> buscar(NodoBin<T> r, T info) {
        NodoBin<T> aux;
        if (r == null) {
            return null;
        }
        if (r.getInfo().equals(info)) {
            return r;
        }
        NodoBin<T> nodoBin = aux = r.getIzq() == null ? null : this.buscar(r.getIzq(), info);
        if (aux != null) {
            return aux;
        }
        return r.getDer() == null ? null : this.buscar(r.getDer(), info);
    }

    public boolean setDato(T info1, T info2) {
        if (!this.esta(info1) || this.esta(info2)) {
            return false;
        }
        return this.setDato(this.raiz, info1, info2);
    }

    private boolean setDato(NodoBin<T> r, T info1, T info2) {
        if (r == null) {
            return false;
        }
        if (r.getInfo().equals(info1)) {
            r.setInfo(info2);
            return true;
        }
        return this.setDato(r.getIzq(), info1, info2) || this.setDato(r.getDer(), info1, info2);
    }

    protected NodoBin<T> getPadre(NodoBin<T> r) {
        if (r == null || this.raiz == null) {
            return null;
        }
        NodoBin<T> x = this.getPadre(this.raiz, r.getInfo());
        if (x == null) {
            return null;
        }
        return x;
    }

    private NodoBin<T> getPadre(NodoBin<T> x, T info) {
        if (x == null) {
            return null;
        }
        if (x.getIzq() != null && x.getIzq().getInfo().equals(info) || x.getDer() != null && x.getDer().getInfo().equals(info)) {
            return x;
        }
        NodoBin<T> y = this.getPadre(x.getIzq(), info);
        if (y == null) {
            return this.getPadre(x.getDer(), info);
        }
        return y;
    }

    public Iterator<T> getHojas() {
        ListaCD l = new ListaCD();
        this.getHojas(this.raiz, l);
        return l.iterator();
    }

    private void getHojas(NodoBin<T> r, ListaCD<T> l) {
        if (r != null) {
            if (this.esHoja(r)) {
                l.insertarAlFinal(r.getInfo());
            }
            this.getHojas(r.getIzq(), l);
            this.getHojas(r.getDer(), l);
        }
    }

    private boolean esHoja(NodoBin<T> x) {
        return x != null && x.getIzq() == null && x.getDer() == null;
    }

    public int contarHojas() {
        return this.contarHojas(this.raiz);
    }

    private int contarHojas(NodoBin<T> r) {
        if (r == null) {
            return 0;
        }
        if (this.esHoja(r)) {
            return 1;
        }
        int chi = this.contarHojas(r.getIzq());
        int chd = this.contarHojas(r.getDer());
        return chi + chd;
    }

    public Iterator<T> preOrden() {
        ListaCD l = new ListaCD();
        this.preOrden(this.getRaiz(), l);
        return l.iterator();
    }

    private void preOrden(NodoBin<T> r, ListaCD<T> l) {
        if (r != null) {
            l.insertarAlFinal(r.getInfo());
            this.preOrden(r.getIzq(), l);
            this.preOrden(r.getDer(), l);
        }
    }

    public Iterator<T> inOrden() {
        ListaCD l = new ListaCD();
        this.inOrden(this.getRaiz(), l);
        return l.iterator();
    }

    private void inOrden(NodoBin<T> r, ListaCD<T> l) {
        if (r != null) {
            this.inOrden(r.getIzq(), l);
            l.insertarAlFinal(r.getInfo());
            this.inOrden(r.getDer(), l);
        }
    }

    public Iterator<T> postOrden() {
        ListaCD l = new ListaCD();
        this.postOrden(this.getRaiz(), l);
        return l.iterator();
    }

    private void postOrden(NodoBin<T> r, ListaCD<T> l) {
        if (r != null) {
            this.postOrden(r.getIzq(), l);
            this.postOrden(r.getDer(), l);
            l.insertarAlFinal(r.getInfo());
        }
    }

    public String preOrden_Iterativo() {
        return this.preOrden_Iterativo(this.raiz);
    }

    private String preOrden_Iterativo(NodoBin<T> r) {
        Pila p = new Pila();
        String rr = "";
        while (r != null) {
            p.apilar(r);
            rr = rr + r.getInfo().toString() + "-";
            r = r.getIzq();
        }
        while (!p.esVacia()) {
            r = (NodoBin)p.desapilar();
            for (r = r.getDer(); r != null; r = r.getIzq()) {
                rr = rr + r.getInfo().toString() + "-";
                p.apilar(r);
            }
        }
        return rr;
    }

    public String inOrden_Iterativo() {
        return this.inOrden_Iterativo(this.raiz);
    }

    private String inOrden_Iterativo(NodoBin<T> r) {
        Pila p = new Pila();
        String rr = "";
        while (r != null) {
            p.apilar(r);
            r = r.getIzq();
        }
        while (!p.esVacia()) {
            r = (NodoBin)p.desapilar();
            rr = rr + r.getInfo().toString() + "-";
            for (r = r.getDer(); r != null; r = r.getIzq()) {
                p.apilar(r);
            }
        }
        return rr;
    }

    public String postOrden_Iterativo() {
        return this.postOrden_Iterativo(this.raiz);
    }

    private String postOrden_Iterativo(NodoBin<T> r) {
        Pila<NodoBin> pila = new Pila<NodoBin>();
        NodoBin tope = null;
        String rr = "";
        while (r != null) {
            if (r.getIzq() != null && r.getIzq() != tope && r.getDer() != tope) {
                pila.apilar(r);
                r = r.getIzq();
                continue;
            }
            if (r.getIzq() == null && r.getDer() == null && r != tope) {
                rr = rr + r.getInfo().toString() + "-";
                tope = r;
                if (!pila.esVacia()) {
                    r = (NodoBin)pila.desapilar();
                    continue;
                }
                r = null;
                continue;
            }
            if (r.getDer() != null && tope != r.getDer()) {
                pila.apilar(r);
                r = r.getDer();
                continue;
            }
            if (r.getDer() == null || tope != r.getDer()) continue;
            rr = rr + r.getInfo().toString() + "-";
            tope = r;
            if (!pila.esVacia()) {
                r = (NodoBin)pila.desapilar();
                continue;
            }
            r = null;
        }
        return rr;
    }

    public Iterator<T> impNiveles() {
        ListaCD l = new ListaCD();
        if (!this.esVacio()) {
            Cola c = new Cola();
            c.enColar(this.getRaiz());
            while (!c.esVacia()) {
                NodoBin x = (NodoBin)c.deColar();
                l.insertarAlFinal(x.getInfo());
                if (x.getIzq() != null) {
                    c.enColar(x.getIzq());
                }
                if (x.getDer() == null) continue;
                c.enColar(x.getDer());
            }
        }
        return l.iterator();
    }

    public int getPeso() {
        return this.getPeso(this.getRaiz());
    }

    private int getPeso(NodoBin<T> r) {
        if (r == null) {
            return 0;
        }
        return this.getPeso(r.getIzq()) + 1 + this.getPeso(r.getDer());
    }

    public boolean esVacio() {
        return this.raiz == null;
    }

    public int getAltura() {
        if (this.raiz == null) {
            return 0;
        }
        return this.getAltura(this.getRaiz());
    }

    private int getAltura(NodoBin<T> r) {
        int ai = 0;
        int ad = 0;
        if (r.getIzq() != null) {
            ai = this.getAltura(r.getIzq());
        }
        if (r.getDer() != null) {
            ad = this.getAltura(r.getDer());
        }
        if (ai >= ad) {
            return ai + 1;
        }
        return ad + 1;
    }

    public int getGrado(T info) {
        NodoBin<T> nodo = this.buscar(info);
        if (nodo == null) {
            return -1;
        }
        if (this.esHoja(nodo)) {
            return 0;
        }
        int rta = 0;
        if (nodo.getIzq() != null) {
            ++rta;
        }
        if (nodo.getDer() != null) {
            ++rta;
        }
        return rta;
    }

    public boolean esCompleto() {
        return this.esCompleto(this.raiz);
    }

    private boolean esCompleto(NodoBin<T> r) {
        if (this.esHoja(r)) {
            return true;
        }
        if (r.getIzq() != null && r.getDer() != null) {
            return this.esCompleto(r.getIzq()) && this.esCompleto(r.getDer());
        }
        return false;
    }

    public boolean estaLleno() {
        return this.estaLleno(this.raiz, this.getAltura());
    }

    private boolean estaLleno(NodoBin<T> r, int alt) {
        if (this.esHoja(r)) {
            return alt == 1;
        }
        if (r.getIzq() == null || r.getDer() == null) {
            return false;
        }
        return this.estaLleno(r.getIzq(), alt - 1) && this.estaLleno(r.getDer(), alt - 1);
    }

    public void podar() {
        if (this.esHoja(this.raiz)) {
            this.setRaiz(null);
        }
        this.podar(this.raiz);
    }

    private void podar(NodoBin<T> x) {
        if (x == null) {
            return;
        }
        if (this.esHoja(x.getIzq())) {
            x.setIzq(null);
        }
        if (this.esHoja(x.getDer())) {
            x.setDer(null);
        }
        this.podar(x.getIzq());
        this.podar(x.getDer());
    }

    public String Luca() {
        return this.Luca(this.raiz);
    }

    private String Luca(NodoBin<T> r) {
        if (r == null) {
            return "b";
        }
        return "a" + this.Luca(r.getIzq()) + this.Luca(r.getDer());
    }

    public boolean esIgual(ArbolBinario<T> a2) {
        return this.esIgual(this.raiz, a2.getRaiz());
    }

    private boolean esIgual(NodoBin<T> r1, NodoBin<T> r2) {
        if (r1 == null && r2 == null) {
            return true;
        }
        if (r1 == null || r2 == null) {
            return false;
        }
        if (r1.getInfo() == r2.getInfo()) {
            return this.esIgual(r1.getIzq(), r2.getIzq()) && this.esIgual(r1.getDer(), r2.getDer());
        }
        return false;
    }

    public boolean esIsomorfo(ArbolBinario<T> a2) {
        return this.esIsomorfo(this.raiz, a2.getRaiz());
    }

    private boolean esIsomorfo(NodoBin<T> r1, NodoBin<T> r2) {
        if (r1 == null && r2 == null) {
            return true;
        }
        if (r1 == null || r2 == null) {
            return false;
        }
        return this.esIsomorfo(r1.getIzq(), r2.getIzq()) && this.esIsomorfo(r1.getDer(), r2.getDer());
    }

    public boolean esSemejante(ArbolBinario<T> a2) {
        if (this.getPeso() != a2.getPeso()) {
            return false;
        }
        return this.esSemejante(a2.getRaiz());
    }

    private boolean esSemejante(NodoBin<T> r) {
        if (r == null) {
            return true;
        }
        if (!this.esta(r.getInfo())) {
            return false;
        }
        return this.esSemejante(r.getIzq()) && this.esSemejante(r.getDer());
    }

    public void imprime() {
        System.out.println(" ----- Arbol Binario ----- ");
        this.imprime(this.raiz);
    }

    public void imprime(NodoBin<T> n) {
        Object l = null;
        Object r = null;
        if (n == null) {
            return;
        }
        if (n.getIzq() != null) {
            l = n.getIzq().getInfo();
        }
        if (n.getDer() != null) {
            r = n.getDer().getInfo();
        }
        System.out.println("NodoIzq: " + l + "\t Info: " + n.getInfo() + "\t NodoDer: " + r);
        if (n.getIzq() != null) {
            this.imprime(n.getIzq());
        }
        if (n.getDer() != null) {
            this.imprime(n.getDer());
        }
    }

    public ArbolBinarioBusqueda<T> clonar() {
        ArbolBinarioBusqueda<T> t = new ArbolBinarioBusqueda<T>();
        t.setRaiz(this.clonarAB(this.getRaiz()));
        return t;
    }

    private NodoBin<T> clonarAB(NodoBin<T> r) {
        if (r == null) {
            return r;
        }
        NodoBin<T> aux = new NodoBin<T>(r.getInfo(), this.clonarAB(r.getIzq()), this.clonarAB(r.getDer()));
        return aux;
    }
}

