/*
 * Decompiled with CFR 0.152.
 */
package Colecciones_SEED;

import Colecciones_SEED.ArbolBinario;
import Colecciones_SEED.NodoBin;
import java.util.Iterator;

public class ArbolBinarioBusqueda<T>
extends ArbolBinario<T> {
    public ArbolBinarioBusqueda() {
    }

    public ArbolBinarioBusqueda(T raiz) {
        super(raiz);
    }

    @Override
    public NodoBin<T> getRaiz() {
        return super.getRaiz();
    }

    @Override
    public T getObjRaiz() {
        return super.getObjRaiz();
    }

    public boolean insertar(T dato) {
        NodoBin<T> rr;
        NodoBin<T> nodoBin = rr = this.esta(dato) ? null : this.insertar(this.getRaiz(), dato);
        if (rr != null) {
            this.setRaiz(rr);
        }
        return rr != null;
    }

    private NodoBin<T> insertar(NodoBin<T> r, T dato) {
        if (r == null) {
            return new NodoBin<T>(dato, null, null);
        }
        int compara = ((Comparable)r.getInfo()).compareTo(dato);
        if (compara > 0) {
            r.setIzq(this.insertar(r.getIzq(), dato));
        } else if (compara < 0) {
            r.setDer(this.insertar(r.getDer(), dato));
        } else {
            System.err.println("Error dato duplicado:" + dato.toString());
        }
        return r;
    }

    @Override
    public boolean eliminar(T x) {
        if (!this.esta(x)) {
            return false;
        }
        NodoBin<T> z = this.eliminarABB(this.getRaiz(), x);
        this.setRaiz(z);
        return true;
    }

    private NodoBin<T> eliminarABB(NodoBin<T> r, T x) {
        if (r == null) {
            return null;
        }
        int compara = ((Comparable)r.getInfo()).compareTo(x);
        if (compara > 0) {
            r.setIzq(this.eliminarABB(r.getIzq(), x));
        } else if (compara < 0) {
            r.setDer(this.eliminarABB(r.getDer(), x));
        } else if (r.getIzq() != null && r.getDer() != null) {
            NodoBin<T> cambiar = this.masIzquierda(r.getDer());
            T aux = cambiar.getInfo();
            cambiar.setInfo(r.getInfo());
            r.setInfo(aux);
            r.setDer(this.eliminarABB(r.getDer(), x));
        } else {
            r = r.getIzq() != null ? r.getIzq() : r.getDer();
        }
        return r;
    }

    protected NodoBin<T> masIzquierda(NodoBin<T> r) {
        while (r.getIzq() != null) {
            r = r.getIzq();
        }
        return r;
    }

    public boolean estaABB(T x) {
        return this.esta(this.getRaiz(), x);
    }

    private boolean esta(NodoBin<T> r, T x) {
        if (r == null) {
            return false;
        }
        int compara = ((Comparable)r.getInfo()).compareTo(x);
        if (compara > 0) {
            return this.esta(r.getIzq(), x);
        }
        if (compara < 0) {
            return this.esta(r.getDer(), x);
        }
        return true;
    }

    protected NodoBin<T> buscar(T info) {
        return this.buscar(this.getRaiz(), info);
    }

    protected NodoBin<T> buscar(NodoBin<T> r, T info) {
        NodoBin<T> aux;
        if (r == null) {
            return null;
        }
        if (r.getInfo().equals(info)) {
            return r;
        }
        NodoBin<T> nodoBin = aux = r.getIzq() == null ? null : this.buscar(r.getIzq(), info);
        if (aux != null) {
            return aux;
        }
        return r.getDer() == null ? null : this.buscar(r.getDer(), info);
    }

    @Override
    public Iterator<T> getHojas() {
        return super.getHojas();
    }

    @Override
    public int contarHojas() {
        return super.contarHojas();
    }

    @Override
    public Iterator<T> preOrden() {
        return super.preOrden();
    }

    @Override
    public Iterator<T> inOrden() {
        return super.inOrden();
    }

    @Override
    public Iterator<T> postOrden() {
        return super.postOrden();
    }

    @Override
    public Iterator<T> impNiveles() {
        return super.impNiveles();
    }

    @Override
    public int getPeso() {
        return super.getPeso();
    }

    @Override
    public boolean esVacio() {
        return super.esVacio();
    }

    @Override
    public int getAltura() {
        return super.getAltura();
    }

    @Override
    public ArbolBinarioBusqueda<T> clonar() {
        ArbolBinarioBusqueda<T> t = new ArbolBinarioBusqueda<T>();
        t.setRaiz(this.clonarABB(this.getRaiz()));
        return t;
    }

    private NodoBin<T> clonarABB(NodoBin<T> r) {
        if (r == null) {
            return r;
        }
        NodoBin<T> aux = new NodoBin<T>(r.getInfo(), this.clonarABB(r.getIzq()), this.clonarABB(r.getDer()));
        return aux;
    }

    @Override
    public void imprime() {
        System.out.println(" ----- Arbol Binario de Busqueda ----- ");
        this.imprimeABB(super.getRaiz());
    }

    public void imprimeABB(NodoBin<T> n) {
        Object l = null;
        Object r = null;
        if (n == null) {
            return;
        }
        if (n.getIzq() != null) {
            l = n.getIzq().getInfo();
        }
        if (n.getDer() != null) {
            r = n.getDer().getInfo();
        }
        System.out.println("NodoIzq: " + l + "\t Info: " + n.getInfo() + "\t NodoDer: " + r);
        if (n.getIzq() != null) {
            this.imprimeABB(n.getIzq());
        }
        if (n.getDer() != null) {
            this.imprimeABB(n.getDer());
        }
    }
}

