/*
 * Decompiled with CFR 0.152.
 */
package Colecciones_SEED;

import Colecciones_SEED.ArbolBinarioBusqueda;
import Colecciones_SEED.Cola;
import Colecciones_SEED.ListaCD;
import Colecciones_SEED.NodoBin;
import Colecciones_SEED.NodoRN;
import java.util.Iterator;

public class ArbolRojiNegro<T>
extends ArbolBinarioBusqueda<T> {
    private NodoRN<T> nulo;

    public ArbolRojiNegro() {
        this.nulo = new NodoRN();
        this.nulo.setInfo(null);
        this.nulo.setPadre(this.nulo);
        this.nulo.setIzq(this.nulo);
        this.nulo.setDer(this.nulo);
        this.nulo.setColor(1);
    }

    public ArbolRojiNegro(T r) {
        super.setRaiz(new NodoRN<T>(r));
    }

    @Override
    public T getObjRaiz() {
        return super.getObjRaiz();
    }

    @Override
    public boolean insertar(T dato) {
        int compara;
        NodoRN<T> z = new NodoRN<T>(dato, this.nulo, this.nulo, this.nulo);
        NodoRN y = this.nulo;
        NodoBin x = (NodoRN)super.getRaiz();
        while (x != null && x.getInfo() != null) {
            y = x;
            compara = ((Comparable)z.getInfo()).compareTo(x.getInfo());
            if (compara < 0) {
                x = x.getIzq();
                continue;
            }
            x = x.getDer();
        }
        z.setPadre(y);
        if (y.getInfo() == null) {
            super.setRaiz(z);
        } else {
            compara = ((Comparable)z.getInfo()).compareTo(y.getInfo());
            if (compara < 0) {
                y.setIzq(z);
            } else {
                y.setDer(z);
            }
        }
        z.setIzq(this.nulo);
        z.setDer(this.nulo);
        z.setColor(0);
        this.corregirInsercion(z);
        return true;
    }

    private void corregirInsercion(NodoRN<T> z) {
        while (z.getPadre().getColor() == 0) {
            NodoBin y;
            if (z.getPadre() == z.getPadre().getPadre().getIzq()) {
                y = z.getPadre().getPadre().getDer();
                if (((NodoRN)y).getColor() == 0) {
                    z.getPadre().setColor(1);
                    ((NodoRN)y).setColor(1);
                    z.getPadre().getPadre().setColor(0);
                    z = z.getPadre().getPadre();
                    continue;
                }
                if (z == z.getPadre().getDer()) {
                    z = z.getPadre();
                    this.rotarIzq(z);
                }
                z.getPadre().setColor(1);
                z.getPadre().getPadre().setColor(0);
                this.rotarDer(z.getPadre().getPadre());
                continue;
            }
            y = z.getPadre().getPadre().getIzq();
            if (((NodoRN)y).getColor() == 0) {
                z.getPadre().setColor(1);
                ((NodoRN)y).setColor(1);
                z.getPadre().getPadre().setColor(0);
                z = z.getPadre().getPadre();
                continue;
            }
            if (z == z.getPadre().getIzq()) {
                z = z.getPadre();
                this.rotarDer(z);
            }
            z.getPadre().setColor(1);
            z.getPadre().getPadre().setColor(0);
            this.rotarIzq(z.getPadre().getPadre());
        }
        ((NodoRN)super.getRaiz()).setColor(1);
    }

    private NodoRN<T> buscarRN(NodoRN<T> r, T info) {
        NodoRN<T> aux;
        if (r == null || r.getInfo() == null) {
            return this.nulo;
        }
        if (r.getInfo().equals(info)) {
            return r;
        }
        NodoRN<T> nodoRN = aux = ((NodoRN)r.getIzq()).getInfo() == null ? this.nulo : this.buscarRN((NodoRN<T>)r.getIzq(), info);
        if (aux != this.nulo && aux.getInfo() != null) {
            return aux;
        }
        return ((NodoRN)r.getDer()).getInfo() == null ? this.nulo : this.buscarRN((NodoRN<T>)r.getDer(), info);
    }

    @Override
    public boolean eliminar(T x) {
        NodoRN<T> n = this.buscarRN((NodoRN)super.getRaiz(), x);
        if (n == this.nulo || n.getInfo() == null) {
            return false;
        }
        this.eliminarRN(n);
        return true;
    }

    public NodoRN<T> eliminarRN(NodoRN<T> z) {
        NodoRN<T> y = ((NodoRN)z.getIzq()).getInfo() != null && ((NodoRN)z.getDer()).getInfo() != null ? this.getMayor((NodoRN<T>)z.getIzq()) : z;
        NodoBin x = ((NodoRN)y.getIzq()).getInfo() != null ? y.getIzq() : y.getDer();
        ((NodoRN)x).setPadre(y.getPadre());
        if (y.getPadre().getInfo() == null) {
            super.setRaiz(x);
        } else if (y == y.getPadre().getIzq()) {
            y.getPadre().setIzq((NodoRN<T>)x);
        } else {
            y.getPadre().setDer((NodoRN<T>)x);
        }
        if (y.getInfo() != z.getInfo()) {
            z.setInfo(y.getInfo());
        }
        if (y.getColor() == 1) {
            this.corregirBorrado((NodoRN<T>)x);
        }
        return y;
    }

    private void corregirBorrado(NodoRN<T> x) {
        while (x != (NodoRN)super.getRaiz() && x.getColor() == 1) {
            NodoRN<T> padre;
            NodoBin w;
            if (x == x.getPadre().getIzq()) {
                w = x.getPadre().getDer();
                if (((NodoRN)w).getColor() == 0) {
                    ((NodoRN)w).setColor(1);
                    x.getPadre().setColor(0);
                    this.rotarIzq(x.getPadre());
                    w = x.getPadre().getDer();
                }
                if (((NodoRN)((NodoRN)w).getIzq()).getColor() == 1 && ((NodoRN)((NodoRN)w).getDer()).getColor() == 1) {
                    ((NodoRN)w).setColor(0);
                    x = x.getPadre();
                    continue;
                }
                padre = x.getPadre();
                if (((NodoRN)((NodoRN)w).getDer()).getColor() == 1) {
                    ((NodoRN)((NodoRN)w).getIzq()).setColor(1);
                    ((NodoRN)w).setColor(0);
                    this.rotarDer((NodoRN<T>)w);
                    w = padre.getDer();
                }
                ((NodoRN)w).setColor(padre.getColor());
                padre.setColor(1);
                ((NodoRN)((NodoRN)w).getDer()).setColor(1);
                this.rotarIzq(padre);
                x = (NodoRN)super.getRaiz();
                continue;
            }
            w = x.getPadre().getIzq();
            if (((NodoRN)w).getColor() == 0) {
                ((NodoRN)w).setColor(1);
                x.getPadre().setColor(0);
                this.rotarDer(x.getPadre());
                w = x.getPadre().getIzq();
            }
            if (((NodoRN)((NodoRN)w).getDer()).getColor() == 1 && ((NodoRN)((NodoRN)w).getIzq()).getColor() == 1) {
                ((NodoRN)w).setColor(0);
                x = x.getPadre();
                continue;
            }
            padre = x.getPadre();
            if (((NodoRN)((NodoRN)w).getIzq()).getColor() == 1) {
                ((NodoRN)((NodoRN)w).getDer()).setColor(1);
                ((NodoRN)w).setColor(0);
                this.rotarIzq((NodoRN<T>)w);
                w = padre.getIzq();
            }
            ((NodoRN)w).setColor(padre.getColor());
            padre.setColor(1);
            ((NodoRN)((NodoRN)w).getIzq()).setColor(1);
            this.rotarDer(padre);
            x = (NodoRN)super.getRaiz();
        }
        x.setColor(1);
    }

    private NodoRN<T> getMenor(NodoRN<T> r) {
        return r.getIzq() == this.nulo ? r : this.getMenor((NodoRN<T>)r.getIzq());
    }

    private NodoRN<T> getMayor(NodoRN<T> r) {
        return ((NodoRN)r.getDer()).getInfo() == null ? r : this.getMayor((NodoRN<T>)r.getDer());
    }

    public void rotarIzq(NodoRN<T> t) {
        NodoBin t2 = t.getDer();
        t.setDer((NodoRN<T>)((NodoRN)t2).getIzq());
        ((NodoRN)((NodoRN)t2).getIzq()).setPadre(t);
        ((NodoRN)t2).setPadre(t.getPadre());
        if (t.getPadre().getInfo() == null) {
            super.setRaiz(t2);
            ((NodoRN)t2).setPadre(this.nulo);
        } else if (t == t.getPadre().getIzq()) {
            t.getPadre().setIzq((NodoRN<T>)t2);
        } else {
            t.getPadre().setDer((NodoRN<T>)t2);
        }
        ((NodoRN)t2).setIzq(t);
        t.setPadre((NodoRN<T>)t2);
    }

    public void rotarDer(NodoRN<T> t) {
        NodoBin t2 = t.getIzq();
        t.setIzq((NodoRN<T>)((NodoRN)t2).getDer());
        ((NodoRN)((NodoRN)t2).getDer()).setPadre(t);
        ((NodoRN)t2).setPadre(t.getPadre());
        if (t.getPadre().getInfo() == null) {
            super.setRaiz(t2);
            ((NodoRN)t2).setPadre(this.nulo);
        } else if (t == t.getPadre().getIzq()) {
            t.getPadre().setIzq((NodoRN<T>)t2);
        } else {
            t.getPadre().setDer((NodoRN<T>)t2);
        }
        ((NodoRN)t2).setDer(t);
        t.setPadre((NodoRN<T>)t2);
    }

    @Override
    public boolean esta(T x) {
        return this.estaRN((NodoRN)super.getRaiz(), x);
    }

    private boolean estaRN(NodoRN<T> r, T x) {
        if (r == null || r.getInfo() == null) {
            return false;
        }
        int compara = ((Comparable)r.getInfo()).compareTo(x);
        if (compara > 0) {
            return this.estaRN((NodoRN<T>)r.getIzq(), x);
        }
        if (compara < 0) {
            return this.estaRN((NodoRN<T>)r.getDer(), x);
        }
        return true;
    }

    @Override
    public Iterator<T> getHojas() {
        ListaCD l = new ListaCD();
        this.getHojas((NodoRN)super.getRaiz(), l);
        return l.iterator();
    }

    private void getHojas(NodoRN<T> r, ListaCD<T> l) {
        if (r != null && r.getInfo() != null) {
            if (this.esHoja(r)) {
                l.insertarAlFinal(r.getInfo());
            }
            this.getHojas((NodoRN<T>)r.getIzq(), l);
            this.getHojas((NodoRN<T>)r.getDer(), l);
        }
    }

    @Override
    public int contarHojas() {
        return this.contarHojas((NodoRN)super.getRaiz());
    }

    private int contarHojas(NodoRN<T> r) {
        if (r == null || r.getInfo() == null) {
            return 0;
        }
        if (this.esHoja(r)) {
            return 1;
        }
        int chi = this.contarHojas((NodoRN<T>)r.getIzq());
        int chd = this.contarHojas((NodoRN<T>)r.getDer());
        return chi + chd;
    }

    private boolean esHoja(NodoRN<T> n) {
        return !(n == null || n.getInfo() == null || n.getIzq() != null && ((NodoRN)n.getIzq()).getInfo() != null || n.getDer() != null && ((NodoRN)n.getDer()).getInfo() != null);
    }

    @Override
    public Iterator<T> preOrden() {
        ListaCD l = new ListaCD();
        this.preOrden(this.getRaiz(), l);
        return l.iterator();
    }

    private void preOrden(NodoBin<T> r, ListaCD<T> l) {
        if (r != null && r.getInfo() != null) {
            l.insertarAlFinal(r.getInfo());
            this.preOrden(r.getIzq(), l);
            this.preOrden(r.getDer(), l);
        }
    }

    @Override
    public Iterator<T> inOrden() {
        ListaCD l = new ListaCD();
        this.inOrden(this.getRaiz(), l);
        return l.iterator();
    }

    private void inOrden(NodoBin<T> r, ListaCD<T> l) {
        if (r != null && r.getInfo() != null) {
            this.inOrden(r.getIzq(), l);
            l.insertarAlFinal(r.getInfo());
            this.inOrden(r.getDer(), l);
        }
    }

    @Override
    public Iterator<T> postOrden() {
        ListaCD l = new ListaCD();
        this.postOrden(this.getRaiz(), l);
        return l.iterator();
    }

    private void postOrden(NodoBin<T> r, ListaCD<T> l) {
        if (r != null && r.getInfo() != null) {
            this.postOrden(r.getIzq(), l);
            this.postOrden(r.getDer(), l);
            l.insertarAlFinal(r.getInfo());
        }
    }

    @Override
    public Iterator<T> impNiveles() {
        ListaCD l = new ListaCD();
        if (!this.esVacio()) {
            Cola<NodoBin> c = new Cola<NodoBin>();
            c.enColar((NodoRN)this.getRaiz());
            while (!c.esVacia()) {
                NodoRN x = (NodoRN)c.deColar();
                l.insertarAlFinal(x.getInfo());
                if (x.getIzq() != null && ((NodoRN)x.getIzq()).getInfo() != null) {
                    c.enColar(x.getIzq());
                }
                if (x.getDer() == null || ((NodoRN)x.getDer()).getInfo() == null) continue;
                c.enColar(x.getDer());
            }
        }
        return l.iterator();
    }

    @Override
    public int getPeso() {
        return this.getPesoRN((NodoRN)super.getRaiz());
    }

    private int getPesoRN(NodoRN<T> r) {
        if (r == null || r.getInfo() == null) {
            return 0;
        }
        return this.getPesoRN((NodoRN<T>)r.getIzq()) + 1 + this.getPesoRN((NodoRN<T>)r.getDer());
    }

    @Override
    public boolean esVacio() {
        return (NodoRN)super.getRaiz() == null || ((NodoRN)super.getRaiz()).getInfo() == null;
    }

    @Override
    public int getAltura() {
        if (super.getRaiz() == null || super.getRaiz().getInfo() == null) {
            return 0;
        }
        return this.getAltura((NodoRN)this.getRaiz());
    }

    private int getAltura(NodoRN<T> r) {
        int ai = 0;
        int ad = 0;
        if (((NodoRN)r.getIzq()).getInfo() != null) {
            ai = this.getAltura((NodoRN<T>)r.getIzq());
        }
        if (((NodoRN)r.getDer()).getInfo() != null) {
            ad = this.getAltura((NodoRN<T>)r.getDer());
        }
        if (ai >= ad) {
            return ai + 1;
        }
        return ad + 1;
    }

    public void limpiar() {
        super.setRaiz(null);
    }

    @Override
    public ArbolRojiNegro<T> clonar() {
        ArbolRojiNegro<T> t = new ArbolRojiNegro<T>();
        t.setRaiz(this.clonarRN((NodoRN)this.getRaiz(), this.nulo));
        return t;
    }

    private NodoBin<T> clonarRN(NodoRN<T> r, NodoRN<T> p) {
        if (r == null || r.getInfo() == null) {
            return r;
        }
        NodoRN<T> aux = new NodoRN<T>(r.getInfo());
        aux.setColor(r.getColor());
        aux.setPadre(p);
        ((NodoBin)aux).setIzq(this.clonarRN((NodoRN<T>)r.getIzq(), aux));
        ((NodoBin)aux).setDer(this.clonarRN((NodoRN<T>)r.getDer(), aux));
        return aux;
    }

    @Override
    public void imprime() {
        this.imprimeRN((NodoRN)this.getRaiz());
    }

    public void imprimeRN(NodoRN<T> n) {
        int l = -1;
        int r = -1;
        int p = -1;
        if (n.getIzq() != this.nulo) {
            l = Integer.parseInt(((NodoRN)n.getIzq()).getInfo().toString());
        }
        if (n.getDer() != this.nulo) {
            r = Integer.parseInt(((NodoRN)n.getDer()).getInfo().toString());
        }
        if (n.getPadre() != this.nulo) {
            p = Integer.parseInt(n.getPadre().getInfo().toString());
        }
        System.out.println("Izquierdo: " + l + " Info: " + n.getInfo() + " Derecha: " + r + " Padre: " + p + " Color: " + n.getColor() + "\n");
        if (n.getIzq() != this.nulo) {
            this.imprimeRN((NodoRN<T>)n.getIzq());
        }
        if (n.getDer() != this.nulo) {
            this.imprimeRN((NodoRN<T>)n.getDer());
        }
    }
}

