/*
 * Decompiled with CFR 0.152.
 */
package Colecciones_SEED;

import Colecciones_SEED.ExceptionUFPS;
import Colecciones_SEED.IteratorLC;
import Colecciones_SEED.Nodo;
import java.util.Iterator;

public class ListaC<T>
implements Iterable<T> {
    private Nodo<T> cabeza = new Nodo<Object>(null, null);
    private int tamanio = 0;

    public ListaC() {
        this.cabeza.setSig(this.cabeza);
    }

    public void insertarAlInicio(T dato) {
        Nodo<T> x = new Nodo<T>(dato, this.cabeza.getSig());
        this.cabeza.setSig(x);
        ++this.tamanio;
    }

    public void insertarAlFinal(T x) {
        if (this.esVacia()) {
            this.insertarAlInicio(x);
        } else {
            try {
                Nodo<T> ult = this.getPos(this.tamanio - 1);
                if (ult == null) {
                    return;
                }
                ult.setSig(new Nodo<T>(x, this.cabeza));
                ++this.tamanio;
            }
            catch (ExceptionUFPS e) {
                System.err.println(e.getMensaje());
            }
        }
    }

    public void insertarOrdenado(T info) {
        if (this.esVacia()) {
            this.insertarAlInicio(info);
        } else {
            Comparable comparador;
            int rta;
            Nodo<T> x;
            Nodo<T> y = x = this.cabeza;
            for (x = x.getSig(); x != this.cabeza && (rta = (comparador = (Comparable)info).compareTo(x.getInfo())) >= 0; x = x.getSig()) {
                y = x;
            }
            if (x == this.cabeza.getSig()) {
                this.insertarAlInicio(info);
            } else {
                y.setSig(new Nodo<T>(info, x));
                ++this.tamanio;
            }
        }
    }

    public T eliminar(int i) {
        try {
            if (i == 0) {
                Nodo<T> x = this.cabeza.getSig();
                this.cabeza.setSig(x.getSig());
                --this.tamanio;
                return x.getInfo();
            }
            Nodo<T> x = this.getPos(i - 1);
            if (x == null) {
                return null;
            }
            Nodo<T> y = x.getSig();
            x.setSig(y.getSig());
            --this.tamanio;
            return y.getInfo();
        }
        catch (ExceptionUFPS ex) {
            System.err.println(ex.getMensaje());
            return null;
        }
    }

    public void vaciar() {
        this.cabeza.setSig(this.cabeza);
        this.tamanio = 0;
    }

    public T get(int i) {
        try {
            Nodo<T> x = this.getPos(i);
            if (x == null) {
                return null;
            }
            return x.getInfo();
        }
        catch (ExceptionUFPS ex) {
            System.err.println(ex.getMensaje());
            return null;
        }
    }

    public void set(int i, T dato) {
        try {
            Nodo<T> t = this.getPos(i);
            if (t == null) {
                return;
            }
            t.setInfo(dato);
        }
        catch (ExceptionUFPS e) {
            System.err.println(e.getMensaje());
        }
    }

    public int getTamanio() {
        return this.tamanio;
    }

    public boolean esVacia() {
        return this.cabeza == this.cabeza.getSig() || this.tamanio == 0;
    }

    public boolean esta(T info) {
        return this.getIndice(info) != -1;
    }

    @Override
    public Iterator<T> iterator() {
        return new IteratorLC<T>(this.cabeza);
    }

    public Object[] aVector() {
        if (this.esVacia()) {
            return null;
        }
        Object[] vector = new Object[this.getTamanio()];
        Iterator<T> it = this.iterator();
        int i = 0;
        while (it.hasNext()) {
            vector[i++] = it.next();
        }
        return vector;
    }

    public String toString() {
        if (this.esVacia()) {
            return "Lista Vacia";
        }
        String r = "";
        Nodo<T> x = this.cabeza.getSig();
        while (x.getInfo() != null) {
            r = r + x.getInfo().toString() + "->";
            x = x.getSig();
        }
        return r;
    }

    private Nodo<T> getPos(int i) throws ExceptionUFPS {
        if (i < 0 || i >= this.tamanio) {
            System.err.println("Error indice no valido en una Lista Circular!");
            return null;
        }
        Nodo<T> x = this.cabeza.getSig();
        while (i-- > 0) {
            x = x.getSig();
        }
        return x;
    }

    public int getIndice(T dato) {
        int i = 0;
        for (Nodo<T> x = this.cabeza.getSig(); x != this.cabeza; x = x.getSig()) {
            if (x.getInfo().equals(dato)) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

