/*
 * Decompiled with CFR 0.152.
 */
package Colecciones_SEED;

import Colecciones_SEED.ExceptionUFPS;
import Colecciones_SEED.IteratorLCD;
import Colecciones_SEED.NodoD;
import java.util.Iterator;

public class ListaCD<T>
implements Iterable<T> {
    private NodoD<T> cabeza = new NodoD<Object>(null, null, null);
    private int tamanio = 0;

    public ListaCD() {
        this.cabeza.setSig(this.cabeza);
        this.cabeza.setAnt(this.cabeza);
    }

    public void insertarAlInicio(T dato) {
        NodoD<T> x = new NodoD<T>(dato, this.cabeza.getSig(), this.cabeza);
        this.cabeza.setSig(x);
        x.getSig().setAnt(x);
        ++this.tamanio;
    }

    public void insertarAlFinal(T dato) {
        NodoD<T> x = new NodoD<T>(dato, this.cabeza, this.cabeza.getAnt());
        this.cabeza.getAnt().setSig(x);
        this.cabeza.setAnt(x);
        ++this.tamanio;
    }

    public void insertarOrdenado(T info) {
        if (this.esVacia()) {
            this.insertarAlInicio(info);
        } else {
            Comparable comparador;
            int rta;
            NodoD<T> x;
            NodoD<T> y = x = this.cabeza;
            for (x = x.getSig(); x != this.cabeza && (rta = (comparador = (Comparable)info).compareTo(x.getInfo())) >= 0; x = x.getSig()) {
                y = x;
            }
            if (x == this.cabeza.getSig()) {
                this.insertarAlInicio(info);
            } else {
                y.setSig(new NodoD<T>(info, x, y));
                x.setAnt(y.getSig());
                ++this.tamanio;
            }
        }
    }

    public T eliminar(int i) {
        try {
            if (i == 0) {
                NodoD x = this.cabeza.getSig();
                this.cabeza.setSig(x.getSig());
                this.cabeza.getSig().setAnt(this.cabeza);
                x.setSig(null);
                x.setAnt(null);
                --this.tamanio;
                return x.getInfo();
            }
            NodoD<T> x = this.getPos(i - 1);
            if (x == null) {
                return null;
            }
            NodoD y = x.getSig();
            x.setSig(y.getSig());
            y.getSig().setAnt(x);
            y.setSig(null);
            y.setAnt(null);
            --this.tamanio;
            return y.getInfo();
        }
        catch (ExceptionUFPS ex) {
            System.err.println(ex.getMessage());
            return null;
        }
    }

    public void vaciar() {
        this.cabeza = new NodoD<Object>(null, null, null);
        this.cabeza.setSig(this.cabeza);
        this.cabeza.setAnt(this.cabeza);
        this.tamanio = 0;
    }

    public T get(int i) {
        try {
            NodoD<T> x = this.getPos(i);
            if (x == null) {
                return null;
            }
            return x.getInfo();
        }
        catch (ExceptionUFPS ex) {
            System.err.println(ex.getMessage());
            return null;
        }
    }

    public void set(int i, T dato) {
        try {
            NodoD<T> t = this.getPos(i);
            if (t != null) {
                t.setInfo(dato);
            }
        }
        catch (ExceptionUFPS e) {
            System.err.println(e.getMessage());
        }
    }

    public int getTamanio() {
        return this.tamanio;
    }

    public boolean esVacia() {
        return this.cabeza == this.cabeza.getSig() || this.getTamanio() == 0;
    }

    public boolean esta(T info) {
        return this.getIndice(info) != -1;
    }

    @Override
    public Iterator<T> iterator() {
        return new IteratorLCD<T>(this.cabeza);
    }

    public Object[] aVector() {
        if (this.esVacia()) {
            return null;
        }
        Object[] vector = new Object[this.getTamanio()];
        Iterator<T> it = this.iterator();
        int i = 0;
        while (it.hasNext()) {
            vector[i++] = it.next();
        }
        return vector;
    }

    public String toString() {
        if (this.esVacia()) {
            return "Lista Vacia";
        }
        String r = "";
        NodoD<T> x = this.cabeza.getSig();
        while (x.getInfo() != null) {
            r = r + x.getInfo().toString() + "<->";
            x = x.getSig();
        }
        return r;
    }

    private NodoD<T> getPos(int i) throws ExceptionUFPS {
        if (i < 0 || i >= this.tamanio) {
            System.err.println("Error indice no valido en una Lista Circular Doblemente Enlazada");
            return null;
        }
        NodoD<T> x = this.cabeza.getSig();
        while (i-- > 0) {
            x = x.getSig();
        }
        return x;
    }

    public int getIndice(T dato) {
        int i = 0;
        for (NodoD<T> x = this.cabeza.getSig(); x != this.cabeza; x = x.getSig()) {
            if (x.getInfo().equals(dato)) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

