/*
 * Decompiled with CFR 0.152.
 */
package Colecciones_SEED;

import Colecciones_SEED.InformacionDeEntrada;
import Colecciones_SEED.ListaCD;

public class TablaHash<Clave, T> {
    private int numeroDatos = 0;
    private int numeroSlots;
    private ListaCD<InformacionDeEntrada<Clave, T>>[] informacionEntrada;

    public TablaHash() {
        this.numeroSlots = 11;
        this.informacionEntrada = new ListaCD[this.numeroSlots];
        this.inicializarListas();
    }

    public TablaHash(int numeroSlots) {
        this.numeroSlots = numeroSlots;
        this.informacionEntrada = new ListaCD[numeroSlots];
        this.inicializarListas();
    }

    public T insertar(Clave clave, T objeto) {
        int indice = 0;
        InformacionDeEntrada objetoAnterior = null;
        if (clave == null) {
            throw new RuntimeException("La Clave de Objeto no puede ser vacia!!!");
        }
        indice = this.index(clave);
        objetoAnterior = this.registrarEntrada(indice, clave);
        if (objetoAnterior == null) {
            InformacionDeEntrada<Clave, T> nuevoObjeto = new InformacionDeEntrada<Clave, T>(clave, objeto);
            this.informacionEntrada[indice].insertarAlFinal(nuevoObjeto);
            ++this.numeroDatos;
            return nuevoObjeto.getObjeto();
        }
        objetoAnterior.setObjeto(objeto);
        return objetoAnterior.getObjeto();
    }

    public T eliminar(Clave clave) {
        InformacionDeEntrada objeto;
        int i = 0;
        if (clave == null) {
            throw new RuntimeException("La Clave de Objeto no puede ser vacia!!!");
        }
        int indice = this.index(clave);
        ListaCD listaObjeto = this.informacionEntrada[indice];
        i = listaObjeto.getIndice(objeto = new InformacionDeEntrada(clave));
        if (i == -1) {
            objeto = null;
        } else {
            objeto = listaObjeto.eliminar(i);
            --this.numeroDatos;
        }
        return objeto.getObjeto();
    }

    public boolean esta(Clave clave) {
        return this.getObjeto(clave) != null;
    }

    public Object getObjeto(Clave clave) {
        InformacionDeEntrada objeto;
        if (clave == null) {
            throw new IllegalArgumentException("Clave null no permitida");
        }
        int indice = this.index(clave);
        ListaCD listaObjeto = this.informacionEntrada[indice];
        int i = listaObjeto.getIndice(objeto = new InformacionDeEntrada(clave));
        if (i == -1) {
            return null;
        }
        objeto = listaObjeto.get(i);
        return objeto.getObjeto();
    }

    private InformacionDeEntrada registrarEntrada(int indice, Clave clave) {
        ListaCD listaEntradas = this.informacionEntrada[indice];
        InformacionDeEntrada objeto = new InformacionDeEntrada(clave);
        int i = listaEntradas.getIndice(objeto);
        objeto = i == -1 ? null : listaEntradas.get(i);
        return objeto;
    }

    public int index(Clave clave) {
        int hcode = clave.hashCode();
        double num = (Math.sqrt(5.0) - 1.0) / 2.0;
        double t = (double)Math.abs(hcode) * num;
        return (int)((t - (double)((int)t)) * (double)this.numeroSlots);
    }

    public void eliminarTodo() {
        this.numeroDatos = 0;
        for (int i = 0; i < this.informacionEntrada.length; ++i) {
            this.informacionEntrada[i] = null;
        }
    }

    public int getNumeroDatos() {
        return this.numeroDatos;
    }

    public int getNumeroSlots() {
        return this.numeroSlots;
    }

    public ListaCD<InformacionDeEntrada<Clave, T>>[] getInformacionEntrada() {
        return this.informacionEntrada;
    }

    public int numSlotOcupados() {
        int cant = 0;
        for (int i = 0; i < this.numeroSlots; ++i) {
            if (this.informacionEntrada[i].esVacia()) continue;
            ++cant;
        }
        return cant;
    }

    public void setNumeroSlots(int numeroSlots) {
        this.numeroSlots = numeroSlots;
    }

    public void setInformacionEntrada(ListaCD<InformacionDeEntrada<Clave, T>>[] informacionEntrada) {
        this.informacionEntrada = informacionEntrada;
    }

    private void inicializarListas() {
        for (int i = 0; i < this.informacionEntrada.length; ++i) {
            this.informacionEntrada[i] = new ListaCD();
        }
    }

    private int obtenerPrimo(int numero) {
        int primo = numero - 1;
        while (!this.esPrimo(primo)) {
            primo += 2;
        }
        return primo;
    }

    public boolean esPrimo(int numero) {
        boolean esPrimo = false;
        int raizCuadrada = (int)Math.sqrt(numero);
        for (int i = 3; i <= raizCuadrada && !esPrimo; i += 2) {
            if (numero % i == 0) continue;
            esPrimo = true;
        }
        return esPrimo;
    }

    public String imprimir() {
        String msg = "";
        for (int i = 0; i < this.informacionEntrada.length; ++i) {
            if (this.informacionEntrada[i] == null) continue;
            msg = msg + "Slot de la tabla numero" + i + " ==>" + this.informacionEntrada[i].toString() + "\n";
        }
        return msg;
    }

    public boolean esVacia() {
        return this.numeroDatos == 0;
    }
}

