/*
 * Decompiled with CFR 0.152.
 */
package Graficos;

import Colecciones_SEED.Cola;
import Colecciones_SEED.ListaCD;
import Colecciones_SEED.NodoEneario;
import Colecciones_SEED.Pila;
import Graficos.NodoEnearioG;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.value.WritableValue;
import javafx.scene.control.Label;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Line;
import javafx.util.Duration;

public class ArbolEnearioG {
    private NodoEnearioG raiz = null;
    private Pila<Circle> pila = new Pila();
    private Pila<Label> lab = new Pila();
    private Pila<Line> lin = new Pila();

    public NodoEnearioG getRaiz() {
        return this.raiz;
    }

    public Pila<Circle> getPila() {
        return this.pila;
    }

    public void setPila(Pila<Circle> pila) {
        this.pila = pila;
    }

    public Pila<Label> getLab() {
        return this.lab;
    }

    public void setLab(Pila<Label> lab) {
        this.lab = lab;
    }

    public Pila<Line> getLin() {
        return this.lin;
    }

    public void setLin(Pila<Line> lin) {
        this.lin = lin;
    }

    public void setRaiz(NodoEnearioG raiz) {
        this.raiz = raiz;
    }

    public void crearArbol(NodoEneario r) {
        if (r == null) {
            this.setRaiz(null);
            return;
        }
        this.setRaiz(new NodoEnearioG((Integer)r.getInfo(), this.pila.desapilar(), this.lab.desapilar(), null, null));
        this.raiz.setHijo(this.crear(r.getHijo()));
    }

    private NodoEnearioG crear(NodoEneario r) {
        if (r == null) {
            return null;
        }
        NodoEnearioG hijo = new NodoEnearioG((Integer)r.getInfo(), this.pila.desapilar(), this.lab.desapilar(), null, null);
        hijo.setHijo(this.crear(r.getHijo()));
        hijo.setHermano(this.crear(r.getHermano()));
        return hijo;
    }

    public void cargarNodos(Circle[] nodos) {
        for (int i = 0; i < nodos.length; ++i) {
            this.pila.apilar(nodos[i]);
        }
    }

    public void cargarLabels(Label[] labels) {
        for (int i = 0; i < labels.length; ++i) {
            this.lab.apilar(labels[i]);
        }
    }

    public void cargarLineas(Line[] lineas) {
        for (int i = 0; i < lineas.length; ++i) {
            this.lin.apilar(lineas[i]);
        }
    }

    public void pintarArbol() {
        double lx1 = 200.0;
        double ly1 = 210.0;
        double lx2 = 189.0;
        double ly2 = 204.0;
        Label label = this.lab.desapilar();
        label.setPrefHeight(10.0);
        label.setPrefWidth(50.0);
        label.setLayoutX(lx2 - 50.0);
        label.setLayoutY(ly2);
        label.setText("<Raiz>");
        label.setTextFill((Paint)Color.GRAY);
        label.setVisible(true);
        if (this.raiz == null) {
            Circle c = this.pila.desapilar();
            Label l = this.lab.desapilar();
            c.setLayoutX(lx1);
            c.setLayoutY(ly1);
            l.setLayoutX(lx2);
            l.setLayoutY(ly2);
            c.setFill((Paint)Color.GRAY);
            c.setStroke((Paint)Color.BLACK);
            l.setText("Null");
            c.setVisible(true);
            l.setVisible(true);
            return;
        }
        Circle c = this.raiz.getC();
        Label l = this.raiz.getL();
        c.setLayoutX(lx1);
        c.setLayoutY(ly1);
        l.setLayoutX(lx2);
        l.setLayoutY(ly2);
        c.setFill((Paint)Color.GREENYELLOW);
        c.setStroke((Paint)Color.GREEN);
        l.setText(this.raiz.getInfo() + "");
        c.setVisible(true);
        l.setVisible(true);
        this.pintar(this.raiz.getHijo(), lx1, ly1 + 40.0, lx2, ly2 + 40.0);
        if (this.raiz.getHijo() != null) {
            Line l2 = this.lin.desapilar();
            l2.setLayoutX(this.raiz.getC().getLayoutX());
            l2.setLayoutY(this.raiz.getC().getLayoutY());
            l2.setStartX(0.0);
            l2.setEndX(0.0);
            l2.setStartY(0.0);
            l2.setEndY(40.0);
            l2.setVisible(true);
        }
    }

    private void pintar(NodoEnearioG r, double lx1, double ly1, double lx2, double ly2) {
        if (r == null) {
            return;
        }
        boolean v = true;
        if (lx1 >= 850.0) {
            v = false;
            System.err.println("El Arbol no puede pintarse en su Totalidad!");
        }
        Circle c = r.getC();
        Label l = r.getL();
        c.setLayoutX(lx1);
        c.setLayoutY(ly1);
        l.setLayoutX(lx2);
        l.setLayoutY(ly2);
        c.setFill((Paint)Color.GREENYELLOW);
        c.setStroke((Paint)Color.GREEN);
        l.setText(r.getInfo() + "");
        if (v) {
            c.setVisible(true);
            l.setVisible(true);
        }
        if (r.getHijo() != null) {
            this.pintar(r.getHijo(), lx1, ly1 + 40.0, lx2, ly2 + 40.0);
            Line l2 = this.lin.desapilar();
            l2.setLayoutX(r.getC().getLayoutX());
            l2.setLayoutY(r.getC().getLayoutY());
            l2.setStartX(0.0);
            l2.setEndX(0.0);
            l2.setStartY(0.0);
            l2.setEndY(40.0);
            if (v) {
                l2.setVisible(true);
            }
        }
        if (r.getHermano() != null) {
            int h = r.getHijo() != null ? this.numHijos(r.getInfo()) : 0;
            int ajuste = 40;
            if (h != 0) {
                ajuste = 40 * (h + 1);
            }
            this.pintar(r.getHermano(), lx1 + (double)ajuste, ly1, lx2 + (double)ajuste, ly2);
            Line l2 = this.lin.desapilar();
            l2.setLayoutX(r.getC().getLayoutX());
            l2.setLayoutY(r.getC().getLayoutY());
            l2.setStartX(0.0);
            l2.setEndX((double)ajuste);
            l2.setStartY(0.0);
            l2.setEndY(0.0);
            if (v) {
                l2.setVisible(true);
            }
        }
    }

    private NodoEnearioG buscar(NodoEnearioG r, int dato) {
        if (r == null) {
            return r;
        }
        if (r.getInfo() == dato) {
            return r;
        }
        for (NodoEnearioG q = r.getHijo(); q != null; q = q.getHermano()) {
            NodoEnearioG s = this.buscar(q, dato);
            if (s == null) continue;
            return s;
        }
        return null;
    }

    public int numHijos(int padre) {
        NodoEnearioG p = this.buscar(this.raiz, padre);
        int cant = this.numHijos(p);
        return cant;
    }

    private int numHijos(NodoEnearioG r) {
        NodoEnearioG q;
        int cant = 0;
        if (r != null && (q = r.getHijo()) != null) {
            cant += this.numHijos(q);
            for (q = q.getHermano(); q != null; q = q.getHermano()) {
                ++cant;
                cant += this.numHijos(q);
            }
        }
        return cant;
    }

    public void animacion(int i, int dato, Timeline tl) {
        tl = new Timeline();
        tl.setCycleCount(1);
        tl.getKeyFrames().removeAll((Object[])new KeyFrame[0]);
        switch (i) {
            case 0: {
                this.pintarInsertado(dato, tl);
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                this.buscarG(dato, tl);
                break;
            }
            case 3: {
                this.getHojas();
                break;
            }
            case 4: {
                this.getHojas();
                break;
            }
            case 5: {
                this.preOrden(tl);
                break;
            }
            case 6: {
                this.inOrden(tl);
                break;
            }
            case 7: {
                this.postOrden(tl);
                break;
            }
            case 8: {
                this.impNiveles(tl);
            }
        }
    }

    public void pintarInsertado(int dato, Timeline tl) {
        double durac = 0.0;
        NodoEnearioG n = this.buscar(this.raiz, dato);
        if (n != null && n.getC().getLayoutX() < 850.0) {
            tl.getKeyFrames().setAll((Object[])new KeyFrame[]{new KeyFrame(new Duration(durac), new KeyValue[]{new KeyValue((WritableValue)n.getC().strokeProperty(), (Object)Color.GREEN)}), new KeyFrame(new Duration(durac + 1000.0), new KeyValue[]{new KeyValue((WritableValue)n.getC().strokeProperty(), (Object)Color.RED)}), new KeyFrame(new Duration(durac), new KeyValue[]{new KeyValue((WritableValue)n.getC().fillProperty(), (Object)Color.GREENYELLOW)}), new KeyFrame(new Duration(durac + 1000.0), new KeyValue[]{new KeyValue((WritableValue)n.getC().fillProperty(), (Object)Color.BEIGE)})});
            tl.play();
        }
    }

    public boolean buscarG(int x, Timeline tl) {
        ListaCD<NodoEnearioG> l = new ListaCD<NodoEnearioG>();
        boolean rta = this.buscarG(this.raiz, x, l);
        int durac = 0;
        for (int i = 0; i < l.getTamanio(); ++i) {
            NodoEnearioG n = l.get(i);
            if (n.getC().getLayoutX() < 850.0) {
                tl.getKeyFrames().addAll((Object[])new KeyFrame[]{new KeyFrame(new Duration((double)durac), new KeyValue[]{new KeyValue((WritableValue)n.getC().strokeProperty(), (Object)Color.GREEN)}), new KeyFrame(new Duration((double)(durac + 1000)), new KeyValue[]{new KeyValue((WritableValue)n.getC().strokeProperty(), (Object)Color.RED)})});
                tl.getKeyFrames().addAll((Object[])new KeyFrame[]{new KeyFrame(new Duration((double)durac), new KeyValue[]{new KeyValue((WritableValue)n.getC().fillProperty(), (Object)Color.GREENYELLOW)}), new KeyFrame(new Duration((double)(durac + 1000)), new KeyValue[]{new KeyValue((WritableValue)n.getC().fillProperty(), (Object)Color.BEIGE)})});
            }
            durac += 1000;
        }
        tl.play();
        return rta;
    }

    private boolean buscarG(NodoEnearioG r, int x, ListaCD<NodoEnearioG> l) {
        if (r == null) {
            return false;
        }
        l.insertarAlFinal(r);
        if (r.getInfo() == x) {
            return true;
        }
        for (NodoEnearioG q = r.getHijo(); q != null; q = q.getHermano()) {
            boolean s = this.buscarG(q, x, l);
            if (!s) continue;
            return true;
        }
        return false;
    }

    public void getHojas() {
        this.getHojas(this.raiz);
    }

    private void getHojas(NodoEnearioG r) {
        if (r == null) {
            return;
        }
        NodoEnearioG q = r.getHijo();
        if (q == null) {
            if (r.getC().getLayoutX() < 850.0) {
                r.getC().setFill((Paint)Color.BEIGE);
                r.getC().setStroke((Paint)Color.RED);
            }
            return;
        }
        while (q != null) {
            this.getHojas(q);
            q = q.getHermano();
        }
    }

    public void preOrden(Timeline tl) {
        int durac = 0;
        ListaCD<NodoEnearioG> l = new ListaCD<NodoEnearioG>();
        this.preOrden(this.getRaiz(), l);
        for (int i = 0; i < l.getTamanio(); ++i) {
            NodoEnearioG n = l.get(i);
            if (n.getC().getLayoutX() < 850.0) {
                tl.getKeyFrames().addAll((Object[])new KeyFrame[]{new KeyFrame(new Duration((double)durac), new KeyValue[]{new KeyValue((WritableValue)n.getC().strokeProperty(), (Object)Color.GREEN)}), new KeyFrame(new Duration((double)(durac + 1000)), new KeyValue[]{new KeyValue((WritableValue)n.getC().strokeProperty(), (Object)Color.RED)})});
                tl.getKeyFrames().addAll((Object[])new KeyFrame[]{new KeyFrame(new Duration((double)durac), new KeyValue[]{new KeyValue((WritableValue)n.getC().fillProperty(), (Object)Color.GREENYELLOW)}), new KeyFrame(new Duration((double)(durac + 1000)), new KeyValue[]{new KeyValue((WritableValue)n.getC().fillProperty(), (Object)Color.BEIGE)})});
            }
            durac += 1000;
        }
        tl.play();
    }

    private void preOrden(NodoEnearioG r, ListaCD<NodoEnearioG> l) {
        if (r != null) {
            l.insertarAlFinal(r);
            NodoEnearioG q = r.getHijo();
            if (q != null) {
                this.preOrden(q, l);
                for (q = q.getHermano(); q != null; q = q.getHermano()) {
                    this.preOrden(q, l);
                }
            }
        }
    }

    public void inOrden(Timeline tl) {
        int durac = 0;
        ListaCD<NodoEnearioG> l = new ListaCD<NodoEnearioG>();
        this.inOrden(this.getRaiz(), l);
        for (int i = 0; i < l.getTamanio(); ++i) {
            NodoEnearioG n = l.get(i);
            if (n.getC().getLayoutX() < 850.0) {
                tl.getKeyFrames().addAll((Object[])new KeyFrame[]{new KeyFrame(new Duration((double)durac), new KeyValue[]{new KeyValue((WritableValue)n.getC().strokeProperty(), (Object)Color.GREEN)}), new KeyFrame(new Duration((double)(durac + 1000)), new KeyValue[]{new KeyValue((WritableValue)n.getC().strokeProperty(), (Object)Color.RED)})});
                tl.getKeyFrames().addAll((Object[])new KeyFrame[]{new KeyFrame(new Duration((double)durac), new KeyValue[]{new KeyValue((WritableValue)n.getC().fillProperty(), (Object)Color.GREENYELLOW)}), new KeyFrame(new Duration((double)(durac + 1000)), new KeyValue[]{new KeyValue((WritableValue)n.getC().fillProperty(), (Object)Color.BEIGE)})});
            }
            durac += 1000;
        }
        tl.play();
    }

    private void inOrden(NodoEnearioG r, ListaCD<NodoEnearioG> l) {
        if (r != null) {
            NodoEnearioG q = r.getHijo();
            if (q == null) {
                l.insertarAlFinal(r);
            } else {
                this.inOrden(q, l);
                l.insertarAlFinal(r);
                for (q = q.getHermano(); q != null; q = q.getHermano()) {
                    this.inOrden(q, l);
                }
            }
        }
    }

    public void postOrden(Timeline tl) {
        int durac = 0;
        ListaCD<NodoEnearioG> l = new ListaCD<NodoEnearioG>();
        this.postOrden(this.getRaiz(), l);
        for (int i = 0; i < l.getTamanio(); ++i) {
            NodoEnearioG n = l.get(i);
            if (n.getC().getLayoutX() < 850.0) {
                tl.getKeyFrames().addAll((Object[])new KeyFrame[]{new KeyFrame(new Duration((double)durac), new KeyValue[]{new KeyValue((WritableValue)n.getC().strokeProperty(), (Object)Color.GREEN)}), new KeyFrame(new Duration((double)(durac + 1000)), new KeyValue[]{new KeyValue((WritableValue)n.getC().strokeProperty(), (Object)Color.RED)})});
                tl.getKeyFrames().addAll((Object[])new KeyFrame[]{new KeyFrame(new Duration((double)durac), new KeyValue[]{new KeyValue((WritableValue)n.getC().fillProperty(), (Object)Color.GREENYELLOW)}), new KeyFrame(new Duration((double)(durac + 1000)), new KeyValue[]{new KeyValue((WritableValue)n.getC().fillProperty(), (Object)Color.BEIGE)})});
            }
            durac += 1000;
        }
        tl.play();
    }

    private void postOrden(NodoEnearioG r, ListaCD<NodoEnearioG> l) {
        if (r != null) {
            for (NodoEnearioG q = r.getHijo(); q != null; q = q.getHermano()) {
                this.postOrden(q, l);
            }
            l.insertarAlFinal(r);
        }
    }

    public void impNiveles(Timeline tl) {
        int durac = 0;
        ListaCD<NodoEnearioG> l = new ListaCD<NodoEnearioG>();
        this.impNiveles(l);
        for (int i = 0; i < l.getTamanio(); ++i) {
            NodoEnearioG n = l.get(i);
            if (n.getC().getLayoutX() < 850.0) {
                tl.getKeyFrames().addAll((Object[])new KeyFrame[]{new KeyFrame(new Duration((double)durac), new KeyValue[]{new KeyValue((WritableValue)n.getC().strokeProperty(), (Object)Color.GREEN)}), new KeyFrame(new Duration((double)(durac + 1000)), new KeyValue[]{new KeyValue((WritableValue)n.getC().strokeProperty(), (Object)Color.RED)})});
                tl.getKeyFrames().addAll((Object[])new KeyFrame[]{new KeyFrame(new Duration((double)durac), new KeyValue[]{new KeyValue((WritableValue)n.getC().fillProperty(), (Object)Color.GREENYELLOW)}), new KeyFrame(new Duration((double)(durac + 1000)), new KeyValue[]{new KeyValue((WritableValue)n.getC().fillProperty(), (Object)Color.BEIGE)})});
            }
            durac += 1000;
        }
        tl.play();
    }

    private void impNiveles(ListaCD<NodoEnearioG> l) {
        Cola<NodoEnearioG> c = new Cola<NodoEnearioG>();
        if (this.esVacio()) {
            return;
        }
        c.enColar(this.raiz);
        while (!c.esVacia()) {
            NodoEnearioG q = (NodoEnearioG)c.deColar();
            if (q == null) continue;
            l.insertarAlFinal(q);
            for (NodoEnearioG s = q.getHijo(); s != null; s = s.getHermano()) {
                c.enColar(s);
            }
        }
    }

    public boolean esVacio() {
        return this.raiz == null;
    }

    public String getLayoutsEliminar(int dato) {
        NodoEnearioG n = this.buscar(this.raiz, dato);
        double lx1 = 0.0;
        double lx2 = 0.0;
        double lx3 = 0.0;
        double lx4 = 0.0;
        if (n != null) {
            lx1 = n.getC().getLayoutX();
            lx2 = n.getC().getLayoutY();
            lx3 = n.getL().getLayoutX();
            lx4 = n.getL().getLayoutY();
        }
        return lx1 + "_" + lx2 + "_" + lx3 + "_" + lx4;
    }

    public void animacionEliminar(String layouts, int dato, Timeline tl, Circle c, Label l) {
        tl = new Timeline();
        tl.setCycleCount(1);
        tl.getKeyFrames().removeAll((Object[])new KeyFrame[0]);
        String[] v = layouts.split("_");
        c.setLayoutX(Double.parseDouble(v[0]));
        c.setLayoutY(Double.parseDouble(v[1]));
        l.setLayoutX(Double.parseDouble(v[2]));
        l.setLayoutY(Double.parseDouble(v[3]));
        l.setText(dato + "");
        if (c.getLayoutX() < 850.0) {
            c.setVisible(true);
            l.setVisible(true);
            tl.getKeyFrames().addAll((Object[])new KeyFrame[]{new KeyFrame(new Duration(0.0), new KeyValue[]{new KeyValue((WritableValue)c.strokeProperty(), (Object)Color.GREEN)}), new KeyFrame(new Duration(2000.0), new KeyValue[]{new KeyValue((WritableValue)c.strokeProperty(), (Object)Color.RED)})});
            tl.getKeyFrames().addAll((Object[])new KeyFrame[]{new KeyFrame(new Duration(0.0), new KeyValue[]{new KeyValue((WritableValue)c.fillProperty(), (Object)Color.GREENYELLOW)}), new KeyFrame(new Duration(2000.0), new KeyValue[]{new KeyValue((WritableValue)c.fillProperty(), (Object)Color.BEIGE)})});
            tl.getKeyFrames().addAll((Object[])new KeyFrame[]{new KeyFrame(new Duration(0.0), new KeyValue[]{new KeyValue((WritableValue)c.translateYProperty(), (Object)0)}), new KeyFrame(new Duration(3000.0), new KeyValue[]{new KeyValue((WritableValue)c.translateYProperty(), (Object)(440.0 - c.getLayoutY()))})});
            tl.getKeyFrames().addAll((Object[])new KeyFrame[]{new KeyFrame(new Duration(0.0), new KeyValue[]{new KeyValue((WritableValue)l.translateYProperty(), (Object)0)}), new KeyFrame(new Duration(3000.0), new KeyValue[]{new KeyValue((WritableValue)l.translateYProperty(), (Object)(434.0 - l.getLayoutY()))})});
            tl.getKeyFrames().addAll((Object[])new KeyFrame[]{new KeyFrame(new Duration(2000.0), new KeyValue[]{new KeyValue((WritableValue)c.visibleProperty(), (Object)true)}), new KeyFrame(new Duration(3000.0), new KeyValue[]{new KeyValue((WritableValue)c.visibleProperty(), (Object)false)})});
            tl.getKeyFrames().addAll((Object[])new KeyFrame[]{new KeyFrame(new Duration(2000.0), new KeyValue[]{new KeyValue((WritableValue)l.visibleProperty(), (Object)true)}), new KeyFrame(new Duration(3000.0), new KeyValue[]{new KeyValue((WritableValue)l.visibleProperty(), (Object)false)})});
            tl.play();
        }
    }
}

