/*
 * Decompiled with CFR 0.152.
 */
package Colecciones_SEED;

import Colecciones_SEED.Cola;
import Colecciones_SEED.ListaCD;
import Colecciones_SEED.NodoEneario;
import java.util.Iterator;

public class ArbolEneario<T> {
    private NodoEneario<T> raiz;

    public ArbolEneario() {
        this.raiz = null;
    }

    public ArbolEneario(NodoEneario<T> raiz) {
        this.raiz = raiz;
    }

    public T getObjRaiz() {
        return this.raiz.getInfo();
    }

    public NodoEneario<T> getRaiz() {
        return this.raiz;
    }

    public void setRaiz(NodoEneario<T> raiz) {
        this.raiz = raiz;
    }

    public boolean insertarHijo(T padre, T dato) {
        NodoEneario<T> nuevo = new NodoEneario<T>(dato);
        if (this.esVacio()) {
            this.setRaiz(nuevo);
            return true;
        }
        NodoEneario<T> p = this.buscar(padre);
        NodoEneario<T> n = this.buscar(dato);
        if (n != null || p == null) {
            return false;
        }
        if (this.esHoja(p)) {
            p.setHijo(nuevo);
            return true;
        }
        NodoEneario<T> q = p.getHijo();
        p.setHijo(nuevo);
        nuevo.setHermano(q);
        return true;
    }

    public boolean insertarHermano(T hermano, T dato) {
        NodoEneario<T> nuevo = new NodoEneario<T>(dato);
        if (this.esVacio()) {
            this.raiz = nuevo;
            return true;
        }
        NodoEneario<T> h = this.buscar(hermano);
        NodoEneario<T> n = this.buscar(dato);
        if (this.raiz == h || h == null || n != null) {
            return false;
        }
        NodoEneario<T> sigH = h.getHermano();
        h.setHermano(nuevo);
        nuevo.setHermano(sigH);
        return true;
    }

    public boolean eliminar(T dato) {
        if (!this.esta(dato)) {
            return false;
        }
        return this.elimina(dato);
    }

    private boolean elimina(T dato) {
        NodoEneario<T> n = this.getPadre(dato);
        if (n != null) {
            NodoEneario<T> h = n.getHijo();
            if (h.getHijo() != null) {
                NodoEneario<T> s;
                n.setHijo(s);
                NodoEneario<T> p = s;
                for (s = h.getHijo(); s != null; s = s.getHermano()) {
                    p = s;
                }
                p.setHermano(h.getHermano());
            } else {
                n.setHijo(h.getHermano());
            }
            return true;
        }
        n = this.getHermano(dato);
        if (n != null) {
            NodoEneario<T> h = n.getHermano();
            if (h.getHijo() != null) {
                NodoEneario<T> s;
                n.setHermano(s);
                NodoEneario<T> p = s;
                for (s = h.getHijo(); s != null; s = s.getHermano()) {
                    p = s;
                }
                p.setHermano(h.getHermano());
            } else {
                n.setHermano(n.getHermano().getHermano());
            }
            return true;
        }
        return this.eliminaR(dato);
    }

    private boolean eliminaR(T dato) {
        if (this.raiz.getInfo() != dato) {
            return false;
        }
        this.setRaiz(this.raiz.getHijo());
        if (this.raiz != null) {
            NodoEneario<T> h;
            NodoEneario<T> s = this.raiz.getHermano();
            if (h == null) {
                this.raiz.setHijo(s);
            } else {
                NodoEneario<T> p = h;
                for (h = this.raiz.getHijo(); h != null; h = h.getHermano()) {
                    p = h;
                }
                p.setHermano(s);
            }
        }
        return true;
    }

    private NodoEneario<T> getPadre(T info) {
        return this.gPadre(this.raiz, null, info);
    }

    private NodoEneario<T> gPadre(NodoEneario<T> r, NodoEneario<T> t, T dato) {
        if (r == null) {
            return null;
        }
        if (r.getInfo().equals(dato)) {
            return t;
        }
        for (NodoEneario<T> q = r.getHijo(); q != null; q = q.getHermano()) {
            NodoEneario<T> s = this.gPadre(q, r, dato);
            if (s != null) {
                return s;
            }
            r = null;
        }
        return null;
    }

    private NodoEneario<T> getHermano(T info) {
        return this.gHermano(this.raiz, null, info);
    }

    private NodoEneario<T> gHermano(NodoEneario<T> r, NodoEneario<T> h, T dato) {
        NodoEneario<T> p = null;
        if (r == null) {
            return null;
        }
        if (r.getInfo().equals(dato)) {
            return h;
        }
        for (NodoEneario<T> q = r.getHijo(); q != null; q = q.getHermano()) {
            NodoEneario<T> s = this.gHermano(q, p, dato);
            if (s != null) {
                return s;
            }
            p = q;
        }
        return null;
    }

    public boolean esta(T dato) {
        if (this.esVacio()) {
            return false;
        }
        boolean rta = this.esta(this.raiz, dato);
        return rta;
    }

    private boolean esta(NodoEneario<T> r, T dato) {
        if (r == null) {
            return false;
        }
        if (r.getInfo().equals(dato)) {
            return true;
        }
        for (NodoEneario<T> q = r.getHijo(); q != null; q = q.getHermano()) {
            boolean s = this.esta(q, dato);
            if (!s) continue;
            return true;
        }
        return false;
    }

    private NodoEneario<T> buscar(T dato) {
        if (this.esVacio()) {
            return null;
        }
        return this.buscar(this.raiz, dato);
    }

    private NodoEneario<T> buscar(NodoEneario<T> r, T dato) {
        if (r == null) {
            return r;
        }
        if (r.getInfo().equals(dato)) {
            return r;
        }
        for (NodoEneario<T> q = r.getHijo(); q != null; q = q.getHermano()) {
            NodoEneario<T> s = this.buscar(q, dato);
            if (s == null) continue;
            return s;
        }
        return null;
    }

    public Iterator<T> getHijos(T padre) {
        ListaCD<T> l = new ListaCD<T>();
        NodoEneario<T> p = this.buscar(this.raiz, padre);
        if (p == null) {
            return l.iterator();
        }
        for (NodoEneario<T> q = p.getHijo(); q != null; q = q.getHermano()) {
            l.insertarAlFinal(q.getInfo());
        }
        return l.iterator();
    }

    public Iterator<T> getHojas() {
        ListaCD l = new ListaCD();
        this.getHojas(this.raiz, l);
        return l.iterator();
    }

    private void getHojas(NodoEneario<T> r, ListaCD<T> l) {
        if (r == null) {
            return;
        }
        NodoEneario<T> q = r.getHijo();
        if (q == null) {
            l.insertarAlFinal(r.getInfo());
            return;
        }
        while (q != null) {
            this.getHojas(q, l);
            q = q.getHermano();
        }
    }

    private boolean esHoja(NodoEneario<T> r) {
        return r.getHijo() == null;
    }

    public int contarHojas() {
        return this.contarHojas(this.raiz);
    }

    private int contarHojas(NodoEneario<T> r) {
        if (r == null) {
            return 0;
        }
        NodoEneario<T> q = r.getHijo();
        if (q == null) {
            return 1;
        }
        int acum = 0;
        while (q != null) {
            acum += this.contarHojas(q);
            q = q.getHermano();
        }
        return acum;
    }

    public Iterator<T> preOrden() {
        ListaCD l = new ListaCD();
        this.preOrden(this.getRaiz(), l);
        return l.iterator();
    }

    private void preOrden(NodoEneario<T> r, ListaCD<T> l) {
        if (r != null) {
            l.insertarAlFinal(r.getInfo());
            NodoEneario<T> q = r.getHijo();
            if (q != null) {
                this.preOrden(q, l);
                for (q = q.getHermano(); q != null; q = q.getHermano()) {
                    this.preOrden(q, l);
                }
            }
        }
    }

    public Iterator<T> inOrden() {
        ListaCD l = new ListaCD();
        this.inOrden(this.getRaiz(), l);
        return l.iterator();
    }

    private void inOrden(NodoEneario<T> r, ListaCD<T> l) {
        if (r != null) {
            NodoEneario<T> q = r.getHijo();
            if (q == null) {
                l.insertarAlFinal(r.getInfo());
            } else {
                this.inOrden(q, l);
                l.insertarAlFinal(r.getInfo());
                for (q = q.getHermano(); q != null; q = q.getHermano()) {
                    this.inOrden(q, l);
                }
            }
        }
    }

    public Iterator<T> postOrden() {
        ListaCD l = new ListaCD();
        this.postOrden(this.getRaiz(), l);
        return l.iterator();
    }

    private void postOrden(NodoEneario<T> r, ListaCD<T> l) {
        if (r != null) {
            for (NodoEneario<T> q = r.getHijo(); q != null; q = q.getHermano()) {
                this.postOrden(q, l);
            }
            l.insertarAlFinal(r.getInfo());
        }
    }

    public Iterator<T> impNiveles() {
        Cola c = new Cola();
        ListaCD l = new ListaCD();
        if (this.esVacio()) {
            return l.iterator();
        }
        c.enColar(this.raiz);
        while (!c.esVacia()) {
            NodoEneario q = (NodoEneario)c.deColar();
            if (q == null) continue;
            l.insertarAlFinal(q.getInfo());
            for (NodoEneario s = q.getHijo(); s != null; s = s.getHermano()) {
                c.enColar(s);
            }
        }
        return l.iterator();
    }

    public int getPeso() {
        return this.getPeso(this.getRaiz());
    }

    private int getPeso(NodoEneario<T> r) {
        int cant = 0;
        if (r != null) {
            ++cant;
            NodoEneario<T> q = r.getHijo();
            if (q != null) {
                cant += this.getPeso(q);
                for (q = q.getHermano(); q != null; q = q.getHermano()) {
                    cant += this.getPeso(q);
                }
            }
        }
        return cant;
    }

    public boolean esVacio() {
        return this.raiz == null;
    }

    public int gordura() {
        if (this.esVacio()) {
            return 0;
        }
        int masGordo = -1;
        Cola cola = new Cola();
        Cola<Integer> c = new Cola<Integer>();
        int i = 0;
        int cont = 1;
        int ant = -1;
        cola.enColar(this.getRaiz());
        c.enColar(i);
        while (!cola.esVacia()) {
            NodoEneario q = (NodoEneario)cola.deColar();
            i = (Integer)c.deColar();
            if (i != ant) {
                if (masGordo < cont) {
                    masGordo = cont;
                }
                cont = 0;
                ant = i;
            }
            ++cont;
            for (NodoEneario s = q.getHijo(); s != null; s = s.getHermano()) {
                cola.enColar(s);
                c.enColar(i + 1);
            }
        }
        return masGordo < cont ? cont : masGordo;
    }

    public int getAltura() {
        if (this.esVacio()) {
            return 0;
        }
        return this.getAltura(this.getRaiz());
    }

    private int getAltura(NodoEneario<T> r) {
        NodoEneario<T> q;
        if (this.esHoja(r)) {
            return 1;
        }
        int maxAltura = 0;
        if (r != null && (q = r.getHijo()) != null) {
            while (q != null) {
                int auxAltura = this.getAltura(q);
                if (auxAltura > maxAltura) {
                    maxAltura = auxAltura;
                }
                q = q.getHermano();
            }
        }
        return maxAltura + 1;
    }
}

