/*
 * Decompiled with CFR 0.152.
 */
package Colecciones_SEED;

import Colecciones_SEED.ArbolBinarioBusqueda;
import Colecciones_SEED.NodoBin;
import java.util.Iterator;

public class ArbolSplay<T>
extends ArbolBinarioBusqueda<T> {
    public ArbolSplay() {
    }

    public ArbolSplay(T raiz) {
        super(raiz);
    }

    @Override
    public T getObjRaiz() {
        return super.getObjRaiz();
    }

    @Override
    public boolean insertar(T dato) {
        if (this.esVacio()) {
            super.setRaiz(new NodoBin<T>(dato));
            return true;
        }
        super.setRaiz(this.buscarAS(dato));
        int cmp = ((Comparable)dato).compareTo(super.getRaiz().getInfo());
        if (cmp < 0) {
            NodoBin n = new NodoBin(dato);
            n.setIzq(super.getRaiz().getIzq());
            n.setDer(super.getRaiz());
            super.getRaiz().setIzq(null);
            super.setRaiz(n);
            return true;
        }
        if (cmp > 0) {
            NodoBin n = new NodoBin(dato);
            n.setDer(super.getRaiz().getDer());
            n.setIzq(super.getRaiz());
            super.getRaiz().setDer(null);
            super.setRaiz(n);
            return true;
        }
        return false;
    }

    private NodoBin<T> biselar(NodoBin<T> r, T dato) {
        if (r == null) {
            return null;
        }
        int cmp1 = ((Comparable)dato).compareTo(r.getInfo());
        if (cmp1 < 0) {
            if (r.getIzq() == null) {
                return r;
            }
            int cmp2 = ((Comparable)dato).compareTo(r.getIzq().getInfo());
            if (cmp2 < 0) {
                r.getIzq().setIzq(this.biselar(r.getIzq().getIzq(), dato));
                r = this.rDerecha(r);
            } else if (cmp2 > 0) {
                r.getIzq().setDer(this.biselar(r.getIzq().getDer(), dato));
                if (r.getIzq().getDer() != null) {
                    r.setIzq(this.rIzquierda(r.getIzq()));
                }
            }
            if (r.getIzq() == null) {
                return r;
            }
            return this.rDerecha(r);
        }
        if (cmp1 > 0) {
            if (r.getDer() == null) {
                return r;
            }
            int cmp2 = ((Comparable)dato).compareTo(r.getDer().getInfo());
            if (cmp2 < 0) {
                r.getDer().setIzq(this.biselar(r.getDer().getIzq(), dato));
                if (r.getDer().getIzq() != null) {
                    r.setDer(this.rDerecha(r.getDer()));
                }
            } else if (cmp2 > 0) {
                r.getDer().setDer(this.biselar(r.getDer().getDer(), dato));
                r = this.rIzquierda(r);
            }
            if (r.getDer() == null) {
                return r;
            }
            return this.rIzquierda(r);
        }
        return r;
    }

    private NodoBin<T> rDerecha(NodoBin<T> r) {
        NodoBin<T> x = r.getIzq();
        r.setIzq(x.getDer());
        x.setDer(r);
        return x;
    }

    private NodoBin<T> rIzquierda(NodoBin<T> r) {
        NodoBin<T> x = r.getDer();
        r.setDer(x.getIzq());
        x.setIzq(r);
        return x;
    }

    @Override
    public boolean eliminar(T dato) {
        if (this.esVacio()) {
            return false;
        }
        super.setRaiz(this.buscarAS(dato));
        int cmp = ((Comparable)dato).compareTo(super.getRaiz().getInfo());
        if (cmp == 0) {
            if (super.getRaiz().getIzq() == null) {
                super.setRaiz(super.getRaiz().getDer());
            } else {
                NodoBin x = super.getRaiz().getDer();
                super.setRaiz(super.getRaiz().getIzq());
                super.setRaiz(this.biselar(super.getRaiz(), dato));
                super.getRaiz().setDer(x);
            }
            return true;
        }
        return false;
    }

    private NodoBin<T> buscarAS(T dato) {
        if (this.esVacio()) {
            return null;
        }
        return this.biselar(super.getRaiz(), dato);
    }

    public boolean estaAS(T dato) {
        if (this.esVacio()) {
            return false;
        }
        super.setRaiz(this.buscarAS(dato));
        return super.getRaiz().getInfo().equals(dato);
    }

    @Override
    public Iterator<T> getHojas() {
        return super.getHojas();
    }

    @Override
    public int contarHojas() {
        return super.contarHojas();
    }

    @Override
    public Iterator<T> preOrden() {
        return super.preOrden();
    }

    @Override
    public Iterator<T> inOrden() {
        return super.inOrden();
    }

    @Override
    public Iterator<T> postOrden() {
        return super.postOrden();
    }

    @Override
    public Iterator<T> impNiveles() {
        return super.impNiveles();
    }

    @Override
    public int getPeso() {
        return super.getPeso();
    }

    @Override
    public boolean esVacio() {
        return super.esVacio();
    }

    @Override
    public int getAltura() {
        return super.getAltura();
    }

    @Override
    public ArbolSplay<T> clonar() {
        ArbolSplay t = new ArbolSplay();
        t.setRaiz(this.clonarAS(this.getRaiz()));
        return t;
    }

    private NodoBin<T> clonarAS(NodoBin<T> r) {
        if (r == null) {
            return r;
        }
        NodoBin<T> aux = new NodoBin<T>(r.getInfo(), this.clonarAS(r.getIzq()), this.clonarAS(r.getDer()));
        return aux;
    }

    @Override
    public void imprime() {
        System.out.println(" ----- Arbol Splay ----- ");
        this.imprimeAS(super.getRaiz());
    }

    public void imprimeAS(NodoBin<T> n) {
        int l = 0;
        int r = 0;
        if (n == null) {
            return;
        }
        if (n.getIzq() != null) {
            l = Integer.parseInt(n.getIzq().getInfo().toString());
        }
        if (n.getDer() != null) {
            r = Integer.parseInt(n.getDer().getInfo().toString());
        }
        System.out.println("NodoIzq: " + l + "\t Info: " + n.getInfo() + "\t NodoDer: " + r);
        if (n.getIzq() != null) {
            this.imprimeAS(n.getIzq());
        }
        if (n.getDer() != null) {
            this.imprimeAS(n.getDer());
        }
    }
}

