/*
 * Decompiled with CFR 0.152.
 */
package Graficos;

import Colecciones_SEED.Cola;
import Colecciones_SEED.ListaCD;
import Colecciones_SEED.NodoBin;
import Colecciones_SEED.Pila;
import Graficos.NodoBinG;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.value.WritableValue;
import javafx.scene.control.Label;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Line;
import javafx.util.Duration;

public class ArbolBinarioG {
    private NodoBinG raiz = null;
    private Pila<Circle> pila = new Pila();
    private Pila<Label> lab = new Pila();
    private Pila<Line> lin = new Pila();

    public NodoBinG getRaiz() {
        return this.raiz;
    }

    public Pila<Circle> getPila() {
        return this.pila;
    }

    public void setPila(Pila<Circle> pila) {
        this.pila = pila;
    }

    public Pila<Label> getLab() {
        return this.lab;
    }

    public void setLab(Pila<Label> lab) {
        this.lab = lab;
    }

    public Pila<Line> getLin() {
        return this.lin;
    }

    public void setLin(Pila<Line> lin) {
        this.lin = lin;
    }

    public void setRaiz(NodoBinG raiz) {
        this.raiz = raiz;
    }

    public void crearArbol(NodoBin raiz) {
        this.setRaiz(this.crear(raiz));
    }

    private NodoBinG crear(NodoBin r) {
        if (r == null) {
            return null;
        }
        NodoBinG aux = new NodoBinG((Integer)r.getInfo(), this.pila.desapilar(), this.lab.desapilar(), this.crear(r.getIzq()), this.crear(r.getDer()));
        return aux;
    }

    public void cargarNodos(Circle[] nodos) {
        for (int i = 0; i < nodos.length; ++i) {
            this.pila.apilar(nodos[i]);
        }
    }

    public void cargarLabels(Label[] labels) {
        for (int i = 0; i < labels.length; ++i) {
            this.lab.apilar(labels[i]);
        }
    }

    public void cargarLineas(Line[] lineas) {
        for (int i = 0; i < lineas.length; ++i) {
            this.lin.apilar(lineas[i]);
        }
    }

    public void pintarArbol(int alt) {
        if (this.raiz == null) {
            Circle c = this.pila.desapilar();
            Label l = this.lab.desapilar();
            c.setLayoutX(512.0);
            c.setLayoutY(195.0);
            l.setLayoutX(501.0);
            l.setLayoutY(189.0);
            c.setFill((Paint)Color.GRAY);
            c.setStroke((Paint)Color.BLACK);
            l.setText("Null");
            c.setVisible(true);
            l.setVisible(true);
            return;
        }
        int ajuste = 0;
        switch (alt) {
            case 0: {
                ajuste = 0;
                break;
            }
            case 1: {
                ajuste = 1;
                break;
            }
            case 2: {
                ajuste = 2;
                break;
            }
            case 3: {
                ajuste = 4;
                break;
            }
            case 4: {
                ajuste = 8;
                break;
            }
            case 5: {
                ajuste = 16;
                break;
            }
            case 6: {
                ajuste = 32;
                break;
            }
            case 7: {
                ajuste = 64;
            }
        }
        this.pinta(this.raiz, null, ajuste);
        this.reajustarColores();
    }

    private void pinta(NodoBinG r, NodoBinG padre, int ajuste) {
        Line l;
        ajuste /= 2;
        if (r == null) {
            return;
        }
        r.getC().setVisible(true);
        r.getL().setText(r.getInfo() + "");
        r.getL().setVisible(true);
        if (padre == null) {
            r.getC().setLayoutX(512.0);
            r.getC().setLayoutY(195.0);
            r.getL().setLayoutX(501.0);
            r.getL().setLayoutY(189.0);
            r.getC().setVisible(true);
            r.getL().setText(r.getInfo() + "");
            r.getL().setVisible(true);
        }
        if (r.getIzq() != null) {
            r.getIzq().getC().setLayoutX(r.getC().getLayoutX() - (double)(15 * ajuste));
            r.getIzq().getC().setLayoutY(r.getC().getLayoutY() + 50.0);
            r.getIzq().getL().setLayoutX(r.getL().getLayoutX() - (double)(15 * ajuste));
            r.getIzq().getL().setLayoutY(r.getL().getLayoutY() + 50.0);
            r.getIzq().getC().setVisible(true);
            r.getIzq().getL().setText(r.getInfo() + "");
            r.getIzq().getL().setVisible(true);
            l = this.lin.desapilar();
            l.setLayoutX(r.getC().getLayoutX());
            l.setLayoutY(r.getC().getLayoutY());
            l.setStartX(0.0);
            l.setEndX((double)(-(15 * ajuste)));
            l.setStartY(0.0);
            l.setEndY(50.0);
            l.setVisible(true);
        }
        if (r.getDer() != null) {
            r.getDer().getC().setLayoutX(r.getC().getLayoutX() + (double)(15 * ajuste));
            r.getDer().getC().setLayoutY(r.getC().getLayoutY() + 50.0);
            r.getDer().getL().setLayoutX(r.getL().getLayoutX() + (double)(15 * ajuste));
            r.getDer().getL().setLayoutY(r.getL().getLayoutY() + 50.0);
            r.getDer().getC().setVisible(true);
            r.getDer().getL().setText(r.getInfo() + "");
            r.getDer().getL().setVisible(true);
            l = this.lin.desapilar();
            l.setLayoutX(r.getC().getLayoutX());
            l.setLayoutY(r.getC().getLayoutY());
            l.setStartX(0.0);
            l.setEndX((double)(15 * ajuste));
            l.setStartY(0.0);
            l.setEndY(50.0);
            l.setVisible(true);
        }
        this.pinta(r.getIzq(), r, ajuste);
        this.pinta(r.getDer(), r, ajuste);
    }

    public void animacion(int i, int dato, Timeline tl) {
        this.reajustarColores();
        tl = new Timeline();
        tl.setCycleCount(1);
        tl.getKeyFrames().removeAll((Object[])new KeyFrame[0]);
        switch (i) {
            case 0: {
                this.pintarInsertado(dato, tl);
                break;
            }
            case 1: {
                this.pintarEliminado(dato, tl);
                break;
            }
            case 2: {
                this.buscarG(dato, tl);
                break;
            }
            case 3: {
                this.getHojas();
                break;
            }
            case 4: {
                this.getHojas();
                break;
            }
            case 5: {
                this.preOrden(tl);
                break;
            }
            case 6: {
                this.inOrden(tl);
                break;
            }
            case 7: {
                this.postOrden(tl);
                break;
            }
            case 8: {
                this.impNiveles(tl);
            }
        }
    }

    public void pintarInsertado(int dato, Timeline tl) {
        double durac = 0.0;
        NodoBinG n = this.buscar(this.raiz, dato);
        if (n != null) {
            tl.getKeyFrames().setAll((Object[])new KeyFrame[]{new KeyFrame(new Duration(durac), new KeyValue[]{new KeyValue((WritableValue)n.getC().strokeProperty(), (Object)Color.GREEN)}), new KeyFrame(new Duration(durac + 1000.0), new KeyValue[]{new KeyValue((WritableValue)n.getC().strokeProperty(), (Object)Color.RED)}), new KeyFrame(new Duration(durac), new KeyValue[]{new KeyValue((WritableValue)n.getC().fillProperty(), (Object)Color.GREENYELLOW)}), new KeyFrame(new Duration(durac + 1000.0), new KeyValue[]{new KeyValue((WritableValue)n.getC().fillProperty(), (Object)Color.BEIGE)})});
            tl.play();
        }
    }

    private NodoBinG buscar(NodoBinG r, int x) {
        NodoBinG aux;
        if (r == null) {
            return null;
        }
        if (r.getInfo() == x) {
            return r;
        }
        NodoBinG nodoBinG = aux = r.getIzq() == null ? null : this.buscar(r.getIzq(), x);
        if (aux != null) {
            return aux;
        }
        return r.getDer() == null ? null : this.buscar(r.getDer(), x);
    }

    public boolean buscarG(int x, Timeline tl) {
        ListaCD<NodoBinG> l = new ListaCD<NodoBinG>();
        boolean rta = this.buscarG(this.raiz, x, l);
        int durac = 0;
        for (int i = 0; i < l.getTamanio(); ++i) {
            NodoBinG n = l.get(i);
            tl.getKeyFrames().addAll((Object[])new KeyFrame[]{new KeyFrame(new Duration((double)durac), new KeyValue[]{new KeyValue((WritableValue)n.getC().strokeProperty(), (Object)Color.GREEN)}), new KeyFrame(new Duration((double)(durac + 1000)), new KeyValue[]{new KeyValue((WritableValue)n.getC().strokeProperty(), (Object)Color.RED)})});
            tl.getKeyFrames().addAll((Object[])new KeyFrame[]{new KeyFrame(new Duration((double)durac), new KeyValue[]{new KeyValue((WritableValue)n.getC().fillProperty(), (Object)Color.GREENYELLOW)}), new KeyFrame(new Duration((double)(durac + 1000)), new KeyValue[]{new KeyValue((WritableValue)n.getC().fillProperty(), (Object)Color.BEIGE)})});
            durac += 1000;
        }
        tl.play();
        return rta;
    }

    private boolean buscarG(NodoBinG r, int x, ListaCD<NodoBinG> l) {
        boolean tmp;
        if (r == null) {
            return false;
        }
        l.insertarAlFinal(r);
        if (r.getInfo() == x) {
            return true;
        }
        boolean bl = tmp = r.getIzq() == null ? false : this.buscarG(r.getIzq(), x, l);
        if (tmp) {
            return true;
        }
        return r.getDer() == null ? false : this.buscarG(r.getDer(), x, l);
    }

    public void getHojas() {
        this.getHojas(this.raiz);
    }

    private void getHojas(NodoBinG r) {
        if (r != null) {
            if (this.esHoja(r)) {
                r.getC().setFill((Paint)Color.BEIGE);
                r.getC().setStroke((Paint)Color.RED);
            }
            this.getHojas(r.getIzq());
            this.getHojas(r.getDer());
        }
    }

    private boolean esHoja(NodoBinG x) {
        return x != null && x.getIzq() == null && x.getDer() == null;
    }

    public void preOrden(Timeline tl) {
        int durac = 0;
        ListaCD<NodoBinG> l = new ListaCD<NodoBinG>();
        this.preOrden(this.getRaiz(), l);
        for (int i = 0; i < l.getTamanio(); ++i) {
            NodoBinG n = l.get(i);
            tl.getKeyFrames().addAll((Object[])new KeyFrame[]{new KeyFrame(new Duration((double)durac), new KeyValue[]{new KeyValue((WritableValue)n.getC().strokeProperty(), (Object)Color.GREEN)}), new KeyFrame(new Duration((double)(durac + 1000)), new KeyValue[]{new KeyValue((WritableValue)n.getC().strokeProperty(), (Object)Color.RED)})});
            tl.getKeyFrames().addAll((Object[])new KeyFrame[]{new KeyFrame(new Duration((double)durac), new KeyValue[]{new KeyValue((WritableValue)n.getC().fillProperty(), (Object)Color.GREENYELLOW)}), new KeyFrame(new Duration((double)(durac + 1000)), new KeyValue[]{new KeyValue((WritableValue)n.getC().fillProperty(), (Object)Color.BEIGE)})});
            durac += 1000;
        }
        tl.play();
    }

    private void preOrden(NodoBinG r, ListaCD<NodoBinG> l) {
        if (r != null) {
            l.insertarAlFinal(r);
            this.preOrden(r.getIzq(), l);
            this.preOrden(r.getDer(), l);
        }
    }

    public void inOrden(Timeline tl) {
        int durac = 0;
        ListaCD<NodoBinG> l = new ListaCD<NodoBinG>();
        this.inOrden(this.getRaiz(), l);
        for (int i = 0; i < l.getTamanio(); ++i) {
            NodoBinG n = l.get(i);
            tl.getKeyFrames().addAll((Object[])new KeyFrame[]{new KeyFrame(new Duration((double)durac), new KeyValue[]{new KeyValue((WritableValue)n.getC().strokeProperty(), (Object)Color.GREEN)}), new KeyFrame(new Duration((double)(durac + 1000)), new KeyValue[]{new KeyValue((WritableValue)n.getC().strokeProperty(), (Object)Color.RED)})});
            tl.getKeyFrames().addAll((Object[])new KeyFrame[]{new KeyFrame(new Duration((double)durac), new KeyValue[]{new KeyValue((WritableValue)n.getC().fillProperty(), (Object)Color.GREENYELLOW)}), new KeyFrame(new Duration((double)(durac + 1000)), new KeyValue[]{new KeyValue((WritableValue)n.getC().fillProperty(), (Object)Color.BEIGE)})});
            durac += 1000;
        }
        tl.play();
    }

    private void inOrden(NodoBinG r, ListaCD<NodoBinG> l) {
        if (r != null) {
            this.inOrden(r.getIzq(), l);
            l.insertarAlFinal(r);
            this.inOrden(r.getDer(), l);
        }
    }

    public void postOrden(Timeline tl) {
        int durac = 0;
        ListaCD<NodoBinG> l = new ListaCD<NodoBinG>();
        this.postOrden(this.getRaiz(), l);
        for (int i = 0; i < l.getTamanio(); ++i) {
            NodoBinG n = l.get(i);
            tl.getKeyFrames().addAll((Object[])new KeyFrame[]{new KeyFrame(new Duration((double)durac), new KeyValue[]{new KeyValue((WritableValue)n.getC().strokeProperty(), (Object)Color.GREEN)}), new KeyFrame(new Duration((double)(durac + 1000)), new KeyValue[]{new KeyValue((WritableValue)n.getC().strokeProperty(), (Object)Color.RED)})});
            tl.getKeyFrames().addAll((Object[])new KeyFrame[]{new KeyFrame(new Duration((double)durac), new KeyValue[]{new KeyValue((WritableValue)n.getC().fillProperty(), (Object)Color.GREENYELLOW)}), new KeyFrame(new Duration((double)(durac + 1000)), new KeyValue[]{new KeyValue((WritableValue)n.getC().fillProperty(), (Object)Color.BEIGE)})});
            durac += 1000;
        }
        tl.play();
    }

    private void postOrden(NodoBinG r, ListaCD<NodoBinG> l) {
        if (r != null) {
            this.postOrden(r.getIzq(), l);
            this.postOrden(r.getDer(), l);
            l.insertarAlFinal(r);
        }
    }

    public void impNiveles(Timeline tl) {
        int durac = 0;
        ListaCD<NodoBinG> l = new ListaCD<NodoBinG>();
        this.impNiveles(l);
        for (int i = 0; i < l.getTamanio(); ++i) {
            NodoBinG n = l.get(i);
            tl.getKeyFrames().addAll((Object[])new KeyFrame[]{new KeyFrame(new Duration((double)durac), new KeyValue[]{new KeyValue((WritableValue)n.getC().strokeProperty(), (Object)Color.GREEN)}), new KeyFrame(new Duration((double)(durac + 1000)), new KeyValue[]{new KeyValue((WritableValue)n.getC().strokeProperty(), (Object)Color.RED)})});
            tl.getKeyFrames().addAll((Object[])new KeyFrame[]{new KeyFrame(new Duration((double)durac), new KeyValue[]{new KeyValue((WritableValue)n.getC().fillProperty(), (Object)Color.GREENYELLOW)}), new KeyFrame(new Duration((double)(durac + 1000)), new KeyValue[]{new KeyValue((WritableValue)n.getC().fillProperty(), (Object)Color.BEIGE)})});
            durac += 1000;
        }
        tl.play();
    }

    private void impNiveles(ListaCD<NodoBinG> l) {
        if (!this.esVacio()) {
            Cola<NodoBinG> c = new Cola<NodoBinG>();
            c.enColar(this.getRaiz());
            while (!c.esVacia()) {
                NodoBinG x = (NodoBinG)c.deColar();
                l.insertarAlFinal(x);
                if (x.getIzq() != null) {
                    c.enColar(x.getIzq());
                }
                if (x.getDer() == null) continue;
                c.enColar(x.getDer());
            }
        }
    }

    public boolean esVacio() {
        return this.raiz == null;
    }

    public void reajustarColores() {
        this.reajustarColores(this.raiz);
    }

    private void reajustarColores(NodoBinG r) {
        if (r == null) {
            return;
        }
        r.getC().setFill((Paint)Color.GREENYELLOW);
        r.getC().setStroke((Paint)Color.GREEN);
        this.reajustarColores(r.getIzq());
        this.reajustarColores(r.getDer());
    }

    public void invisibles() {
        this.invisibles(this.raiz);
    }

    private void invisibles(NodoBinG r) {
        if (r == null) {
            return;
        }
        r.getC().setFill((Paint)Color.GREENYELLOW);
        r.getC().setStroke((Paint)Color.GREEN);
        r.getC().setVisible(false);
        r.getL().setVisible(false);
        this.invisibles(r.getIzq());
        this.invisibles(r.getDer());
    }

    private void pintarEliminado(int dato, Timeline tl) {
    }

    public String getLayoutsEliminar(int dato) {
        NodoBinG n = this.buscar(this.raiz, dato);
        double lx1 = 0.0;
        double lx2 = 0.0;
        double lx3 = 0.0;
        double lx4 = 0.0;
        if (n != null) {
            lx1 = n.getC().getLayoutX();
            lx2 = n.getC().getLayoutY();
            lx3 = n.getL().getLayoutX();
            lx4 = n.getL().getLayoutY();
        }
        return lx1 + "_" + lx2 + "_" + lx3 + "_" + lx4;
    }

    public void animacionEliminar(String layouts, int dato, Timeline tl, Circle c, Label l) {
        tl = new Timeline();
        tl.setCycleCount(1);
        tl.getKeyFrames().removeAll((Object[])new KeyFrame[0]);
        String[] v = layouts.split("_");
        c.setLayoutX(Double.parseDouble(v[0]));
        c.setLayoutY(Double.parseDouble(v[1]));
        l.setLayoutX(Double.parseDouble(v[2]));
        l.setLayoutY(Double.parseDouble(v[3]));
        l.setText(dato + "");
        c.setVisible(true);
        l.setVisible(true);
        tl.getKeyFrames().addAll((Object[])new KeyFrame[]{new KeyFrame(new Duration(0.0), new KeyValue[]{new KeyValue((WritableValue)c.strokeProperty(), (Object)Color.GREEN)}), new KeyFrame(new Duration(2000.0), new KeyValue[]{new KeyValue((WritableValue)c.strokeProperty(), (Object)Color.RED)})});
        tl.getKeyFrames().addAll((Object[])new KeyFrame[]{new KeyFrame(new Duration(0.0), new KeyValue[]{new KeyValue((WritableValue)c.fillProperty(), (Object)Color.GREENYELLOW)}), new KeyFrame(new Duration(2000.0), new KeyValue[]{new KeyValue((WritableValue)c.fillProperty(), (Object)Color.BEIGE)})});
        tl.getKeyFrames().addAll((Object[])new KeyFrame[]{new KeyFrame(new Duration(0.0), new KeyValue[]{new KeyValue((WritableValue)c.translateYProperty(), (Object)0)}), new KeyFrame(new Duration(3000.0), new KeyValue[]{new KeyValue((WritableValue)c.translateYProperty(), (Object)(400.0 - c.getLayoutY()))})});
        tl.getKeyFrames().addAll((Object[])new KeyFrame[]{new KeyFrame(new Duration(0.0), new KeyValue[]{new KeyValue((WritableValue)l.translateYProperty(), (Object)0)}), new KeyFrame(new Duration(3000.0), new KeyValue[]{new KeyValue((WritableValue)l.translateYProperty(), (Object)(394.0 - l.getLayoutY()))})});
        tl.getKeyFrames().addAll((Object[])new KeyFrame[]{new KeyFrame(new Duration(2000.0), new KeyValue[]{new KeyValue((WritableValue)c.visibleProperty(), (Object)true)}), new KeyFrame(new Duration(3000.0), new KeyValue[]{new KeyValue((WritableValue)c.visibleProperty(), (Object)false)})});
        tl.getKeyFrames().addAll((Object[])new KeyFrame[]{new KeyFrame(new Duration(2000.0), new KeyValue[]{new KeyValue((WritableValue)l.visibleProperty(), (Object)true)}), new KeyFrame(new Duration(3000.0), new KeyValue[]{new KeyValue((WritableValue)l.visibleProperty(), (Object)false)})});
        tl.play();
    }
}

