/**
 * ---------------------------------------------------------------------
 * $Id: SimuladorArbolRojiNegro.java,v 1.0 2013/08/23 
 * Universidad Francisco de Paula Santander 
 * Programa Ingenieria de Sistemas
 *
 * Proyecto: SEED_UFPS
 * ----------------------------------------------------------------------
 */

package Mundo_ArbolRojiNegro;

import Colecciones_SEED.ArbolRojiNegro;
import Colecciones_SEED.NodoRN;
import Graficos.ArbolRojiNegroG;
import java.util.Iterator;

/**
 * Clase que conecta la capa de presentación del Simulador con las Estructuras de Datos.
 * @author Uriel Garcia - Yulieth Pabon
 * @version 1.0
 */

public class SimuladorArbolRojiNegro {
    
    private ArbolRojiNegro<Integer>  miArbolRN;
    
    public SimuladorArbolRojiNegro(){
        this.miArbolRN = new ArbolRojiNegro<Integer>();
    }
    
    public ArbolRojiNegroG crearArbolRojiNegroGrafico(ArbolRojiNegroG n) {
        n.crearArbol((NodoRN)this.miArbolRN.getRaiz());
        return (n);
    }

    public int conocerAltura() {
        return this.miArbolRN.getAltura();
    }

    public int insertarDato(int dato) {
        if(this.miArbolRN.esta(dato))
            return -1; //Dato repetido
        ArbolRojiNegro<Integer> clon = this.miArbolRN.clonar();
        if(clon.insertar(dato)){
            if(clon.getAltura()>5)
                return -2; //Supera la altura 5
            this.miArbolRN.insertar(dato);
            return 0; //Insercion correcta
        }
        return -3; //No se pudo insertar
    }

    public boolean estaVacioArbol() {
        return (this.miArbolRN.esVacio());
    }

    public boolean eliminarDato(int dato) {
        return (this.miArbolRN.eliminar(dato));
    }

    public boolean estaDatoenArbol(int dato) {
        return (this.miArbolRN.esta(dato));
    }

    public int conocerPeso() {
        return (this.miArbolRN.getPeso());
    }

    public int contarHojas() {
        return (this.miArbolRN.contarHojas());
    }

    public String obtenerHojas() {
        Iterator<Integer> it = this.miArbolRN.getHojas();
        String cad = "";
        while(it.hasNext()){
            cad+= it.next().toString();
            if(it.hasNext())
                cad+=", ";
            else
                cad+=".";
        }        
        return (cad);
    }

    public void limpiarArbol() {
        this.miArbolRN.limpiar();
    }

    public String recorridoPreorden() {
        Iterator<Integer> it = this.miArbolRN.preOrden();
        String cad = "";
        int i=0;
        while(it.hasNext()){
            cad+= it.next().toString();
            if(it.hasNext())
                cad+=", ";
            else
                cad+=".";
            if(i==15){
                cad+="\n";
            }
            i++;
        }        
        return (cad);
    }
    
    public String recorridoInorden() {
        Iterator<Integer> it = this.miArbolRN.inOrden();
        String cad = "";
        int i=0;
        while(it.hasNext()){
            cad+= it.next().toString();
            if(it.hasNext())
                cad+=", ";
            else
                cad+=".";
            if(i==15){
                cad+="\n";
            }
            i++;
        }        
        return (cad);
    }
    
    public String recorridoPostorden() {
        Iterator<Integer> it = this.miArbolRN.postOrden();
        String cad = "";
        int i=0;
        while(it.hasNext()){
            cad+= it.next().toString();
            if(it.hasNext())
                cad+=", ";
            else
                cad+=".";
            if(i==15){
                cad+="\n";
            }
            i++;
        }        
        return (cad);
    }
    
    public String recorridoPorNiveles() {
        Iterator<Integer> it = this.miArbolRN.impNiveles();
        String cad = "";
        int i=0;
        while(it.hasNext()){
            cad+= it.next().toString();
            if(it.hasNext())
                cad+=", ";
            else
                cad+=".";
            if(i==15){
                cad+="\n";
            }
            i++;
        }        
        return (cad);
    }
    
}
