/*
 * Decompiled with CFR 0.152.
 */
package Colecciones;

import Colecciones.Cola;
import Colecciones.Componente;
import Colecciones.ListaCD;
import Colecciones.Pagina;
import Colecciones.Pila;
import java.util.Iterator;

public class ArbolB<T> {
    private int n;
    private int m;
    private int m1;
    private Pagina raiz;

    public ArbolB() {
        this.raiz = null;
        this.n = 2;
        this.m = this.n * 2;
        this.m1 = this.m + 1;
    }

    public ArbolB(int n) {
        if (n <= 0) {
            System.err.println("Tamano del orden del arbol no es v\u00e1lido");
            return;
        }
        this.raiz = null;
        this.n = n;
        this.m = n * 2;
        this.m1 = this.m + 1;
    }

    public Pagina getRaiz() {
        return this.raiz;
    }

    protected void setRaiz(Pagina raiz) {
        this.raiz = raiz;
    }

    public int getN() {
        return this.n;
    }

    public int getM() {
        return this.m;
    }

    public int getM1() {
        return this.m1;
    }

    public void setN(int n) {
        this.n = n;
    }

    public boolean insertar(T x) {
        Pila pila = new Pila();
        Object[] subir = new Object[1];
        Object[] subir1 = new Object[1];
        int posicion = 0;
        int i = 0;
        Pagina p = null;
        Pagina nuevo = null;
        if (this.raiz == null) {
            this.raiz = this.crearPagina(x);
        } else {
            posicion = this.buscar(this.raiz, x, pila);
            if (posicion == -1) {
                return false;
            }
            boolean separar = false;
            boolean terminar = false;
            while (!pila.esVacia() && !terminar) {
                p = (Pagina)pila.desapilar();
                if (p.getCont() == this.m) {
                    if (!separar) {
                        nuevo = this.romper(p, null, x, subir);
                        separar = true;
                        continue;
                    }
                    Pagina nuevo1 = this.romper(p, nuevo, subir[0], subir1);
                    subir[0] = subir1[0];
                    nuevo = nuevo1;
                    continue;
                }
                if (separar) {
                    separar = false;
                    i = this.donde(p, subir[0]);
                    i = this.insertar(p, subir[0], i);
                    this.cderechaApunt(p, i + 1);
                    p.getApuntadores()[i + 1] = nuevo;
                } else {
                    posicion = this.insertar(p, x, posicion);
                }
                terminar = true;
            }
            if (separar && !terminar) {
                this.setRaiz(this.crearPagina(subir[0]));
                this.raiz.getApuntadores()[0] = p;
                this.raiz.getApuntadores()[1] = nuevo;
            }
        }
        return true;
    }

    private int insertar(Pagina p, T x, int i) {
        if (p.getCont() != 0) {
            int compara = ((Comparable)p.getInfo()[i]).compareTo(x);
            if (compara < 0) {
                ++i;
            } else {
                for (int j = p.getCont() - 1; j >= i; --j) {
                    p.getInfo()[j + 1] = p.getInfo()[j];
                }
            }
        }
        p.setCont(p.getCont() + 1);
        p.getInfo()[i] = x;
        return i;
    }

    public boolean eliminar(T x) {
        Pagina q = null;
        Pila<Componente> pila = new Pila<Componente>();
        Componente objeto = new Componente();
        int posicion = this.esta(this.raiz, x, pila);
        if (posicion == -1) {
            return false;
        }
        objeto = pila.desapilar();
        Pagina p = objeto.getP();
        int i = objeto.getV();
        if (!this.esHoja(p)) {
            Pagina t = p;
            int k = i;
            pila.apilar(new Componente(p, i + 1));
            p = p.getApuntadores()[i + 1];
            while (p != null) {
                pila.apilar(new Componente(p, 0));
                p = p.getApuntadores()[0];
            }
            objeto = pila.desapilar();
            p = objeto.getP();
            i = objeto.getV();
            t.getInfo()[k] = p.getInfo()[0];
            x = p.getInfo()[0];
            posicion = 0;
        }
        if (p.getCont() > this.n) {
            this.retirar(p, posicion);
        } else if (!pila.esVacia()) {
            objeto = pila.desapilar();
            q = objeto.getP();
            i = objeto.getV();
            if (i < q.getCont()) {
                Pagina r = q.getApuntadores()[i + 1];
                if (r.getCont() > this.n) {
                    this.retirar(p, posicion);
                    this.cambio(p, q, r, i, x);
                } else if (i != 0) {
                    r = q.getApuntadores()[i - 1];
                    if (r.getCont() > this.n) {
                        this.retirar(p, posicion);
                        this.cambio(p, q, r, i - 1, x);
                    } else {
                        this.unir(q, r, p, i - 1, pila, x, posicion);
                    }
                } else {
                    this.unir(q, r, p, i, pila, x, posicion);
                }
            } else {
                Pagina r = q.getApuntadores()[i - 1];
                if (r.getCont() > this.n) {
                    this.retirar(p, posicion);
                    this.cambio(p, q, r, i - 1, x);
                } else {
                    this.unir(q, r, p, i - 1, pila, x, posicion);
                }
            }
        } else {
            this.retirar(p, posicion);
            if (p.getCont() == 0) {
                this.setRaiz(null);
            }
        }
        return true;
    }

    private void retirar(Pagina p, int i) {
        while (i < p.getCont() - 1) {
            p.getInfo()[i] = p.getInfo()[i + 1];
            ++i;
        }
        p.setCont(p.getCont() - 1);
    }

    private Pagina crearPagina(T x) {
        Pagina p = new Pagina(this.n);
        this.inicializar(p);
        p.setCont(1);
        p.getInfo()[0] = x;
        return p;
    }

    private void inicializar(Pagina p) {
        int i = 0;
        p.setCont(0);
        while (i < this.m1) {
            p.getApuntadores()[i++] = null;
        }
    }

    public boolean esta(T dato) {
        Pila<Componente> pi = new Pila<Componente>();
        return this.esta(this.raiz, dato, pi) != -1;
    }

    private int esta(Pagina p, T x, Pila<Componente> pila) {
        int i = 0;
        boolean encontro = false;
        int posicion = -1;
        while (p != null && !encontro) {
            i = 0;
            int compara = ((Comparable)p.getInfo()[i]).compareTo(x);
            while (compara < 0 && i < p.getCont() - 1) {
                compara = ((Comparable)p.getInfo()[++i]).compareTo(x);
            }
            if (compara > 0) {
                pila.apilar(new Componente(p, i));
                p = p.getApuntadores()[i];
                continue;
            }
            if (compara < 0) {
                pila.apilar(new Componente(p, i + 1));
                p = p.getApuntadores()[i + 1];
                continue;
            }
            pila.apilar(new Componente(p, i));
            encontro = true;
        }
        if (encontro) {
            posicion = i;
        }
        return posicion;
    }

    private int buscar(Pagina p, T x, Pila pila) {
        int i = -1;
        boolean encontro = false;
        int posicion = -1;
        while (p != null && !encontro) {
            pila.apilar(p);
            i = 0;
            int compara = ((Comparable)p.getInfo()[i]).compareTo(x);
            while (compara < 0 && i < p.getCont() - 1) {
                compara = ((Comparable)p.getInfo()[++i]).compareTo(x);
            }
            if (compara > 0) {
                p = p.getApuntadores()[i];
                continue;
            }
            if (compara < 0) {
                p = p.getApuntadores()[i + 1];
                continue;
            }
            encontro = true;
        }
        if (!encontro) {
            posicion = i;
        }
        return posicion;
    }

    protected int donde(Pagina p, T x) {
        int i = 0;
        int compara = ((Comparable)p.getInfo()[i]).compareTo(x);
        while (compara < 0 && i < p.getCont() - 1) {
            compara = ((Comparable)p.getInfo()[++i]).compareTo(x);
        }
        return i;
    }

    private Pagina romper(Pagina p, Pagina t, T x, T[] subir) {
        Object[] a = new Object[this.m1];
        int i = 0;
        boolean s = false;
        Pagina[] b = new Pagina[this.m1 + 1];
        while (i < this.m && !s) {
            int compara = ((Comparable)p.getInfo()[i]).compareTo(x);
            if (compara < 0) {
                a[i] = p.getInfo()[i];
                b[i] = p.getApuntadores()[i];
                p.getApuntadores()[i++] = null;
                continue;
            }
            s = true;
        }
        a[i] = x;
        b[i] = p.getApuntadores()[i];
        p.getApuntadores()[i] = null;
        b[++i] = t;
        while (i <= this.m) {
            a[i] = p.getInfo()[i - 1];
            b[i + 1] = p.getApuntadores()[i];
            p.getApuntadores()[i++] = null;
        }
        Pagina q = new Pagina(this.n);
        this.inicializar(q);
        p.setCont(this.n);
        q.setCont(this.n);
        for (i = 0; i < this.n; ++i) {
            p.getInfo()[i] = a[i];
            p.getApuntadores()[i] = b[i];
            q.getInfo()[i] = a[i + this.n + 1];
            q.getApuntadores()[i] = b[i + this.n + 1];
        }
        p.getApuntadores()[this.n] = b[this.n];
        q.getApuntadores()[this.n] = b[this.m1];
        subir[0] = a[this.n];
        return q;
    }

    protected void cizquierda_apunt(Pagina p, int i, int j) {
        while (i < j) {
            p.getApuntadores()[i] = p.getApuntadores()[i + 1];
            ++i;
        }
        p.getApuntadores()[i] = null;
    }

    protected void cderechaApunt(Pagina p, int i) {
        for (int j = p.getCont(); j > i; --j) {
            p.getApuntadores()[j] = p.getApuntadores()[j - 1];
        }
    }

    protected void cambio(Pagina p, Pagina q, Pagina r, int i, T x) {
        int compara = ((Comparable)r.getInfo()[r.getCont() - 1]).compareTo(x);
        if (compara < 0) {
            Object t = q.getInfo()[i];
            this.retirar(q, i);
            int k = 0;
            k = this.insertar(p, t, k);
            t = r.getInfo()[r.getCont() - 1];
            this.retirar(r, r.getCont() - 1);
            k = i;
            if (k == -1) {
                k = 0;
            }
            k = this.insertar(q, t, k);
        } else {
            Object t = q.getInfo()[i];
            this.retirar(q, i);
            int k = p.getCont() - 1;
            if (k == -1) {
                k = 0;
            }
            k = this.insertar(p, t, k);
            t = r.getInfo()[0];
            this.retirar(r, 0);
            k = i;
            if (q.getCont() != 0 && k > q.getCont() - 1) {
                k = q.getCont() - 1;
            }
            k = this.insertar(q, t, k);
        }
    }

    private void unir(Pagina q, Pagina r, Pagina p, int i, Pila<Componente> pila, T x, int posicion) {
        boolean terminar = false;
        int j = 0;
        Pagina t = null;
        Componente objeto = new Componente();
        this.retirar(p, posicion);
        int compara = ((Comparable)r.getInfo()[0]).compareTo(x);
        if (compara > 0) {
            t = p;
            p = r;
            r = t;
        }
        while (!terminar) {
            if (r.getCont() < this.n && p.getCont() > this.n) {
                this.cambio(r, q, p, i, x);
                r.getApuntadores()[r.getCont()] = p.getApuntadores()[0];
                this.cizquierda_apunt(p, 0, p.getCont() + 1);
                terminar = true;
                continue;
            }
            if (p.getCont() < this.n && r.getCont() > this.n) {
                this.cambio(p, q, r, i, x);
                this.cderechaApunt(p, 0);
                p.getApuntadores()[0] = r.getApuntadores()[r.getCont() + 1];
                r.getApuntadores()[r.getCont() + 1] = null;
                terminar = true;
                continue;
            }
            j = r.getCont();
            r.getInfo()[j++] = q.getInfo()[i];
            int k = 0;
            while (k <= p.getCont() - 1) {
                r.getInfo()[j++] = p.getInfo()[k++];
            }
            r.setCont(j);
            this.retirar(q, i);
            k = 0;
            j = this.m - p.getCont();
            while (p.getApuntadores()[k] != null) {
                r.getApuntadores()[j++] = p.getApuntadores()[k++];
            }
            p = null;
            if (q.getCont() == 0) {
                q.getApuntadores()[i + 1] = null;
                if (pila.esVacia()) {
                    q = null;
                }
            } else {
                this.cizquierda_apunt(q, i + 1, q.getCont() + 1);
            }
            if (q != null) {
                if (q.getCont() >= this.n) {
                    terminar = true;
                    continue;
                }
                t = q;
                if (!pila.esVacia()) {
                    objeto = pila.desapilar();
                    q = objeto.getP();
                    i = objeto.getV();
                    compara = ((Comparable)q.getInfo()[0]).compareTo(x);
                    if (compara <= 0) {
                        p = t;
                        r = q.getApuntadores()[i - 1];
                        --i;
                        continue;
                    }
                    r = t;
                    p = q.getApuntadores()[i + 1];
                    continue;
                }
                terminar = true;
                continue;
            }
            terminar = true;
            this.setRaiz(r);
        }
    }

    public Iterator<T> getHojas() {
        ListaCD l = new ListaCD();
        this.getHojas(this.raiz, l);
        return l.iterator();
    }

    private void getHojas(Pagina<T> r, ListaCD<T> l) {
        if (r == null) {
            return;
        }
        if (this.esHoja(r)) {
            for (int j = 0; j < r.getCont(); ++j) {
                l.insertarAlFinal(r.getInfo()[j]);
            }
        }
        for (int i = 0; i < r.getCont() + 1; ++i) {
            this.getHojas(r.getApuntadores()[i], l);
        }
    }

    public int contarHojas() {
        return this.contarHojas(this.raiz);
    }

    private int contarHojas(Pagina<T> r) {
        if (r == null) {
            return 0;
        }
        int cont = 0;
        if (this.esHoja(r)) {
            ++cont;
        }
        for (int i = 0; i < r.getCont() + 1; ++i) {
            cont += this.contarHojas(r.getApuntadores()[i]);
        }
        return cont;
    }

    protected boolean esHoja(Pagina p) {
        int j;
        for (j = 0; p.getApuntadores()[j] == null && j < p.getCont() - 1; ++j) {
        }
        return p.getApuntadores()[j] == null;
    }

    public boolean esVacio() {
        return this.raiz == null;
    }

    public int getPeso() {
        if (this.esVacio()) {
            return 0;
        }
        return this.getPeso(this.getRaiz());
    }

    private int getPeso(Pagina<T> r) {
        if (r == null) {
            return 0;
        }
        int cont = 0;
        cont += r.getCont();
        for (int i = 0; i < r.getCont() + 1; ++i) {
            cont += this.getPeso(r.getApuntadores()[i]);
        }
        return cont;
    }

    public int getAltura() {
        return this.getAltura(this.getRaiz());
    }

    private int getAltura(Pagina<T> r) {
        int alt = 0;
        while (r != null) {
            ++alt;
            r = r.getApuntadores()[0];
        }
        return alt;
    }

    public String imprime() {
        String msg = "";
        return this.imprime(this.raiz, msg);
    }

    private String imprime(Pagina r, String msg) {
        for (int i = 0; i <= r.getCont(); ++i) {
            msg = msg + r.toString() + "  pagina = " + i + "   ES =" + r.getApuntadores()[i].toString() + "\n";
            if (this.esHoja(r.getApuntadores()[i])) continue;
            msg = msg + this.imprime(r.getApuntadores()[i], msg);
        }
        return msg;
    }

    public ArbolB<T> clonar() {
        ArbolB<T> clon = new ArbolB<T>(this.getN());
        if (this.raiz == null) {
            return clon;
        }
        clon.setRaiz(this.clonar(this.raiz));
        return clon;
    }

    private Pagina clonar(Pagina r) {
        if (r == null) {
            return null;
        }
        Object[] info = new Object[r.getM()];
        for (int i = 0; i < r.getCont(); ++i) {
            info[i] = r.getInfo()[i];
        }
        Pagina<Object> aux = new Pagina<Object>(r.getN());
        aux.setInfo(info);
        aux.setCont(r.getCont());
        for (int i = 0; i < aux.getCont() + 1; ++i) {
            aux.getApuntadores()[i] = this.clonar(r.getApuntadores()[i]);
        }
        return aux;
    }

    public Iterator<T> preOrden() {
        ListaCD l = new ListaCD();
        this.preOrden(this.raiz, l);
        return l.iterator();
    }

    private void preOrden(Pagina<T> r, ListaCD<T> l) {
        if (r == null) {
            return;
        }
        for (int j = 0; j < r.getCont(); ++j) {
            l.insertarAlFinal(r.getInfo()[j]);
        }
        for (int i = 0; i < r.getCont() + 1; ++i) {
            this.preOrden(r.getApuntadores()[i], l);
        }
    }

    public Iterator<T> inOrden() {
        ListaCD l = new ListaCD();
        this.inOrden(this.raiz, l);
        return l.iterator();
    }

    private void inOrden(Pagina<T> r, ListaCD<T> l) {
        if (r == null) {
            return;
        }
        this.inOrden(r.getApuntadores()[0], l);
        for (int j = 0; j < r.getCont(); ++j) {
            l.insertarAlFinal(r.getInfo()[j]);
        }
        for (int i = 1; i < r.getCont() + 1; ++i) {
            this.inOrden(r.getApuntadores()[i], l);
        }
    }

    public Iterator<T> postOrden() {
        ListaCD l = new ListaCD();
        this.postOrden(this.raiz, l);
        return l.iterator();
    }

    private void postOrden(Pagina<T> r, ListaCD<T> l) {
        if (r == null) {
            return;
        }
        for (int i = 0; i < r.getCont() + 1; ++i) {
            this.postOrden(r.getApuntadores()[i], l);
        }
        for (int j = 0; j < r.getCont(); ++j) {
            l.insertarAlFinal(r.getInfo()[j]);
        }
    }

    public Iterator<T> impNiveles() {
        ListaCD l = new ListaCD();
        if (!this.esVacio()) {
            Cola<Pagina> c = new Cola<Pagina>();
            c.enColar(this.getRaiz());
            while (!c.esVacia()) {
                Pagina x = (Pagina)c.deColar();
                if (x == null) continue;
                for (int i = 0; i < x.getCont(); ++i) {
                    l.insertarAlFinal(x.getInfo()[i]);
                }
                for (int j = 0; j < x.getCont() + 1; ++j) {
                    c.enColar(x.getApuntadores()[j]);
                }
            }
        }
        return l.iterator();
    }

    public void podar() {
        if (this.esHoja(this.raiz)) {
            this.setRaiz(null);
        }
        this.podar(this.raiz);
    }

    private void podar(Pagina<T> r) {
        if (r == null) {
            return;
        }
        for (int i = 0; i < r.getCont() + 1; ++i) {
            Pagina apunt = r.getApuntadores()[i];
            if (!this.esHoja(apunt)) continue;
            r.getApuntadores()[i] = null;
        }
        for (int j = 0; j < r.getCont() + 1; ++j) {
            if (r.getApuntadores()[j] == null) continue;
            this.podar(r.getApuntadores()[j]);
        }
    }
}

