/*
 * Decompiled with CFR 0.152.
 */
package Colecciones;

import Colecciones.ListaCD;
import java.util.Iterator;

public class ArbolHeap<T> {
    private T[] datos;
    private int peso;
    private static final int def = 200;

    public ArbolHeap() {
        Object[] temp = new Object[200];
        this.datos = temp;
        this.peso = 0;
    }

    public ArbolHeap(int cap) {
        Object[] temp = new Object[cap];
        this.datos = temp;
        this.peso = 0;
    }

    public T getRaiz() {
        T r = null;
        if (!this.esVacio()) {
            r = this.datos[0];
        }
        return r;
    }

    public void insertar(T nuevo) {
        if (this.peso >= this.datos.length) {
            return;
        }
        if (this.esVacio()) {
            this.datos[this.peso++] = nuevo;
            return;
        }
        int indice = this.peso++;
        this.datos[indice] = nuevo;
        while (indice != 0 && ((Comparable)this.datos[indice]).compareTo(this.datos[this.getPosPadre(indice)]) > 0) {
            this.datos = this.intercambiar(this.datos, indice, this.getPosPadre(indice));
            indice = this.getPosPadre(indice);
        }
    }

    public T eliminarRaiz() {
        if (this.peso <= 0) {
            return null;
        }
        this.datos = this.intercambiar(this.datos, 0, --this.peso);
        if (this.peso != 0) {
            this.reorganiza(0);
        }
        T x = this.datos[this.peso];
        this.datos[this.peso] = null;
        return x;
    }

    private void reorganiza(int pos) {
        if (pos < 0 || pos > this.peso) {
            return;
        }
        while (!this.esHoja(pos)) {
            int j = this.getHijoIzq(pos);
            if (j < this.peso - 1 && ((Comparable)this.datos[j]).compareTo(this.datos[j + 1]) < 0) {
                ++j;
            }
            if (((Comparable)this.datos[pos]).compareTo(this.datos[j]) >= 0) {
                return;
            }
            this.datos = this.intercambiar(this.datos, pos, j);
            pos = j;
        }
    }

    private boolean esHoja(int pos) {
        return pos >= this.peso / 2 && pos < this.peso;
    }

    public T eliminar(T info) {
        int pos = this.getPos(info);
        if (pos == -1) {
            return null;
        }
        if (pos == this.peso - 1) {
            T x = this.datos[this.peso - 1];
            --this.peso;
            this.datos[this.peso] = null;
            return x;
        }
        this.datos = this.intercambiar(this.datos, pos, --this.peso);
        while (pos > 0 && ((Comparable)this.datos[pos]).compareTo(this.datos[this.getPosPadre(pos)]) > 0) {
            this.datos = this.intercambiar(this.datos, pos, this.getPosPadre(pos));
            pos = this.getPosPadre(pos);
        }
        if (this.peso != 0) {
            this.reorganiza(pos);
        }
        T x = this.datos[this.peso];
        this.datos[this.peso] = null;
        return x;
    }

    private T[] intercambiar(T[] h, int p1, int p2) {
        T temp = h[p1];
        h[p1] = h[p2];
        h[p2] = temp;
        return h;
    }

    public T[] getDatos() {
        return this.datos;
    }

    public boolean esta(T info) {
        for (int i = 0; i < this.peso; ++i) {
            if (!this.datos[i].equals(info)) continue;
            return true;
        }
        return false;
    }

    public Iterator<T> impNiveles() {
        ListaCD<T> l = new ListaCD<T>();
        for (int i = 0; i < this.peso; ++i) {
            l.insertarAlFinal(this.datos[i]);
        }
        return l.iterator();
    }

    public int getPeso() {
        return this.peso;
    }

    public boolean esVacio() {
        return this.peso < 1;
    }

    public int getAltura() {
        int alt = 0;
        while (Math.pow(2.0, alt) <= (double)this.peso) {
            ++alt;
        }
        return alt;
    }

    public T[] heapSort() {
        Object[] aux = new Object[this.datos.length];
        for (int i = this.peso - 1; i >= 0; --i) {
            aux[i] = this.eliminarRaiz();
        }
        return aux;
    }

    public void limpiar() {
        while (this.peso >= 0) {
            this.datos[this.peso] = null;
            --this.peso;
        }
        this.peso = 0;
    }

    private int getPosPadre(int hijo) {
        if (hijo <= 0) {
            return -1;
        }
        return (hijo - 1) / 2;
    }

    private int getHijoIzq(int posPadre) {
        return 2 * posPadre + 1;
    }

    private int getHijoDer(int posPadre) {
        return 2 * posPadre + 2;
    }

    private int getPos(T info) {
        for (int i = 0; i < this.peso; ++i) {
            if (!this.datos[i].equals(info)) continue;
            return i;
        }
        return -1;
    }

    public int contarHojas() {
        int cant = 0;
        for (int i = 0; i < this.peso; ++i) {
            if (!this.esHoja(i)) continue;
            ++cant;
        }
        return cant;
    }

    public Iterator getHojas() {
        ListaCD<T> l = new ListaCD<T>();
        for (int i = 0; i < this.peso; ++i) {
            if (!this.esHoja(i)) continue;
            l.insertarAlFinal(this.datos[i]);
        }
        return l.iterator();
    }

    public void podar() {
        int cant = 0;
        for (int i = 0; i < this.peso; ++i) {
            if (!this.esHoja(i)) continue;
            this.datos[i] = null;
            ++cant;
        }
        this.peso -= cant;
    }

    public Iterator<T> preOrden() {
        ListaCD l = new ListaCD();
        this.preOrden(0, l);
        return l.iterator();
    }

    private void preOrden(int pos, ListaCD<T> l) {
        T r = this.datos[pos];
        if (r != null) {
            l.insertarAlFinal(r);
            this.preOrden(this.getHijoIzq(pos), l);
            this.preOrden(this.getHijoDer(pos), l);
        }
    }

    public Iterator<T> inOrden() {
        ListaCD l = new ListaCD();
        this.inOrden(0, l);
        return l.iterator();
    }

    private void inOrden(int pos, ListaCD<T> l) {
        T r = this.datos[pos];
        if (r != null) {
            this.inOrden(this.getHijoIzq(pos), l);
            l.insertarAlFinal(r);
            this.inOrden(this.getHijoDer(pos), l);
        }
    }

    public Iterator<T> postOrden() {
        ListaCD l = new ListaCD();
        this.postOrden(0, l);
        return l.iterator();
    }

    private void postOrden(int pos, ListaCD<T> l) {
        T r = this.datos[pos];
        if (r != null) {
            this.postOrden(this.getHijoIzq(pos), l);
            this.postOrden(this.getHijoDer(pos), l);
            l.insertarAlFinal(r);
        }
    }

    public String toString() {
        String cad = "";
        for (int i = 0; i < this.peso; ++i) {
            cad = cad + this.datos[i].toString() + "-";
        }
        return cad;
    }
}

