/*
 * Decompiled with CFR 0.152.
 */
package Colecciones;

import Colecciones.Arista;
import Colecciones.Cola;
import Colecciones.ListaCD;
import Colecciones.Vertice;
import java.util.Iterator;

public class GrafoND<T> {
    private ListaCD<Vertice> vertices = new ListaCD();
    private ListaCD<Arista> aristas = new ListaCD();

    public ListaCD<Vertice> getVertices() {
        return this.vertices;
    }

    public ListaCD<Arista> getAristas() {
        return this.aristas;
    }

    public void setVertices(ListaCD<Vertice> l) {
        this.vertices = l;
    }

    public void setAristas(ListaCD<Arista> l) {
        this.aristas = l;
    }

    public boolean insertarVertice(T info) {
        Vertice<T> v = new Vertice<T>(info);
        if (this.esta(v.getInfo())) {
            return false;
        }
        this.vertices.insertarAlFinal(v);
        return true;
    }

    public boolean insertarArista(T info1, T info2) {
        Vertice<T> a = this.buscarVertice(info1);
        Vertice<T> b = this.buscarVertice(info2);
        if (a == null || b == null) {
            return false;
        }
        a.insertarVecino(b);
        if (!a.equals(b)) {
            b.insertarVecino(a);
        }
        this.aristas.insertarAlFinal(new Arista<T>(a, b, -1));
        return true;
    }

    public boolean insertarAristaP(T info1, T info2, int peso) {
        Vertice<T> a = this.buscarVertice(info1);
        Vertice<T> b = this.buscarVertice(info2);
        if (a == null || b == null || peso < 0) {
            return false;
        }
        a.insertarVecino(b);
        if (!a.equals(b)) {
            b.insertarVecino(a);
        }
        this.aristas.insertarAlFinal(new Arista<T>(a, b, peso));
        return true;
    }

    public boolean eliminarVertice(T info) {
        ListaCD<Vertice> vaux = new ListaCD<Vertice>();
        ListaCD<Arista> aaux = new ListaCD<Arista>();
        Vertice<T> v = this.buscarVertice(info);
        if (v == null) {
            return false;
        }
        for (Arista a : this.aristas) {
            if (a.getVertA().equals(v) || a.getVertB().equals(v)) continue;
            aaux.insertarAlFinal(a);
        }
        this.aristas = aaux;
        for (Vertice vert : this.vertices) {
            if (!vert.equals(v)) {
                vaux.insertarAlFinal(vert);
                continue;
            }
            vert.eliminarVecino(v);
        }
        this.vertices = vaux;
        return true;
    }

    public boolean eliminarArista(T orig, T dest) {
        ListaCD<Arista> aaux = new ListaCD<Arista>();
        Vertice<T> v1 = this.buscarVertice(orig);
        Vertice<T> v2 = this.buscarVertice(dest);
        if (v1 == null || v2 == null) {
            return false;
        }
        for (Arista a : this.aristas) {
            boolean es;
            Vertice vOrig = a.getVertA();
            Vertice vDest = a.getVertB();
            boolean bl = es = vOrig.equals(v1) && vDest.equals(v2) || vOrig.equals(v2) && vDest.equals(v1);
            if (!es) {
                aaux.insertarAlFinal(a);
                continue;
            }
            v1.eliminarVecino(v2);
            v2.eliminarVecino(v1);
        }
        this.aristas = aaux;
        return true;
    }

    public Vertice<T> buscarVertice(T info) {
        for (Vertice v : this.vertices) {
            if (!v.getInfo().equals(info)) continue;
            return v;
        }
        return null;
    }

    public Arista<T> buscarArista(T info1, T info2) {
        for (Arista a : this.aristas) {
            if (!a.equalsND(new Arista<T>(new Vertice<T>(info1), new Vertice<T>(info2), -1))) continue;
            return a;
        }
        return null;
    }

    public boolean esta(T x) {
        for (Vertice v : this.vertices) {
            if (!v.getInfo().equals(x)) continue;
            return true;
        }
        return false;
    }

    public Object[][] getMatrizAdyacencia() {
        Object[][] m = new Object[this.vertices.getTamanio() + 1][this.vertices.getTamanio() + 1];
        int k = 1;
        for (Vertice v : this.vertices) {
            m[0][k] = v.getInfo().toString();
            m[k++][0] = v.getInfo().toString();
        }
        for (int i = 1; i < m[0].length; ++i) {
            for (int j = 1; j < m.length; ++j) {
                m[i][j] = 0;
            }
        }
        m[0][0] = 0;
        for (Arista a : this.aristas) {
            int i = this.vertices.getIndice(a.getVertA()) + 1;
            int j = this.vertices.getIndice(a.getVertB()) + 1;
            m[i][j] = (Integer)m[i][j] + 1;
            m[j][i] = (Integer)m[j][i] + 1;
        }
        return m;
    }

    public ListaCD[] getListaAdyacencia() {
        ListaCD[] lad = new ListaCD[this.vertices.getTamanio()];
        int i = 0;
        while (i < this.vertices.getTamanio()) {
            Vertice v = this.vertices.get(i);
            int j = 0;
            ListaCD<Vertice> l = new ListaCD<Vertice>();
            l.insertarAlFinal(v);
            while (j < v.getVecinos().getTamanio()) {
                l.insertarAlFinal(v.getVecinos().get(j++));
            }
            lad[i++] = l;
        }
        return lad;
    }

    public Object[][] getMatrizIncidencia() {
        Object[][] m = new Object[this.vertices.getTamanio() + 1][this.aristas.getTamanio() + 1];
        int k = 1;
        for (Vertice v : this.vertices) {
            m[k++][0] = v.getInfo().toString();
        }
        k = 1;
        for (Arista a : this.aristas) {
            m[0][k] = "e" + k;
            ++k;
        }
        for (int i = 1; i < m.length; ++i) {
            for (int j = 1; j < m[0].length; ++j) {
                m[i][j] = 0;
            }
        }
        m[0][0] = 0;
        k = 1;
        for (Arista a : this.aristas) {
            int j;
            int i = this.vertices.getIndice(a.getVertA()) + 1;
            if (i == (j = this.vertices.getIndice(a.getVertB()) + 1)) {
                m[i][k++] = 2;
                continue;
            }
            m[i][k] = 1;
            m[j][k++] = 1;
        }
        return m;
    }

    public boolean esMultigrafo() {
        Object[][] m = this.getMatrizAdyacencia();
        for (int i = 1; i < m[0].length; ++i) {
            for (int j = 1; j < m.length; ++j) {
                if (i == j || (Integer)m[i][j] <= 1) continue;
                return true;
            }
        }
        return false;
    }

    public boolean esPseudoGrafo() {
        Object[][] m = this.getMatrizAdyacencia();
        int i = 0;
        while (i < m.length) {
            if ((Integer)m[i][i++] == 0) continue;
            return true;
        }
        return false;
    }

    public boolean esGrafoSimple() {
        return !this.esMultigrafo() && !this.esPseudoGrafo();
    }

    public boolean esGrafoPonderado() {
        for (Arista a : this.aristas) {
            if (a.getPeso() != -1) continue;
            return false;
        }
        return true;
    }

    public int esGrafoNulo() {
        if (!this.aristas.esVacia()) {
            return -1;
        }
        return this.vertices.getTamanio();
    }

    public boolean esConexo() {
        this.limpiaVisitasV();
        Vertice v = this.vertices.get(0);
        v.setVisit(true);
        this.visitarVecinos(v);
        boolean x = this.visitadosTodos();
        this.limpiaVisitasV();
        return x;
    }

    private void visitarVecinos(Vertice v) {
        ListaCD<Vertice> l = v.getVecinos();
        Iterator<Vertice> i$ = l.iterator();
        while (i$.hasNext()) {
            Vertice obj;
            Vertice v2 = obj = i$.next();
            if ((v2 = this.buscarVertice(v2.getInfo())) == null || v2.getVisit()) continue;
            v2.setVisit(true);
            if (this.visitadosTodos()) {
                return;
            }
            this.visitarVecinos(v2);
        }
    }

    private boolean visitadosTodos() {
        for (Vertice v : this.vertices) {
            if (v.getVisit()) continue;
            return false;
        }
        return true;
    }

    private void limpiaVisitasV() {
        for (Vertice v : this.vertices) {
            v.setVisit(false);
        }
    }

    private void limpiaVisitasA() {
        for (Arista a : this.aristas) {
            a.setVisit(false);
        }
    }

    public boolean esFuertementeConexo() {
        for (Vertice v1 : this.vertices) {
            for (Vertice v2 : this.vertices) {
                if (v1.equals(v2) || this.existeRutaEntre(v1.getInfo(), v2.getInfo())) continue;
                return false;
            }
        }
        return true;
    }

    public boolean esGrafoRegular() {
        if (this.esMultigrafo() || this.esPseudoGrafo()) {
            return false;
        }
        int grado = -2;
        for (Vertice v : this.vertices) {
            if (grado == -2) {
                grado = this.getGradoVertice(v.getInfo());
            }
            if (grado == this.getGradoVertice(v.getInfo())) continue;
            return false;
        }
        return true;
    }

    public int esCompleto() {
        Object[][] m = this.getMatrizAdyacencia();
        for (int i = 1; i < m[0].length; ++i) {
            for (int j = 1; j < m.length; ++j) {
                if ((i != j || (Integer)m[i][j] == 0) && (i == j || (Integer)m[i][j] == 1)) continue;
                return -1;
            }
        }
        return this.vertices.getTamanio();
    }

    public int esGrafoCiclo() {
        int c = this.vertices.getTamanio();
        if (c < 3 || c != this.aristas.getTamanio()) {
            return -1;
        }
        Object[][] m = this.getMatrizAdyacencia();
        for (int i = 1; i < m[0].length; ++i) {
            int n = 0;
            for (int j = 1; j < m.length; ++j) {
                if (i == j && (Integer)m[i][j] != 0 || i != j && (Integer)m[i][j] > 1) {
                    return -1;
                }
                if (i == j || (Integer)m[i][j] != 1 || ++n <= 2) continue;
                return -1;
            }
            if (n == 2) continue;
            return -1;
        }
        return c;
    }

    public int esGrafoRueda() {
        int w = this.vertices.getTamanio();
        if (w < 4) {
            return -1;
        }
        Object[][] m = this.getMatrizAdyacencia();
        boolean cent = false;
        for (int i = 1; i < m[0].length; ++i) {
            int n = 0;
            for (int j = 1; j < m.length; ++j) {
                if (i == j && (Integer)m[i][j] != 0 || i != j && (Integer)m[i][j] > 1) {
                    return -1;
                }
                if (i == j || (Integer)m[i][j] != 1) continue;
                ++n;
            }
            if (n == 3) continue;
            if (n == w - 1 && !cent) {
                cent = true;
                continue;
            }
            return -1;
        }
        return w - 1;
    }

    public String esBipartito() {
        if (!this.esConexo()) {
            return "El Grafo es no conexo. No es Bipartito!";
        }
        if (this.esPseudoGrafo() || this.esMultigrafo()) {
            return "El grafo no es simple!";
        }
        ListaCD<Vertice> conj1 = new ListaCD<Vertice>();
        ListaCD<Vertice> conj2 = new ListaCD<Vertice>();
        int c = 0;
        for (Vertice v : this.vertices) {
            if (!conj1.esta(v) && !conj2.esta(v)) {
                conj1.insertarAlFinal(v);
                c = 1;
            } else {
                if (conj1.esta(v)) {
                    c = 1;
                }
                if (conj2.esta(v)) {
                    c = 2;
                }
            }
            this.asignarVecinos(v, conj1, conj2, c);
        }
        if (!this.evaluarAristas(conj1, conj2)) {
            return "El Grafo No es Bipartito";
        }
        int m = conj1.getTamanio();
        int n = conj2.getTamanio();
        if (n < m) {
            int x = m;
            m = n;
            n = x;
        }
        if (m * n == this.aristas.getTamanio()) {
            return "El Grafo es Bipartito Completo: K[" + m + "," + n + "]";
        }
        return "El Grafo es Bipartito pero no es Completo!";
    }

    private void asignarVecinos(Vertice v, ListaCD<Vertice> conj1, ListaCD<Vertice> conj2, int c) {
        for (Vertice obj : v.getVecinos()) {
            int c2;
            Vertice vec = obj;
            if (conj1.esta(vec) || conj2.esta(vec)) continue;
            if (c == 1) {
                conj2.insertarAlFinal(vec);
                c2 = 2;
                this.asignarVecinos(vec, conj1, conj2, c2);
                continue;
            }
            if (c != 2) continue;
            conj1.insertarAlFinal(vec);
            c2 = 1;
            this.asignarVecinos(vec, conj1, conj2, c2);
        }
    }

    private boolean evaluarAristas(ListaCD<Vertice> conj1, ListaCD<Vertice> conj2) {
        for (Arista a : this.aristas) {
            Vertice va = this.buscarVertice(a.getVertA().getInfo());
            Vertice vb = this.buscarVertice(a.getVertB().getInfo());
            if ((!conj1.esta(va) || !conj1.esta(vb)) && (!conj2.esta(va) || !conj2.esta(vb))) continue;
            return false;
        }
        return true;
    }

    public boolean esGrafoHamiltoniano() {
        if (this.vertices.getTamanio() < 3) {
            return false;
        }
        return !this.getCicloHamiltoniano().esVacia();
    }

    public ListaCD<Vertice> getCicloHamiltoniano() {
        ListaCD<Vertice> l = new ListaCD<Vertice>();
        Vertice v = this.vertices.get(0);
        this.limpiaVisitasV();
        l.insertarAlInicio(v);
        if (!this.getCHamiltoniano(v, l, v)) {
            l.eliminar(l.getTamanio() - 1);
        } else {
            l.insertarAlFinal(v);
        }
        this.limpiaVisitasV();
        return l;
    }

    private boolean getCHamiltoniano(Vertice v2, ListaCD<Vertice> l, Vertice orig) {
        if (l.getTamanio() == this.vertices.getTamanio() && v2.esAdyacente(orig)) {
            return true;
        }
        Vertice v = this.buscarVertice(v2.getInfo());
        if (v == null) {
            return false;
        }
        v.setVisit(true);
        for (Vertice v3 : v.getVecinos()) {
            Vertice vert = v3;
            if (vert.getVisit()) continue;
            l.insertarAlFinal(vert);
            if (this.getCHamiltoniano(vert, l, orig)) {
                return true;
            }
            l.eliminar(l.getTamanio() - 1);
        }
        v.setVisit(false);
        return false;
    }

    public boolean hayCaminoHamiltoniano() {
        return !this.getCaminoHamiltoniano().esVacia();
    }

    public ListaCD<Vertice> getCaminoHamiltoniano() {
        ListaCD<Vertice> l = new ListaCD<Vertice>();
        this.limpiaVisitasV();
        for (Vertice v : this.vertices) {
            l.insertarAlFinal(v);
            if (this.getCamHamiltoniano(v, l)) {
                return l;
            }
            l.vaciar();
            this.limpiaVisitasV();
        }
        this.limpiaVisitasV();
        return l;
    }

    private boolean getCamHamiltoniano(Vertice v2, ListaCD<Vertice> l) {
        if (l.getTamanio() == this.vertices.getTamanio()) {
            return true;
        }
        Vertice v = this.buscarVertice(v2.getInfo());
        if (v == null) {
            return false;
        }
        v.setVisit(true);
        for (Vertice v3 : v.getVecinos()) {
            Vertice vert = v3;
            if (vert.getVisit()) continue;
            l.insertarAlFinal(vert);
            if (this.getCamHamiltoniano(vert, l)) {
                return true;
            }
            l.eliminar(l.getTamanio() - 1);
        }
        v.setVisit(false);
        return false;
    }

    public boolean esGrafoEuleriano() {
        for (Vertice v : this.vertices) {
            int grado = this.getGradoVertice(v.getInfo());
            if (grado % 2 == 0) continue;
            return false;
        }
        boolean rta = this.getCicloEuleriano().esVacia();
        return !rta;
    }

    public ListaCD<Vertice> getCicloEuleriano() {
        ListaCD<Vertice> l = new ListaCD<Vertice>();
        for (Vertice v : this.vertices) {
            this.limpiaVisitasA();
            l.insertarAlFinal(v);
            if (this.getCEuleriano(v, l)) {
                return l;
            }
            l.vaciar();
        }
        this.limpiaVisitasA();
        return l;
    }

    private boolean getCEuleriano(Vertice v2, ListaCD<Vertice> l) {
        Vertice orig = l.get(0);
        Vertice v = this.buscarVertice(v2.getInfo());
        Arista ari = this.buscarArista(v.getInfo(), orig.getInfo());
        if (v == null) {
            return false;
        }
        if (l.getTamanio() == this.aristas.getTamanio() && v2.esAdyacente(orig) && ari != null && !ari.getVisit()) {
            l.insertarAlFinal(orig);
            return true;
        }
        Iterator<Vertice> i$ = v.getVecinos().iterator();
        while (i$.hasNext()) {
            Vertice v3;
            Vertice vert = v3 = i$.next();
            Arista a = this.buscarArista(v.getInfo(), vert.getInfo());
            if (a.getVisit()) continue;
            a.setVisit(true);
            l.insertarAlFinal(vert);
            if (this.getCEuleriano(vert, l)) {
                return true;
            }
            a.setVisit(false);
            l.eliminar(l.getTamanio() - 1);
        }
        return false;
    }

    public boolean hayCaminoEuleriano() {
        int impares = 0;
        this.limpiaVisitasA();
        for (Vertice v : this.vertices) {
            int grado = this.getGradoEntradaVert(v.getInfo()) + this.getGradoSalidaVert(v.getInfo());
            if (grado % 2 != 0) {
                ++impares;
            }
            if (impares <= 2) continue;
            return false;
        }
        if (impares != 2 && impares != 0) {
            return false;
        }
        boolean x = this.getCaminoEuleriano().esVacia();
        this.limpiaVisitasA();
        return !x;
    }

    public ListaCD<Vertice> getCaminoEuleriano() {
        ListaCD<Vertice> l = new ListaCD<Vertice>();
        this.limpiaVisitasA();
        for (Vertice v : this.vertices) {
            this.limpiaVisitasA();
            l.insertarAlFinal(v);
            if (this.getCamEuleriano(v, l)) {
                return l;
            }
            l.vaciar();
        }
        this.limpiaVisitasA();
        return l;
    }

    private boolean getCamEuleriano(Vertice v2, ListaCD<Vertice> l) {
        Vertice v = this.buscarVertice(v2.getInfo());
        if (v == null) {
            return false;
        }
        if (l.getTamanio() - 1 == this.aristas.getTamanio()) {
            return true;
        }
        Iterator<Vertice> i$ = v.getVecinos().iterator();
        while (i$.hasNext()) {
            Vertice v3;
            Vertice vert = v3 = i$.next();
            Arista a = this.buscarArista(v.getInfo(), vert.getInfo());
            if (a.getVisit()) continue;
            a.setVisit(true);
            l.insertarAlFinal(vert);
            if (this.getCamEuleriano(vert, l)) {
                return true;
            }
            a.setVisit(false);
            l.eliminar(l.getTamanio() - 1);
        }
        return false;
    }

    public boolean existeRutaEntre(T orig, T dest) {
        this.limpiaVisitasV();
        Vertice<T> v1 = this.buscarVertice(orig);
        Vertice<T> v2 = this.buscarVertice(dest);
        if (v1 == null || v2 == null) {
            return false;
        }
        boolean rta = this.existeRuta(v1, v2);
        this.limpiaVisitasV();
        return rta;
    }

    private boolean existeRuta(Vertice orig, Vertice dest) {
        if (orig.esAdyacente(dest)) {
            return true;
        }
        Vertice v = this.buscarVertice(orig.getInfo());
        if (v == null) {
            return false;
        }
        v.setVisit(true);
        for (Vertice v3 : v.getVecinos()) {
            Vertice vert = v3;
            if (vert.getVisit() || !this.existeRuta(vert, dest)) continue;
            return true;
        }
        v.setVisit(false);
        return false;
    }

    public ListaCD<Vertice> getRutaEntre(T orig, T dest) {
        ListaCD<Vertice> l = new ListaCD<Vertice>();
        this.limpiaVisitasV();
        Vertice<T> v1 = this.buscarVertice(orig);
        Vertice<T> v2 = this.buscarVertice(dest);
        if (v1 == null || v2 == null) {
            return l;
        }
        l.insertarAlInicio(v1);
        if (!this.getRuta(v1, v2, l)) {
            l.eliminar(l.getTamanio() - 1);
        } else {
            l.insertarAlFinal(v2);
        }
        this.limpiaVisitasV();
        return l;
    }

    public boolean getRuta(Vertice orig, Vertice dest, ListaCD<Vertice> l) {
        if (orig.esAdyacente(dest)) {
            return true;
        }
        Vertice v = this.buscarVertice(orig.getInfo());
        if (v == null) {
            return false;
        }
        v.setVisit(true);
        for (Vertice v3 : v.getVecinos()) {
            Vertice vert = v3;
            if (vert.getVisit()) continue;
            l.insertarAlFinal(vert);
            if (this.getRuta(vert, dest, l)) {
                return true;
            }
            l.eliminar(l.getTamanio() - 1);
        }
        v.setVisit(false);
        return false;
    }

    public int getLongitudDeCamino(T orig, T dest) {
        int[] longi = new int[]{0};
        this.limpiaVisitasV();
        Vertice<T> v1 = this.buscarVertice(orig);
        Vertice<T> v2 = this.buscarVertice(dest);
        if (v1 == null || v2 == null) {
            return -1;
        }
        if (!this.longitudDeCam(v1, v2, longi)) {
            return -1;
        }
        this.limpiaVisitasV();
        return longi[0];
    }

    public boolean longitudDeCam(Vertice orig, Vertice dest, int[] longi) {
        if (orig.esAdyacente(dest)) {
            longi[0] = longi[0] + 1;
            return true;
        }
        Vertice v = this.buscarVertice(orig.getInfo());
        if (v == null) {
            return false;
        }
        v.setVisit(true);
        for (Vertice v3 : v.getVecinos()) {
            Vertice vert = v3;
            if (vert.getVisit()) continue;
            longi[0] = longi[0] + 1;
            if (this.longitudDeCam(vert, dest, longi)) {
                return true;
            }
            longi[0] = longi[0] - 1;
        }
        v.setVisit(false);
        return false;
    }

    public int getLongitudPonderadaDeCamino(T orig, T dest) {
        if (!this.esGrafoPonderado()) {
            return -1;
        }
        int[] longi = new int[]{0};
        this.limpiaVisitasV();
        Vertice<T> v1 = this.buscarVertice(orig);
        Vertice<T> v2 = this.buscarVertice(dest);
        if (v1 == null || v2 == null) {
            return -1;
        }
        if (!this.longitudPondeDeCam(v1, v2, longi)) {
            return -1;
        }
        this.limpiaVisitasV();
        return longi[0];
    }

    public boolean longitudPondeDeCam(Vertice orig, Vertice dest, int[] longi) {
        if (orig.esAdyacente(dest)) {
            longi[0] = Integer.valueOf(longi[0]) + Integer.valueOf(this.buscarArista(orig.getInfo(), dest.getInfo()).getPeso());
            return true;
        }
        Vertice v = this.buscarVertice(orig.getInfo());
        if (v == null) {
            return false;
        }
        v.setVisit(true);
        for (Vertice v3 : v.getVecinos()) {
            Vertice vert = v3;
            if (vert.getVisit()) continue;
            longi[0] = Integer.valueOf(longi[0]) + Integer.valueOf(this.buscarArista(v.getInfo(), vert.getInfo()).getPeso());
            if (this.longitudPondeDeCam(vert, dest, longi)) {
                return true;
            }
            longi[0] = longi[0] - Integer.valueOf(this.buscarArista(v.getInfo(), vert.getInfo()).getPeso());
        }
        v.setVisit(false);
        return false;
    }

    public int longRutaMinimaDijkstra(T ini, T fin) {
        if (this.hayPesosNegativosONullos()) {
            return -1;
        }
        this.limpiaVisitasV();
        int[] costos = new int[this.vertices.getTamanio()];
        Vertice<T> vIni = this.buscarVertice(ini);
        Vertice<T> vFin = this.buscarVertice(fin);
        if (vIni == null || vFin == null) {
            return -1;
        }
        vIni.setVisit(true);
        this.dijkstra(vIni, vFin, costos);
        this.limpiaVisitasV();
        return costos[this.vertices.getIndice(vFin)];
    }

    private void dijkstra(Vertice vIni, Vertice vFin, int[] costos) {
        if (vIni.equals(vFin)) {
            return;
        }
        Iterator<Vertice> i$ = vIni.getVecinos().iterator();
        while (i$.hasNext()) {
            Vertice v;
            Vertice vert = v = i$.next();
            Vertice orig = this.buscarVertice(vert.getInfo());
            int p = costos[this.vertices.getIndice(vIni)];
            int c = costos[this.vertices.getIndice(orig)];
            int pesoAri = this.buscarArista(vIni.getInfo(), orig.getInfo()).getPeso();
            if (orig.getVisit()) continue;
            orig.setVisit(true);
            if (c == 0 || c > p + pesoAri) {
                costos[this.vertices.getIndice(orig)] = p + pesoAri;
            }
            this.dijkstra(orig, vFin, costos);
            orig.setVisit(false);
        }
    }

    public ListaCD<Vertice> rutaMinimaDijkstra(T ini, T fin) {
        ListaCD<Vertice> l = new ListaCD<Vertice>();
        if (this.hayPesosNegativosONullos()) {
            return l;
        }
        this.limpiaVisitasV();
        int[] costos = new int[this.vertices.getTamanio()];
        Vertice<T> vIni = this.buscarVertice(ini);
        Vertice vFin = this.buscarVertice(fin);
        if (vIni == null || vFin == null) {
            return l;
        }
        vIni.setVisit(true);
        this.dijkstra(vIni, vFin, costos, l);
        for (vFin = this.buscarVertice(fin); vFin != null; vFin = vFin.getPredecesor()) {
            l.insertarAlInicio(vFin);
        }
        this.limpiarPredecesores();
        this.limpiaVisitasV();
        return l;
    }

    private void dijkstra(Vertice vIni, Vertice vFin, int[] costos, ListaCD<Vertice> l) {
        if (vIni.equals(vFin)) {
            return;
        }
        Iterator<Vertice> i$ = vIni.getVecinos().iterator();
        while (i$.hasNext()) {
            Vertice v;
            Vertice vert = v = i$.next();
            Vertice orig = this.buscarVertice(vert.getInfo());
            int p = costos[this.vertices.getIndice(vIni)];
            int c = costos[this.vertices.getIndice(orig)];
            int pesoAri = this.buscarArista(vIni.getInfo(), orig.getInfo()).getPeso();
            if (orig.getVisit()) continue;
            orig.setVisit(true);
            if (c == 0 || c > p + pesoAri) {
                costos[this.vertices.getIndice(orig)] = p + pesoAri;
                orig.setPredecesor(vIni);
            }
            this.dijkstra(orig, vFin, costos, l);
            orig.setVisit(false);
        }
    }

    private boolean hayPesosNegativosONullos() {
        for (Arista a : this.aristas) {
            if (a.getPeso() != -1 && (a.getPeso() == -1 || Integer.valueOf(a.getPeso()) >= 0)) continue;
            return true;
        }
        return false;
    }

    public int rutaMasCorta(T ini, T fin) {
        this.limpiaVisitasV();
        int[] cant = new int[this.vertices.getTamanio()];
        Vertice<T> vIni = this.buscarVertice(ini);
        Vertice<T> vFin = this.buscarVertice(fin);
        if (vIni == null || vFin == null) {
            return -1;
        }
        vIni.setVisit(true);
        int tam = 1;
        this.rutaMasCorta(vIni, vFin, cant, tam);
        this.limpiaVisitasV();
        return cant[this.vertices.getIndice(vFin)];
    }

    private void rutaMasCorta(Vertice vIni, Vertice vFin, int[] cant, int tam) {
        ++tam;
        if (vIni.equals(vFin)) {
            return;
        }
        Iterator<Vertice> i$ = vIni.getVecinos().iterator();
        while (i$.hasNext()) {
            Vertice v;
            Vertice vert = v = i$.next();
            Vertice orig = this.buscarVertice(vert.getInfo());
            int c = cant[this.vertices.getIndice(orig)];
            if (orig.getVisit()) continue;
            orig.setVisit(true);
            if (c == 0) {
                cant[this.vertices.getIndice(orig)] = tam;
            } else if (c == 0 || c > tam) {
                cant[this.vertices.getIndice(orig)] = tam;
            }
            this.rutaMasCorta(orig, vFin, cant, tam);
            orig.setVisit(false);
        }
    }

    public ListaCD<Vertice> getBEP(T infoVert) {
        ListaCD<Vertice> l = new ListaCD<Vertice>();
        Vertice<T> v = this.buscarVertice(infoVert);
        if (v == null) {
            return l;
        }
        this.limpiaVisitasV();
        l.insertarAlFinal(v);
        v.setVisit(true);
        this.getBEP(v, l);
        this.limpiaVisitasV();
        return l;
    }

    public void getBEP(Vertice v, ListaCD<Vertice> l) {
        for (Vertice v2 : v.getVecinos()) {
            Vertice vert = v2;
            if (vert.getVisit()) continue;
            l.insertarAlFinal(vert);
            vert.setVisit(true);
            this.getBEP(vert, l);
        }
    }

    public ListaCD<Vertice> getBEA(T infoVert) {
        ListaCD<Vertice> l = new ListaCD<Vertice>();
        Cola<Vertice> c = new Cola<Vertice>();
        Vertice<T> v = this.buscarVertice(infoVert);
        if (v == null) {
            return l;
        }
        this.limpiaVisitasV();
        l.insertarAlFinal(v);
        v.setVisit(true);
        this.getBEA(v, l, c);
        this.limpiaVisitasV();
        return l;
    }

    public void getBEA(Vertice v, ListaCD<Vertice> l, Cola<Vertice> c) {
        if (v == null) {
            return;
        }
        for (Vertice v2 : v.getVecinos()) {
            Vertice vert = v2;
            if (vert.getVisit()) continue;
            l.insertarAlFinal(vert);
            c.enColar(vert);
            vert.setVisit(true);
        }
        this.getBEA(c.deColar(), l, c);
    }

    public boolean esVacio() {
        return this.vertices.esVacia();
    }

    public boolean sonVerticesAdyacentes(T orig, T dest) {
        Vertice<T> a = this.buscarVertice(orig);
        Vertice<T> b = this.buscarVertice(dest);
        if (a == null || b == null) {
            return false;
        }
        return a.esAdyacente(b) || b.esAdyacente(a);
    }

    public int getGradoSalidaVert(T info) {
        Vertice<T> v = this.buscarVertice(info);
        if (v == null) {
            return -1;
        }
        Object[][] m = this.getMatrizAdyacencia();
        int pos = this.vertices.getIndice(v) + 1;
        int i = 1;
        int grado = 0;
        while (i < m.length) {
            grado += ((Integer)m[pos][i++]).intValue();
        }
        return grado;
    }

    public int getGradoEntradaVert(T info) {
        Vertice<T> v = this.buscarVertice(info);
        if (v == null) {
            return -1;
        }
        Object[][] m = this.getMatrizAdyacencia();
        int pos = this.vertices.getIndice(v) + 1;
        int i = 1;
        int grado = 0;
        while (i < m.length) {
            grado += ((Integer)m[i++][pos]).intValue();
        }
        return grado;
    }

    public boolean esVerticeAislado(T info) {
        Vertice<T> vert = this.buscarVertice(info);
        if (vert == null) {
            return true;
        }
        for (Vertice v : this.vertices) {
            ListaCD<Vertice> l = v.getVecinos();
            for (Vertice v2 : l) {
                if (v.equals(vert) || !v2.equals(vert)) continue;
                return false;
            }
        }
        return true;
    }

    public ListaCD<Vertice> getVecinosVertice(T info) {
        Vertice<T> v = this.buscarVertice(info);
        if (v == null) {
            return null;
        }
        return v.getVecinos();
    }

    private void limpiarPredecesores() {
        for (Vertice v : this.vertices) {
            v.setPredecesor(null);
        }
    }

    public boolean hayCircuito() {
        for (Vertice v : this.vertices) {
            if (!this.existeRuta(v, v)) continue;
            return true;
        }
        return false;
    }

    public ListaCD<ListaCD<Vertice>> getCircuitos() {
        ListaCD<ListaCD<Vertice>> l = new ListaCD<ListaCD<Vertice>>();
        for (Vertice v : this.vertices) {
            ListaCD<Vertice> l2 = this.getRutaEntre(v.getInfo(), v.getInfo());
            if (l2.esVacia()) continue;
            l.insertarAlFinal(l2);
        }
        return l;
    }

    public boolean esPuente(T info1, T info2) {
        GrafoND d = this.clonar();
        Arista<T> a = d.buscarArista(info1, info2);
        boolean rta = false;
        if (a == null) {
            return false;
        }
        d.eliminarArista(info1, info2);
        if (!d.esConexo()) {
            rta = true;
        }
        return rta;
    }

    public boolean esArticulacion(T info) {
        GrafoND d = this.clonar();
        Vertice<T> v = d.buscarVertice(info);
        boolean rta = false;
        if (v == null) {
            return false;
        }
        d.eliminarVertice(info);
        if (!d.esConexo()) {
            rta = true;
        }
        return rta;
    }

    public GrafoND clonar() {
        GrafoND<T> nuevo = new GrafoND<T>();
        nuevo.setVertices(this.getVertices());
        nuevo.setAristas(this.getAristas());
        return nuevo;
    }

    public boolean esSubGrafo(GrafoND g) {
        for (Vertice vertice : g.getVertices()) {
            Vertice v = vertice;
            if (this.vertices.esta(v)) continue;
            return false;
        }
        for (Object object : g.getAristas()) {
            Arista a = (Arista)object;
            if (this.aristas.esta(a)) continue;
            return false;
        }
        return true;
    }

    public void unirGrafos(GrafoND g) {
        for (Vertice vertice : g.getVertices()) {
            Vertice v = vertice;
            if (this.vertices.esta(v)) continue;
            this.insertarVertice(v.getInfo());
        }
        for (Object object : g.getAristas()) {
            Arista a = (Arista)object;
            if (this.aristas.esta(a)) continue;
            this.insertarAristaP(a.getVertA().getInfo(), a.getVertB().getInfo(), a.getPeso());
        }
    }

    public int getPeso() {
        return this.vertices.getTamanio();
    }

    public int[] getListaGrados() {
        int[] v = new int[this.vertices.getTamanio()];
        int i = 0;
        for (Vertice vert : this.vertices) {
            v[i++] = this.getGradoVertice(vert.getInfo());
        }
        return v;
    }

    public int getGradoVertice(T info) {
        Vertice<T> v = this.buscarVertice(info);
        if (v == null) {
            return -1;
        }
        return v.getGradoND();
    }

    public boolean esVerticeHoja(T info) {
        Vertice<T> v = this.buscarVertice(info);
        if (v == null) {
            return false;
        }
        return v.esHojaND();
    }

    public boolean apretonDeManos() {
        int numAris = this.aristas.getTamanio();
        int sumGra = 0;
        for (Vertice v : this.vertices) {
            sumGra += this.getGradoVertice(v.getInfo());
        }
        return 2 * numAris == sumGra;
    }

    public String toString() {
        String cad = "Vertices: ";
        for (Vertice v : this.vertices) {
            cad = cad + v.getInfo() + ",";
        }
        cad = cad + "\nAristas:";
        for (Arista a : this.aristas) {
            cad = cad + a.toString() + ",";
        }
        return cad;
    }
}

