/*
 * Decompiled with CFR 0.152.
 */
package Colecciones;

import Colecciones.ExceptionUFPS;
import Colecciones.IteratorLD;
import Colecciones.NodoD;
import java.util.Iterator;

public class ListaD<T>
implements Iterable<T> {
    private NodoD<T> cabeza = null;
    private int tamanio = 0;

    public void insertarAlInicio(T x) {
        if (this.cabeza == null) {
            this.cabeza = new NodoD<T>(x, null, null);
        } else {
            this.cabeza = new NodoD<T>(x, this.cabeza, null);
            this.cabeza.getSig().setAnt(this.cabeza);
        }
        ++this.tamanio;
    }

    public void insertarAlFinal(T x) {
        if (this.cabeza == null) {
            this.insertarAlInicio(x);
        } else {
            try {
                NodoD<T> ult = this.getPos(this.tamanio - 1);
                if (ult == null) {
                    return;
                }
                ult.setSig(new NodoD<T>(x, null, ult));
                ++this.tamanio;
            }
            catch (ExceptionUFPS ex) {
                System.err.println(ex.getMessage());
            }
        }
    }

    public void insertarOrdenado(T info) {
        NodoD<T> p;
        Comparable x = (Comparable)info;
        if (this.esVacia() || x.compareTo(this.cabeza.getInfo()) <= 0) {
            this.insertarAlInicio(info);
            return;
        }
        NodoD<T> nuevo = new NodoD<T>(info, null, null);
        for (p = this.cabeza; p != null && x.compareTo(p.getInfo()) >= 0; p = p.getSig()) {
        }
        if (p == null) {
            this.insertarAlFinal(info);
        } else {
            nuevo.setAnt(p.getAnt());
            nuevo.setSig(p);
            p.setAnt(nuevo);
            nuevo.getAnt().setSig(nuevo);
            ++this.tamanio;
        }
    }

    public T eliminar(int i) {
        try {
            NodoD x = this.getPos(i);
            if (x == null) {
                return null;
            }
            if (x == this.cabeza) {
                this.cabeza = this.cabeza.getSig();
            } else {
                x.getAnt().setSig(x.getSig());
                if (x.getSig() != null) {
                    x.getSig().setAnt(x.getAnt());
                }
            }
            x.setAnt(null);
            x.setSig(null);
            --this.tamanio;
            return x.getInfo();
        }
        catch (ExceptionUFPS ex) {
            System.err.println(ex.getMessage());
            return null;
        }
    }

    public void vaciar() {
        this.cabeza = null;
        this.tamanio = 0;
    }

    public T get(int i) {
        try {
            NodoD<T> t = this.getPos(i);
            if (t == null) {
                return null;
            }
            return t.getInfo();
        }
        catch (ExceptionUFPS ex) {
            System.err.println(ex.getMessage());
            return null;
        }
    }

    public void set(int i, T dato) {
        try {
            NodoD<T> t = this.getPos(i);
            if (t == null) {
                return;
            }
            t.setInfo(dato);
        }
        catch (ExceptionUFPS e) {
            System.err.println(e.getMessage());
        }
    }

    public int getTamanio() {
        return this.tamanio;
    }

    public boolean esVacia() {
        return this.cabeza == null;
    }

    public boolean esta(T info) {
        return this.getIndice(info) != -1;
    }

    @Override
    public Iterator<T> iterator() {
        return new IteratorLD<T>(this.cabeza);
    }

    public Object[] aVector() {
        if (this.esVacia()) {
            return null;
        }
        Object[] vector = new Object[this.getTamanio()];
        Iterator<T> it = this.iterator();
        int i = 0;
        while (it.hasNext()) {
            vector[i++] = it.next();
        }
        return vector;
    }

    public String toString() {
        if (this.esVacia()) {
            return "Lista Vacia";
        }
        String r = "";
        for (NodoD<T> x = this.cabeza; x != null; x = x.getSig()) {
            r = r + x.getInfo().toString() + "<->";
        }
        return r;
    }

    private NodoD<T> getPos(int i) throws ExceptionUFPS {
        if (i > this.tamanio || this.cabeza == null || i < 0) {
            System.err.println("Error indice no valido en una Lista Doble Enlazada");
            return null;
        }
        NodoD<T> t = this.cabeza;
        while (i > 0) {
            --i;
            t = t.getSig();
        }
        return t;
    }

    public int getIndice(T info) {
        int i = 0;
        for (NodoD<T> x = this.cabeza; x != null; x = x.getSig()) {
            if (x.getInfo().equals(info)) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

