/*
 * Decompiled with CFR 0.152.
 */
package Colecciones;

public class Secuencia<T> {
    private T[] vector;
    private int cant;

    public Secuencia(int n) {
        if (n <= 0) {
            System.err.println("Tama\u00f1o de secuencia no valido!");
            return;
        }
        Object[] r = new Object[n];
        this.cant = 0;
        this.vector = r;
    }

    public void insertar(T elem) {
        if (this.cant >= this.vector.length) {
            System.err.println("No hay m\u00e1s espacio!");
        } else {
            this.vector[this.cant++] = elem;
        }
    }

    public void eliminar(T elem) {
        boolean e = false;
        int j = 0;
        for (int i = 0; i < this.cant; ++i) {
            if (!this.vector[i].equals(elem)) {
                this.vector[j] = this.vector[i];
                ++j;
                continue;
            }
            e = true;
            this.vector[j] = null;
        }
        if (e) {
            --this.cant;
        }
    }

    public void eliminarP(int pos) {
        if (pos < 0 || pos > this.cant) {
            System.err.println("Ind\u00edce fuera de rango!");
            return;
        }
        boolean e = false;
        int j = 0;
        for (int i = 0; i < this.cant; ++i) {
            if (i != pos) {
                this.vector[j] = this.vector[i];
                ++j;
                continue;
            }
            e = true;
            this.vector[j] = null;
        }
        if (e) {
            --this.cant;
        }
    }

    public void vaciar() {
        for (int i = 0; i < this.cant; ++i) {
            this.vector[i] = null;
        }
        this.cant = 0;
    }

    public T get(int i) {
        if (i < 0 || i > this.cant) {
            System.err.println("Ind\u00edce fuera de rango!");
            return null;
        }
        return this.vector[i];
    }

    public void set(int i, T nuevo) {
        if (i < 0 || i > this.cant) {
            System.err.println("Ind\u00edce fuera de rango!");
            return;
        }
        if (nuevo == null) {
            System.err.println("No se pueden ingresar datos nulos!");
            return;
        }
        this.vector[i] = nuevo;
    }

    public boolean esta(T elem) {
        for (int i = 0; i < this.cant; ++i) {
            if (!this.vector[i].equals(elem)) continue;
            return true;
        }
        return false;
    }

    public int getIndice(T elem) {
        for (int i = 0; i < this.cant; ++i) {
            if (!this.vector[i].equals(elem)) continue;
            return i;
        }
        return -1;
    }

    public int getTamanio() {
        return this.cant;
    }

    public boolean esVacia() {
        return this.cant == 0;
    }

    public int getCapacidad() {
        return this.vector.length;
    }

    public String toString() {
        if (this.esVacia()) {
            return "Secuencia vacia!";
        }
        String msg = "Secuencia -> | ";
        for (int i = 0; i < this.cant; ++i) {
            msg = msg + this.vector[i].toString() + " | ";
        }
        return msg;
    }
}

