/*
 * Decompiled with CFR 0.152.
 */
package elaprendiz.awt.frame;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JPanel;

public class FramedPanel
extends JPanel {
    static final int DEFAULT_FRAME_WIDTH = 2;
    private int frameWidth;
    private Color frameColor = null;

    public FramedPanel(int frameWidth, Color frameColor) {
        this.frameWidth = frameWidth;
        this.frameColor = frameColor;
    }

    public FramedPanel() {
        this(2, null);
    }

    @Override
    public Insets insets() {
        Insets insets = super.insets();
        insets.top += this.frameWidth + 2;
        insets.bottom += this.frameWidth + 2;
        insets.left += this.frameWidth + 2;
        insets.right += this.frameWidth + 2;
        return insets;
    }

    @Override
    public void paint(Graphics g) {
        int w = this.size().width;
        int h = this.size().height;
        int f = Math.round(this.frameWidth / 2);
        if (f % 2 != 0) {
            ++f;
        }
        if (this.frameColor != null) {
            g.setColor(this.frameColor);
        } else {
            g.setColor(this.getBackground());
        }
        for (int i = 0; i < f; ++i) {
            g.draw3DRect(i, i, w - i * 2 - 1, h - i * 2 - 1, true);
            g.draw3DRect(f + i, f + i, w - (f + i) * 2 - 1, h - (f + i) * 2 - 1, false);
        }
        g.setColor(this.getBackground());
    }
}

