/*
 * Decompiled with CFR 0.152.
 */
package elaprendiz.estructuras;

import elaprendiz.awt.frame.FramedPanel;
import elaprendiz.estructuras.LienzoBinario;
import elaprendiz.estructuras.funciones.Buscar;
import elaprendiz.estructuras.funciones.Eliminar;
import elaprendiz.estructuras.funciones.Insertar;
import elaprendiz.graficos.imagenes.ImageFrame;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.TextField;
import java.util.Vector;
import javax.swing.JPanel;

public class ArbolBinario
extends ImageFrame {
    static final String BASE_NODE = "Base Node";
    static final String HIGHLIGHT = "HighLight";
    static final int NODE_SIZE = 25;
    int edgeSize = (int)Math.floor(2.5);
    protected LienzoBinario animationCanvas;
    protected TextField field = new TextField();
    Label label = new Label("", 1);
    Vector labelVector = new Vector();

    public final synchronized void createBaseNode() {
        Image image = this.createImage(25 + this.edgeSize, 25 + this.edgeSize);
        Graphics graphics = image.getGraphics();
        graphics.setColor(TRANSPARENT_COLOR);
        graphics.fillOval(0, 0, 25 + this.edgeSize, 25 + this.edgeSize);
        graphics.setColor(Color.darkGray);
        graphics.fillOval(this.edgeSize, this.edgeSize, 25, 25);
        int[] xs = new int[3];
        int[] ys = new int[3];
        xs[0] = 0;
        xs[1] = 0;
        xs[2] = 25;
        ys[0] = 0;
        ys[1] = 25;
        ys[2] = 0;
        xs[0] = 0;
        xs[1] = 25;
        xs[2] = 25;
        ys[0] = 25;
        ys[1] = 0;
        ys[2] = 25;
        graphics.setColor(Color.blue.brighter());
        graphics.fillOval(this.edgeSize, this.edgeSize, 25 - 2 * this.edgeSize, 25 - 2 * this.edgeSize);
        graphics.dispose();
        image = this.filterImage(image);
        this.putImage(BASE_NODE, image);
    }

    public final synchronized void crearResaltado() {
        Image image = this.createImage(52, 53);
        Graphics graphics = image.getGraphics();
        graphics.setColor(TRANSPARENT_COLOR);
        graphics.fillRect(0, 0, 52, 53);
        graphics.setColor(new Color(224, 224, 224));
        graphics.fillOval(1, 1, 50, 50);
        graphics.dispose();
        image = this.filterImage(image);
        this.putImage(HIGHLIGHT, image);
    }

    public final synchronized void crearNodoNuevo(String value) {
        Image image = this.copyImage(BASE_NODE);
        Graphics graphics = image.getGraphics();
        graphics.setFont(new Font("TimesRoman", 0, 14));
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int xLocation = (int)Math.ceil((double)(25 - fontMetrics.stringWidth(value)) / 2.0);
        int yLocation = (int)Math.ceil((double)(25 - fontMetrics.getHeight()) / 2.0) + fontMetrics.getAscent();
        graphics.setColor(Color.black);
        graphics.drawString(value, xLocation + 1, yLocation + 1);
        graphics.setColor(Color.white);
        graphics.drawString(value, xLocation, yLocation);
        graphics.dispose();
        fontMetrics = null;
        image = this.filterImage(image);
        this.putImage(value, image);
    }

    @Override
    public void init() {
        this.setLayout(new BorderLayout());
        this.animationCanvas = new LienzoBinario(this, 25 + this.edgeSize);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(0, 4));
        buttonPanel.add(new Button("Agregar"));
        buttonPanel.add(new Button("Eliminar"));
        buttonPanel.add(new Button("Buscar"));
        buttonPanel.add(this.field);
        FramedPanel frameOne = new FramedPanel(4, null);
        FramedPanel frameTwo = new FramedPanel(4, null);
        FramedPanel frameThree = new FramedPanel(4, null);
        frameOne.setLayout(new GridLayout(1, 0));
        frameOne.add(buttonPanel);
        frameTwo.setLayout(new GridLayout(1, 0));
        frameTwo.add(this.label);
        frameThree.setLayout(new GridLayout(1, 0));
        frameThree.add(this.animationCanvas);
        this.add("North", frameOne);
        this.add("South", frameTwo);
        this.add("Center", frameThree);
        this.createBaseNode();
        this.crearResaltado();
        this.validate();
    }

    public void updateLabel(String value) {
        this.label.setText(value);
    }

    @Override
    public boolean action(Event evt, Object arg) {
        String value = this.field.getText();
        this.field.selectAll();
        int numericValue = 0;
        if ("Agregar".equals(arg)) {
            try {
                numericValue = Math.abs(Integer.parseInt(value) % 100);
                this.crearNodoNuevo("" + numericValue);
                Insertar insert = new Insertar(numericValue, this.animationCanvas);
                insert.addObserver(this.animationCanvas);
                this.animationCanvas.addFunction(insert);
            }
            catch (NumberFormatException e) {
                numericValue = 0;
                this.field.setText("");
            }
            return true;
        }
        if ("Buscar".equals(arg)) {
            try {
                numericValue = Math.abs(Integer.parseInt(value) % 100);
                Buscar search = new Buscar(numericValue, this.animationCanvas);
                search.addObserver(this.animationCanvas);
                this.animationCanvas.addFunction(search);
            }
            catch (NumberFormatException e) {
                numericValue = 0;
                this.field.setText("");
            }
            return true;
        }
        if ("Eliminar".equals(arg)) {
            try {
                numericValue = Math.abs(Integer.parseInt(value) % 100);
                Eliminar delete = new Eliminar(numericValue, this.animationCanvas);
                delete.addObserver(this.animationCanvas);
                this.animationCanvas.addFunction(delete);
            }
            catch (NumberFormatException e) {
                numericValue = 0;
                this.field.setText("");
            }
            return true;
        }
        return false;
    }
}

