/*
 * Decompiled with CFR 0.152.
 */
package elaprendiz.estructuras.funciones;

import elaprendiz.estructuras.LienzoBinario;
import elaprendiz.estructuras.funciones.MoverSubArbol;
import elaprendiz.estructuras.nodos.ArbolNodo;
import elaprendiz.graficos.funciones.Funcion;
import java.awt.Point;
import java.util.Observable;
import java.util.Observer;

public class ContratoArbol
extends Funcion
implements Observer {
    boolean bloqueado = false;

    public ContratoArbol(LienzoBinario canvas) {
        int[] values;
        int level = canvas.getLevel();
        for (int i = 0; i < level; ++i) {
            values = canvas.getLevelValues(i);
            if (values[2] == 1) {
                values[0] = values[1] / 2;
                values[1] = values[1] * 2;
                values[2] = 0;
            } else {
                values[0] = values[0] / 2;
                if (values[0] == values[1]) {
                    values[2] = 1;
                }
            }
            canvas.setLevelValues(i, values);
        }
        boolean functionsRun = false;
        for (int i = 0; i < level; ++i) {
            int startCheck = (int)Math.pow(2.0, i);
            int endCheck = (int)Math.pow(2.0, i + 1);
            values = canvas.getLevelValues(i);
            for (int j = startCheck; j < endCheck; ++j) {
                ArbolNodo rightChild;
                MoverSubArbol mover;
                int yPosition;
                int xPosition;
                ArbolNodo parent = canvas.getNodeAtRank(j);
                if (parent == null) continue;
                ArbolNodo leftChild = parent.getLeftChild();
                if (leftChild != null) {
                    xPosition = parent.origin().x - values[0];
                    yPosition = parent.origin().y + values[1];
                    if (leftChild.origin().x != xPosition || leftChild.origin().y != yPosition) {
                        mover = new MoverSubArbol(new Point(xPosition, yPosition), leftChild);
                        mover.addObserver(this);
                        canvas.addFunction(mover);
                        functionsRun = true;
                    }
                }
                if ((rightChild = parent.getRightChild()) == null) continue;
                xPosition = parent.origin().x + values[0];
                yPosition = parent.origin().y + values[1];
                if (rightChild.origin().x == xPosition && rightChild.origin().y == yPosition) continue;
                mover = new MoverSubArbol(new Point(xPosition, yPosition), rightChild);
                mover.addObserver(this);
                canvas.addFunction(mover);
                functionsRun = true;
            }
        }
        if (functionsRun) {
            this.bloqueado = true;
        }
    }

    @Override
    public void update(Observable observed, Object arg) {
        if (observed instanceof MoverSubArbol) {
            this.bloqueado = false;
        }
    }

    @Override
    public void performFuncion() {
        if (!this.bloqueado) {
            this.terminado = true;
        }
    }
}

