/*
 * Decompiled with CFR 0.152.
 */
package elaprendiz.estructuras.funciones;

import elaprendiz.estructuras.LienzoBinario;
import elaprendiz.estructuras.funciones.MoverSubArbol;
import elaprendiz.estructuras.nodos.ArbolNodo;
import elaprendiz.graficos.funciones.Funcion;
import java.awt.Point;
import java.util.Observable;
import java.util.Observer;

public class ExtenderArbol
extends Funcion
implements Observer {
    boolean bloqueado = false;

    public ExtenderArbol(LienzoBinario canvas) {
        int[] values;
        int level = canvas.getLevel() - 1;
        for (int i = 0; i < level; ++i) {
            values = canvas.getLevelValues(i);
            if (values[2] == 0) {
                values[0] = 2 * values[0];
                values[1] = values[1] / 2;
                values[2] = 1;
            } else {
                values[0] = 2 * values[0];
                if (values[2] == 1) {
                    values[2] = 2;
                }
            }
            canvas.setLevelValues(i, values);
        }
        boolean functionsRun = false;
        for (int i = 0; i < level; ++i) {
            int startCheck = (int)Math.pow(2.0, i);
            int endCheck = (int)Math.pow(2.0, i + 1);
            values = canvas.getLevelValues(i);
            for (int j = startCheck; j < endCheck; ++j) {
                ArbolNodo rightChild;
                MoverSubArbol mover;
                ArbolNodo parent = canvas.getNodeAtRank(j);
                if (parent == null) continue;
                int xMove = values[0] / 2;
                int yMove = values[2] == 1 ? values[1] : 0;
                ArbolNodo leftChild = parent.getLeftChild();
                if (leftChild != null) {
                    mover = new MoverSubArbol(new Point(leftChild.origin().x - xMove, leftChild.origin().y - yMove), leftChild);
                    mover.addObserver(this);
                    canvas.addFunction(mover);
                    functionsRun = true;
                }
                if ((rightChild = parent.getRightChild()) == null) continue;
                mover = new MoverSubArbol(new Point(rightChild.origin().x + xMove, rightChild.origin().y - yMove), rightChild);
                mover.addObserver(this);
                canvas.addFunction(mover);
                functionsRun = true;
            }
        }
        if (functionsRun) {
            this.bloqueado = true;
        }
    }

    @Override
    public void update(Observable observed, Object arg) {
        if (observed instanceof MoverSubArbol) {
            this.bloqueado = false;
        }
    }

    @Override
    public void performFuncion() {
        if (!this.bloqueado) {
            this.terminado = true;
        }
    }
}

