/*
 * Decompiled with CFR 0.152.
 */
package elaprendiz.estructuras.funciones;

import elaprendiz.estructuras.LienzoBinario;
import elaprendiz.estructuras.funciones.ExtenderArbol;
import elaprendiz.estructuras.funciones.MoveNode;
import elaprendiz.estructuras.funciones.Resaltar;
import elaprendiz.estructuras.nodos.ArbolNodo;
import elaprendiz.graficos.funciones.Funcion;
import java.awt.Point;
import java.util.Observable;
import java.util.Observer;

public class Insertar
extends Funcion
implements Observer {
    protected LienzoBinario canvas;
    protected ArbolNodo nodoNuevo;
    protected ArbolNodo nodoActual;
    protected ArbolNodo nodoSiguiente;
    protected boolean bloqueado = false;
    protected boolean ajusteArbolHecho = false;
    protected int level = 0;
    protected int iniciarNivel;
    protected String actualizarInfo = "";

    public Insertar(int value, LienzoBinario canvas) {
        this.canvas = canvas;
        this.iniciarNivel = canvas.getLevel();
        this.nodoNuevo = new ArbolNodo(new Point(canvas.size().width / 2, canvas.getNodeSize() / 2), canvas.frame, value);
    }

    public Insertar(ArbolNodo newNode, LienzoBinario canvas) {
        this.canvas = canvas;
        this.iniciarNivel = canvas.getLevel();
        this.nodoNuevo = newNode;
    }

    @Override
    public void update(Observable observed, Object arg) {
        if (observed instanceof Resaltar) {
            this.bloqueado = false;
        } else if (observed instanceof MoveNode) {
            this.bloqueado = false;
            this.ajusteArbolHecho = true;
        }
    }

    @Override
    public void performFuncion() {
        if (this.bloqueado) {
            this.setChanged();
            this.notifyObservers(this.actualizarInfo);
        } else if (this.ajusteArbolHecho) {
            this.setChanged();
            this.notifyObservers(this.nodoNuevo);
            this.terminado = true;
        } else if (this.canvas.getRootNode() == null) {
            this.nodoNuevo.setRank(1);
            this.canvas.addNode(this.nodoNuevo);
            MoveNode mover = new MoveNode(new Point(this.canvas.size().width / 2, this.canvas.getNodeSize() * 4), this.nodoNuevo);
            mover.addObserver(this);
            this.canvas.addFunction(mover);
            this.actualizarInfo = "Nodo raiz creado con valor: " + this.nodoNuevo.getValue();
            this.setChanged();
            this.notifyObservers(this.actualizarInfo);
            this.bloqueado = true;
        } else if (this.nodoActual == null) {
            this.nodoActual = this.canvas.getRootNode();
            Resaltar highLight = new Resaltar(this.nodoActual, this.canvas);
            highLight.addObserver(this);
            this.canvas.addFunction(highLight);
            this.actualizarInfo = "Iniciando la busqueda desde la raiz: " + this.nodoActual.getValue();
            this.setChanged();
            this.notifyObservers(this.actualizarInfo);
            this.bloqueado = true;
        } else if (this.nodoActual.menorQue(this.nodoNuevo)) {
            this.nodoSiguiente = this.nodoActual.getLeftChild();
            if (this.nodoSiguiente == null) {
                this.nodoActual.setLeftChild(this.nodoNuevo);
                this.nodoNuevo.setParent(this.nodoActual);
                this.nodoNuevo.setRank(this.nodoActual.getRank() * 2);
                this.canvas.addNode(this.nodoNuevo);
                this.nodoNuevo.moveNode(this.nodoActual.origin().x, this.nodoActual.origin().y);
                int[] values = this.canvas.getLevelValues(this.level);
                MoveNode mover = new MoveNode(new Point(this.nodoNuevo.origin().x - values[0], this.nodoNuevo.origin().y + values[1]), this.nodoNuevo);
                mover.addObserver(this);
                this.canvas.addFunction(mover);
                this.actualizarInfo = "Nuevo nodo : " + this.nodoNuevo.getValue() + " Agregado a la izquierda : " + this.nodoActual.getValue();
                this.setChanged();
                this.notifyObservers(this.actualizarInfo);
                if (this.iniciarNivel < this.canvas.getLevel()) {
                    this.canvas.addFunction(new ExtenderArbol(this.canvas));
                }
                this.bloqueado = true;
            } else {
                this.nodoActual = this.nodoSiguiente;
                Resaltar highLight = new Resaltar(this.nodoActual, this.canvas);
                highLight.addObserver(this);
                this.canvas.addFunction(highLight);
                this.actualizarInfo = "Node : " + this.nodoActual.getValue() + " Comparado con el valor : " + this.nodoNuevo.getValue();
                this.setChanged();
                this.notifyObservers(this.actualizarInfo);
                this.bloqueado = true;
                ++this.level;
            }
        } else if (this.nodoActual.mayorQue(this.nodoNuevo)) {
            this.nodoSiguiente = this.nodoActual.getRightChild();
            if (this.nodoSiguiente == null) {
                this.nodoActual.setRightChild(this.nodoNuevo);
                this.nodoNuevo.setParent(this.nodoActual);
                this.nodoNuevo.setRank(this.nodoActual.getRank() * 2 + 1);
                this.canvas.addNode(this.nodoNuevo);
                this.nodoNuevo.move(this.nodoActual.origin().x, this.nodoActual.origin().y);
                int[] values = this.canvas.getLevelValues(this.level);
                MoveNode mover = new MoveNode(new Point(this.nodoNuevo.origin().x + values[0], this.nodoNuevo.origin().y + values[1]), this.nodoNuevo);
                mover.addObserver(this);
                this.canvas.addFunction(mover);
                this.actualizarInfo = "Nuevo nodo : " + this.nodoNuevo.getValue() + " Agregado a la derecha : " + this.nodoActual.getValue();
                this.setChanged();
                this.notifyObservers(this.actualizarInfo);
                if (this.iniciarNivel < this.canvas.getLevel()) {
                    this.canvas.addFunction(new ExtenderArbol(this.canvas));
                }
                this.bloqueado = true;
            } else {
                this.nodoActual = this.nodoSiguiente;
                Resaltar highLight = new Resaltar(this.nodoActual, this.canvas);
                highLight.addObserver(this);
                this.canvas.addFunction(highLight);
                this.actualizarInfo = "Nodo : " + this.nodoActual.getValue() + " Valor comparado con : " + this.nodoNuevo.getValue();
                this.setChanged();
                this.notifyObservers(this.actualizarInfo);
                this.bloqueado = true;
                ++this.level;
            }
        } else {
            this.actualizarInfo = "Nodo : " + this.nodoNuevo.getValue() + " Ya existe en el arbol";
            this.setChanged();
            this.notifyObservers(this.actualizarInfo);
            this.setChanged();
            this.notifyObservers(null);
            this.terminado = true;
        }
    }
}

