/*
 * Decompiled with CFR 0.152.
 */
package elaprendiz.estructuras.nodos;

import elaprendiz.estructuras.nodos.Nodo;
import elaprendiz.graficos.imagenes.ImageFrame;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.util.Vector;

public class ArbolNodo
extends Nodo {
    protected int rank = -1;

    public ArbolNodo(Point origin, ImageFrame frame, int value) {
        super(origin, frame, value);
    }

    public ArbolNodo(ArbolNodo node) {
        super(node);
        this.rank = node.rank;
    }

    public ArbolNodo(Point origin) {
        super(origin);
    }

    public int getRank() {
        return this.rank;
    }

    public void setRank(int rank) {
        ArbolNodo rightChild;
        this.rank = rank;
        ArbolNodo leftChild = this.getLeftChild();
        if (leftChild != null) {
            leftChild.setRank(rank * 2);
        }
        if ((rightChild = this.getRightChild()) != null) {
            rightChild.setRank(rank * 2 + 1);
        }
    }

    public void setLeftChild(ArbolNodo node) {
        if (node == null) {
            this.nodos.remove("leftChild");
        } else {
            this.nodos.put("leftChild", node);
        }
    }

    public ArbolNodo getLeftChild() {
        return (ArbolNodo)this.nodos.get("leftChild");
    }

    public void setRightChild(ArbolNodo node) {
        if (node == null) {
            this.nodos.remove("rightChild");
        } else {
            this.nodos.put("rightChild", node);
        }
    }

    public ArbolNodo getRightChild() {
        return (ArbolNodo)this.nodos.get("rightChild");
    }

    public void setParent(ArbolNodo node) {
        if (node == null) {
            this.nodos.remove("parent");
        } else {
            this.nodos.put("parent", node);
        }
    }

    public ArbolNodo getParent() {
        return (ArbolNodo)this.nodos.get("parent");
    }

    public ArbolNodo getLeastChild() {
        ArbolNodo check = (ArbolNodo)this.nodos.get("leftChild");
        if (check == null) {
            return this;
        }
        while (check.nodos.get("leftChild") != null) {
            check = (ArbolNodo)check.nodos.get("leftChild");
        }
        return check;
    }

    public ArbolNodo getGreatestChild() {
        ArbolNodo check = (ArbolNodo)this.nodos.get("rightChild");
        if (check == null) {
            return this;
        }
        while (check.nodos.get("rightChild") != null) {
            check = (ArbolNodo)check.nodos.get("rightChild");
        }
        return check;
    }

    @Override
    public void translate(int x, int y) {
        this.origen.translate(x, y);
        ArbolNodo leftChild = (ArbolNodo)this.nodos.get("leftChild");
        ArbolNodo rightChild = (ArbolNodo)this.nodos.get("rightChild");
        if (leftChild != null) {
            leftChild.translate(x, y);
        }
        if (rightChild != null) {
            rightChild.translate(x, y);
        }
    }

    public void translateNode(int x, int y) {
        this.origen.translate(x, y);
    }

    @Override
    public void move(int x, int y) {
        int depth;
        int width;
        ArbolNodo leftChild = (ArbolNodo)this.nodos.get("leftChild");
        ArbolNodo rightChild = (ArbolNodo)this.nodos.get("rightChild");
        if (leftChild != null) {
            width = this.origen.x - leftChild.origen.x;
            depth = leftChild.origen.y - this.origen.y;
            leftChild.move(x - width, y + depth);
        }
        if (rightChild != null) {
            width = rightChild.origen.x - this.origen.x;
            depth = rightChild.origen.y - this.origen.y;
            rightChild.move(x + width, y + depth);
        }
        this.origen.move(x, y);
    }

    public void moveNode(int x, int y) {
        this.origen.move(x, y);
    }

    @Override
    public void draw(Graphics g) {
        Color backColor = g.getColor();
        ArbolNodo parent = (ArbolNodo)this.nodos.get("parent");
        g.setColor(Color.black);
        if (parent != null) {
            g.setColor(Color.GREEN);
            g.drawLine(this.origen.x, this.origen.y, parent.origen.x, parent.origen.y);
            g.setColor(Color.green.brighter());
            g.drawLine(this.origen.x, this.origen.y + 1, parent.origen.x, parent.origen.y + 1);
            g.setColor(Color.gray);
            g.drawLine(this.origen.x, this.origen.y + 4, parent.origen.x, parent.origen.y + 4);
        }
        g.setColor(backColor);
        super.draw(g);
    }

    protected ArbolNodo cloneNode(Vector returnVector, ArbolNodo parent) {
        ArbolNodo copy = new ArbolNodo(this);
        if (parent != null) {
            copy.setParent(parent);
        }
        ArbolNodo leftChild = (ArbolNodo)this.nodos.get("leftChild");
        ArbolNodo rightChild = (ArbolNodo)this.nodos.get("rightChild");
        if (leftChild != null) {
            copy.setLeftChild(leftChild.cloneNode(returnVector, copy));
        }
        if (rightChild != null) {
            copy.setRightChild(rightChild.cloneNode(returnVector, copy));
        }
        returnVector.addElement(copy);
        return copy;
    }

    @Override
    public synchronized Vector cloneStructure() {
        Vector treeVector = new Vector();
        this.cloneNode(treeVector, null);
        return treeVector;
    }
}

