/*
 * Decompiled with CFR 0.152.
 */
package elaprendiz.graficos.imagenes;

import elaprendiz.graficos.imagenes.ImageFrame;
import elaprendiz.graficos.objetos.ObjetosGraficos;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;

public class ObjetoImagen
extends ObjetosGraficos {
    protected Image image = null;
    protected Dimension imageSize = null;
    protected int widthOffSet = -1;
    protected int heightOffSet = -1;

    private void calculateOffSets() {
        if (this.imageSize != null) {
            this.widthOffSet = this.imageSize.width / 2;
            this.heightOffSet = this.imageSize.height / 2;
        } else {
            this.widthOffSet = -1;
            this.heightOffSet = -1;
        }
    }

    public ObjetoImagen(Point origin, ImageFrame frame, String imageName) {
        super(origin);
        if (frame != null && (this.image = frame.getImage(imageName)) != null) {
            int width = this.image.getWidth(frame);
            int height = this.image.getHeight(frame);
            this.imageSize = new Dimension(width, height);
        } else {
            this.imageSize = null;
        }
        this.calculateOffSets();
    }

    public ObjetoImagen(ObjetoImagen object) {
        super(new Point(object.origen.x, object.origen.y));
        this.image = object.image;
        this.imageSize = new Dimension(object.imageSize);
        this.widthOffSet = object.widthOffSet;
        this.heightOffSet = object.heightOffSet;
    }

    public synchronized void changeImage(ImageFrame frame, String imageName) {
        this.image = frame.getImage(imageName);
        if (this.image != null) {
            int width = this.image.getWidth(frame);
            int height = this.image.getHeight(frame);
            if (this.imageSize.width != width || this.imageSize.height != height) {
                this.imageSize = new Dimension(width, height);
                this.calculateOffSets();
            }
        }
    }

    public synchronized boolean inBounds(int x, int y) {
        if (this.widthOffSet == -1 && this.heightOffSet == -1) {
            return false;
        }
        return x > this.origen.x - this.widthOffSet && x < this.origen.x + this.widthOffSet && y > this.origen.y - this.heightOffSet && y < this.origen.y + this.heightOffSet;
    }

    public void move(int x, int y) {
        this.origen.move(x, y);
    }

    public void translate(int x, int y) {
        this.origen.translate(x, y);
    }

    @Override
    public Dimension size() {
        return new Dimension(this.imageSize);
    }

    @Override
    public void draw(Graphics g) {
        if (this.image != null) {
            g.drawImage(this.image, this.origen.x - this.widthOffSet, this.origen.y - this.heightOffSet, null);
        } else {
            System.out.println("Image is null");
        }
    }
}

