/*
 * Decompiled with CFR 0.152.
 */
package elaprendiz.estructuras;

import elaprendiz.estructuras.BufferHilo;
import elaprendiz.estructuras.FuncionHilo;
import elaprendiz.estructuras.HiloAnimador;
import elaprendiz.graficos.funciones.Funcion;
import elaprendiz.graficos.imagenes.ImageFrame;
import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;

public abstract class EstructuraLienzo
extends Canvas
implements Observer {
    protected Vector functionVector = new Vector();
    protected int nodeSize;
    public ImageFrame frame;
    protected Dimension offDimension;
    protected Graphics offGraphics;
    protected Image offImage;
    protected Vector copyVector = new Vector();
    protected boolean functionSuspended = true;
    protected boolean bufferLoaded = false;
    protected boolean paintingDone = true;
    protected Vector updateVector = new Vector();
    protected String updateString = "";
    protected FuncionHilo functionThread = new FuncionHilo(this);
    protected BufferHilo bufferThread = new BufferHilo(this);
    protected HiloAnimador animatorThread = new HiloAnimador(this);

    public EstructuraLienzo(ImageFrame frame, int nodeSize) {
        this.frame = frame;
        this.nodeSize = nodeSize;
    }

    public synchronized void addFunction(Funcion function) {
        this.functionVector.addElement(function);
        this.functionSuspended = false;
        this.notifyAll();
    }

    public void removeFunction(Funcion function) {
        this.functionVector.removeElement(function);
    }

    public int numberFunctions() {
        return this.functionVector.size();
    }

    public int getNodeSize() {
        return this.nodeSize;
    }

    protected synchronized void doFunctions() {
        int i = 0;
        while (this.functionSuspended) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        while (i < this.functionVector.size()) {
            if (((Funcion)this.functionVector.elementAt(i)).funcionTerminada()) {
                this.functionVector.removeElementAt(i);
                continue;
            }
            ((Funcion)this.functionVector.elementAt(i)).performFuncion();
            ++i;
        }
        this.cloneNodes();
        if (this.functionVector.size() == 0) {
            this.functionSuspended = true;
        }
    }

    protected abstract void cloneNodes();

    public abstract void loadBuffer();

    public abstract void paintAnimation();

    @Override
    public void update(Observable observed, Object arg) {
        if (arg instanceof String) {
            this.updateVector.addElement(arg);
        }
    }
}

