/*
 * Decompiled with CFR 0.152.
 */
package elaprendiz.estructuras;

import elaprendiz.estructuras.ArbolBinario;
import elaprendiz.estructuras.EstructuraLienzo;
import elaprendiz.estructuras.nodos.ArbolNodo;
import elaprendiz.graficos.imagenes.ImageFrame;
import elaprendiz.graficos.imagenes.ObjetoImagen;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;
import java.util.Vector;

public class LienzoBinario
extends EstructuraLienzo {
    static final double DEPTH_MULT = 3.0;
    static final double WIDTH_MULT = 0.75;
    Vector levelInfo = new Vector();
    int levelDepth = 80;
    int levelWidth = 20;
    int level = -1;
    public static final int LEVEL_ONE = 0;
    public static final int LEVEL_TWO = 1;
    public static final int LEVEL_THREE = 2;
    int treeNodes = 0;
    int totalNodes = 0;
    ArbolNodo[] rankList;
    ArbolNodo deleteNode;
    ObjetoImagen highLight;
    ObjetoImagen dragObject = null;

    public LienzoBinario(ImageFrame frame, int nodeSize) {
        super(frame, nodeSize);
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public void addToRankList(ArbolNodo node) {
        int rank = node.getRank();
        ArbolNodo leftChild = node.getLeftChild();
        ArbolNodo rightChild = node.getRightChild();
        if (leftChild != null) {
            this.addToRankList(leftChild);
        }
        if (rightChild != null) {
            this.addToRankList(rightChild);
        }
        if (this.rankList == null) {
            this.rankList = new ArbolNodo[rank];
        } else if (this.rankList.length < rank) {
            ArbolNodo[] tempList = new ArbolNodo[rank];
            System.arraycopy(this.rankList, 0, tempList, 0, this.rankList.length);
            this.rankList = tempList;
        }
        this.rankList[rank - 1] = node;
        int levelCheck = (int)Math.floor(Math.log(rank) / Math.log(2.0));
        if (levelCheck > this.level) {
            this.level = levelCheck;
        }
    }

    public void removeFromRankList(ArbolNodo node) {
        int startCheck = (int)Math.pow(2.0, this.level) - 1;
        int endCheck = (int)Math.pow(2.0, this.level + 1) - 1;
        ArbolNodo leastChild = node.getLeastChild();
        ArbolNodo greatestChild = node.getGreatestChild();
        boolean reduceLevel = true;
        int size = leastChild.getRank();
        if (size < greatestChild.getRank()) {
            size = greatestChild.getRank();
        }
        if (this.rankList != null && this.rankList.length >= size) {
            this.clearRank(node);
        }
        for (int i = startCheck; i < this.rankList.length && i < endCheck; ++i) {
            if (this.rankList[i] == null) continue;
            reduceLevel = false;
            break;
        }
        if (reduceLevel) {
            --this.level;
            if (this.level > -1 && this.levelInfo.size() > this.level) {
                this.levelInfo.removeElementAt(this.level);
            }
        }
    }

    protected void clearRank(ArbolNodo node) {
        ArbolNodo rightChild;
        ArbolNodo leftChild = node.getLeftChild();
        if (leftChild != null) {
            this.clearRank(leftChild);
        }
        if ((rightChild = node.getRightChild()) != null) {
            this.clearRank(rightChild);
        }
        this.rankList[node.getRank() - 1] = null;
    }

    public ArbolNodo getNodeAtRank(int nodeRank) {
        int rank = nodeRank - 1;
        if (rank > this.rankList.length) {
            return null;
        }
        return this.rankList[rank];
    }

    public void setLevelValues(int level, int[] values) {
        this.levelInfo.setElementAt(values, level);
    }

    public int[] getLevelValues(int level) {
        int size = this.levelInfo.size();
        if (size == level) {
            int[] values = new int[]{this.levelWidth, this.levelDepth, 0};
            this.levelInfo.addElement(values);
        }
        if (size < level) {
            return null;
        }
        return (int[])this.levelInfo.elementAt(level);
    }

    @Override
    protected synchronized void cloneNodes() {
        ObjetoImagen[] temp = new ObjetoImagen[this.totalNodes];
        int index = this.totalNodes - 1;
        int count = 0;
        if (this.highLight != null) {
            temp[count++] = new ObjetoImagen(this.highLight);
        }
        if (this.deleteNode != null) {
            temp[count] = new ArbolNodo(this.deleteNode);
        }
        ArbolNodo[] tempList = new ArbolNodo[this.rankList.length];
        for (int i = 0; i < tempList.length; ++i) {
            if (this.rankList[i] == null) continue;
            tempList[i] = new ArbolNodo(this.rankList[i]);
            int rankLeft = (i + 1) * 2 - 1;
            int rankRight = (i + 1) * 2;
            if (rankLeft < tempList.length) {
                tempList[i].setLeftChild(tempList[rankLeft]);
            }
            if (rankRight < tempList.length) {
                tempList[i].setRightChild(tempList[rankRight]);
            }
            if (this.rankList[i].getParent() != null) {
                tempList[i].setParent(tempList[(int)Math.floor((double)(i + 1) / 2.0) - 1]);
            }
            temp[index--] = tempList[i];
        }
        this.copyVector.addElement(temp);
        this.notifyAll();
    }

    @Override
    public boolean mouseDrag(Event evt, int x, int y) {
        if (this.dragObject == null) {
            for (int i = 0; i < this.rankList.length; ++i) {
                if (this.rankList[i] == null || !this.rankList[i].inBounds(x, y)) continue;
                this.dragObject = this.rankList[i];
                break;
            }
        }
        if (this.dragObject != null) {
            this.dragObject.move(x, y);
            this.repaint();
        }
        return true;
    }

    @Override
    public boolean mouseUp(Event evt, int x, int y) {
        if (this.dragObject != null) {
            this.dragObject = null;
        }
        return true;
    }

    @Override
    public synchronized void loadBuffer() {
        while (this.bufferLoaded || this.copyVector.size() == 0) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {}
        }
        Dimension d = this.size();
        if (this.offGraphics == null || this.offDimension.width != d.width || this.offDimension.height != d.height) {
            this.offDimension = d;
            this.offImage = this.createImage(d.width, d.height);
            this.offGraphics = this.offImage.getGraphics();
        }
        this.offGraphics.setColor(this.getBackground());
        this.offGraphics.fillRect(0, 0, d.width, d.height);
        ObjetoImagen[] objects = (ObjetoImagen[])this.copyVector.firstElement();
        this.copyVector.removeElementAt(0);
        for (int i = 0; i < objects.length; ++i) {
            if (objects[i] != null) {
                objects[i].draw(this.offGraphics);
                continue;
            }
            System.out.println("objects[" + i + "] is null");
        }
        this.bufferLoaded = true;
        this.notifyAll();
    }

    @Override
    public synchronized void paintAnimation() {
        while (!this.bufferLoaded || !this.paintingDone) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.paintingDone = false;
        this.repaint();
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public synchronized void paint(Graphics g) {
        if (this.bufferLoaded) {
            g.drawImage(this.offImage, 0, 0, this);
            if (this.updateVector.size() > 0) {
                if (!this.updateString.equals((String)this.updateVector.firstElement())) {
                    ((ArbolBinario)this.frame).updateLabel((String)this.updateVector.firstElement());
                    this.updateString = (String)this.updateVector.firstElement();
                }
                this.updateVector.removeElementAt(0);
            }
            this.bufferLoaded = false;
            this.paintingDone = true;
            this.notifyAll();
        } else {
            Dimension d = this.size();
            if (this.offGraphics == null || this.offDimension.width != d.width || this.offDimension.height != d.height) {
                this.offDimension = d;
                this.offImage = this.createImage(d.width, d.height);
                this.offGraphics = this.offImage.getGraphics();
            }
            this.offGraphics.setColor(this.getBackground());
            this.offGraphics.fillRect(0, 0, d.width, d.height);
            if (this.rankList != null) {
                for (int i = this.rankList.length - 1; i > -1; --i) {
                    if (this.rankList[i] == null) continue;
                    this.rankList[i].draw(this.offGraphics);
                }
            }
            g.drawImage(this.offImage, 0, 0, this);
        }
    }

    public ArbolNodo getRootNode() {
        if (this.rankList == null || this.rankList[0] == null) {
            return null;
        }
        return this.rankList[0];
    }

    public void addNode(ObjetoImagen node) {
        if (node instanceof ArbolNodo) {
            this.addToRankList((ArbolNodo)node);
            ++this.treeNodes;
            ++this.totalNodes;
        } else {
            this.highLight = node;
            ++this.totalNodes;
        }
    }

    public void removeNode(ObjetoImagen node) {
        if (node instanceof ArbolNodo) {
            this.removeFromRankList((ArbolNodo)node);
            --this.treeNodes;
            --this.totalNodes;
        } else {
            this.highLight = null;
            --this.totalNodes;
        }
    }

    public void setDeleteNode(ArbolNodo node) {
        this.deleteNode = node;
        ++this.totalNodes;
    }

    public void clearDeleteNode() {
        this.deleteNode = null;
        --this.totalNodes;
    }
}

