/*
 * Decompiled with CFR 0.152.
 */
package elaprendiz.estructuras.funciones;

import elaprendiz.estructuras.LienzoBinario;
import elaprendiz.estructuras.funciones.Resaltar;
import elaprendiz.estructuras.nodos.ArbolNodo;
import elaprendiz.graficos.funciones.Funcion;
import java.awt.Point;
import java.util.Observable;
import java.util.Observer;

public class Buscar
extends Funcion
implements Observer {
    LienzoBinario canvas;
    ArbolNodo buscarNodo;
    ArbolNodo trapseNode;
    boolean bloqueado = false;
    String actualizarInfo = "";

    public Buscar(int value, LienzoBinario canvas) {
        this.canvas = canvas;
        this.buscarNodo = new ArbolNodo(new Point(0, 0), canvas.frame, value);
    }

    @Override
    public void update(Observable observed, Object arg) {
        if (observed instanceof Resaltar) {
            this.bloqueado = false;
        }
    }

    @Override
    public void performFuncion() {
        if (this.bloqueado) {
            this.setChanged();
            this.notifyObservers(this.actualizarInfo);
        } else if (this.canvas.getRootNode() == null) {
            this.setChanged();
            this.notifyObservers("Search Failed");
            this.setChanged();
            this.notifyObservers(null);
            this.terminado = true;
        } else if (this.trapseNode == null) {
            this.trapseNode = this.canvas.getRootNode();
            this.actualizarInfo = "Beginning Search at Root Node : " + this.trapseNode.getValue();
            this.setChanged();
            this.notifyObservers(this.actualizarInfo);
            Resaltar highLight = new Resaltar(this.trapseNode, this.canvas);
            highLight.addObserver(this);
            this.canvas.addFunction(highLight);
            this.bloqueado = true;
        } else if (this.trapseNode.menorQue(this.buscarNodo)) {
            this.trapseNode = this.trapseNode.getLeftChild();
            if (this.trapseNode == null) {
                this.setChanged();
                this.notifyObservers("Search Failed");
                this.setChanged();
                this.notifyObservers(null);
                this.terminado = true;
            } else {
                Resaltar highLight = new Resaltar(this.trapseNode, this.canvas);
                highLight.addObserver(this);
                this.canvas.addFunction(highLight);
                this.actualizarInfo = "Node : " + this.trapseNode.getValue() + " Compared with" + " Value : " + this.buscarNodo.getValue();
                this.setChanged();
                this.notifyObservers(this.actualizarInfo);
                this.bloqueado = true;
            }
        } else if (this.trapseNode.mayorQue(this.buscarNodo)) {
            this.trapseNode = this.trapseNode.getRightChild();
            if (this.trapseNode == null) {
                this.setChanged();
                this.notifyObservers("Search Failed");
                this.setChanged();
                this.notifyObservers(null);
                this.terminado = true;
            } else {
                Resaltar highLight = new Resaltar(this.trapseNode, this.canvas);
                highLight.addObserver(this);
                this.canvas.addFunction(highLight);
                this.actualizarInfo = "Node : " + this.trapseNode.getValue() + " Compared with" + " Value : " + this.buscarNodo.getValue();
                this.setChanged();
                this.notifyObservers(this.actualizarInfo);
                this.bloqueado = true;
            }
        } else {
            this.actualizarInfo = "Nodo : " + this.trapseNode.getValue() + " Encontrado";
            this.setChanged();
            this.notifyObservers(this.actualizarInfo);
            this.setChanged();
            this.notifyObservers(this.trapseNode);
            this.terminado = true;
        }
    }
}

